/*
 * This example shows if a user's program may use an exit handler of the same
 * name twice within the program's environment.
 *
 * Used functions: RexxRegisterExitExe, RexxDeregisterExit
 *
 * EACH THREAD HAS ITS OWN EXIT HANDLER SET IN MULTITHREADING ENVIRONMENTS.
 */

/*
 * You have to say that you want the "Exit" stuff.
 */
#define INCL_RXSYSEXIT
#include "rexx_header.h"
#include <stdio.h>

/*
 * Have a look at "RexxExitHandler" in the header file.
 * This is a dummy, we need it for the test in the "main" function.
 */
static LONG APIENTRY exit1( LONG main_code,
                            LONG sub_code,
                            PEXIT data )
{
   (main_code = main_code);
   (sub_code = sub_code);
   (data = data);

   return (LONG) 0; /* whatever you want. This function isn't used */
}

/*
 * Have a look at "RexxExitHandler" in the header file.
 * This is a dummy, we need it for the test in the "main" function.
 */
static LONG APIENTRY exit2( LONG main_code,
                            LONG sub_code,
                            PEXIT data )
{
   (main_code = main_code);
   (sub_code = sub_code);
   (data = data);

   return (LONG) 0; /* whatever you want. This function isn't used */
}

static const volatile char *decodeRxExitCode( ULONG code )
{
   static char buf[20];

   switch ( code )
   {
      case RXEXIT_OK:         return( "RXEXIT_OK" );
      case RXEXIT_ERROR:      return( "RXEXIT_ERROR" );
      case RXEXIT_FAILURE:    return( "RXEXIT_FAILURE" );
      case RXEXIT_DUP:        return( "RXEXIT_DUP" );
      case RXEXIT_MAXREG:     return( "RXEXIT_MAXREG" );
      case RXEXIT_NOTREG:     return( "RXEXIT_NOTREG" );
      case RXEXIT_NOCANDROP:  return( "RXEXIT_NOCANDROP" );
      case RXEXIT_LOADERR:    return( "RXEXIT_LOADERR" );
      case RXEXIT_NOPROC:     return( "RXEXIT_NOPROC" );
      case RXEXIT_BADENTRY:   return( "RXEXIT_BADENTRY" );
      case RXEXIT_NOEMEM:     return( "RXEXIT_NOEMEM" );
      case RXEXIT_BADTYPE:    return( "RXEXIT_BADTYPE" );
      case RXEXIT_NOTINIT:    return( "RXEXIT_NOTINIT" );
      default:                break;
   }
   sprintf( buf, "code %u", (unsigned) code );
   return buf;
}

int main( void )
{
   printf( "Registering exit \"exit1\" as \"handler1\": %s\n",
           decodeRxExitCode( RexxRegisterExitExe( "handler1",
                                                  (PFN) exit1,
                                                  NULL ) ) );
   printf( "Registering exit \"exit1\" as \"handler1\": %s\n",
           decodeRxExitCode( RexxRegisterExitExe( "handler1",
                                                  (PFN) exit1,
                                                  NULL ) ) );
   printf( "Registering exit \"exit1\" as \"handler2\": %s\n",
           decodeRxExitCode( RexxRegisterExitExe( "handler2",
                                                  (PFN) exit1,
                                                  NULL ) ) );
   printf( "Registering exit \"exit2\" as \"handler1\": %s\n",
           decodeRxExitCode( RexxRegisterExitExe( "handler1",
                                                  (PFN) exit2,
                                                  NULL ) ) );

   printf("\n");

   printf( "Deregistering exit \"handler1\": %s\n",
           decodeRxExitCode( RexxDeregisterExit( "handler1", NULL ) ) );
   printf( "Deregistering exit \"handler1\": %s\n",
           decodeRxExitCode( RexxDeregisterExit( "handler1", NULL ) ) );
   printf( "Deregistering exit \"handler2\": %s\n",
           decodeRxExitCode( RexxDeregisterExit( "handler2", NULL ) ) );
   printf( "Deregistering exit \"handler2\": %s\n",
           decodeRxExitCode( RexxDeregisterExit( "handler2", NULL ) ) );

   return 0;
}
