/*
 * This example lets the interpreter execute some lines of Rexx code without
 * the use of any file holding the code. This is by using the "instore" method.
 *
 * Used functions: RexxStart, RexxFreeMemory
 * Used pseudo-functions: MAKERXSTRING, RXSTRPTR, RXNULLSTRING
 * Used structures: RXSTRING
 * You should have read: step2-1.c, step2-2.c
 *
 * FREEING STRINGS IS NOT PORTABLE.
 *
 * EACH THREAD HAS ITS OWN MEMORY POOL IN MULTITHREADING ENVIRONMENTS.
 */
#include "rexx_header.h"
#include <stdio.h>
#include <string.h>
#if !defined(REXXFREEMEMORY) || defined(UNKNOWN_INTERPRETER)
# include "rexxmem.h"
#endif

int main( void )
{
   ULONG retval;
   SHORT rc;
   static char *macro = "say '2**256 + 1 ='\r\n"
                        "numeric digits 99\r\n"
                        "say 2**256+1\r\n";
   RXSTRING instore[2];


   /*
    * You can pass a complete Rexx script from a program to the interpreter.
    * When doing so, you must not omit the script's file name. It is used as
    * the macro's or script's name. The file may or may not exist.
    *
    * The script's string may have as instruction terminators either newlines
    * or semicolons. Newlines are preferable; error messages don't refer to
    * "line 1" in all cases, as semicolons will do. And it is legal to address
    * any other than line 1.
    * NOTE: You should use \r\n in the PC world as the newline. Some
    *       interpreters other than Regina need this. Regina and most others
    *       accept \n even on DOS descending systems like OS/2 and Windows.
    *
    * The instore buffer (instore macro = script that is taken from a string
    * passed to the interpreter) will hold two(!!) RXSTRING elements. You
    * have to set the second one to NULL. See step2-5 for the reason.
    */
   MAKERXSTRING( instore[0], macro, strlen( macro ) );
   MAKERXSTRING( instore[1], NULL, 0 );
   retval = RexxStart( 0,            /* ArgCount */
                       NULL,         /* ArgList */
                       "in memory",  /* ProgramName */
                       instore,      /* Instore */
                       "Foo",        /* EnvName */
                       RXCOMMAND,    /* CallType */
                       NULL,         /* Exits */
                       &rc,          /* ReturnCode */
                       NULL );       /* Result */

   /*
    * After the return, instore[1] may be filled by "something". You should
    * free the buffer. See step2-5 for the reason. The buffer is allocated
    * by the interpreter and the caller of the interpreter should free it.
    */
   if ( !RXNULLSTRING( instore[1] ) )
      RexxFreeMemory( RXSTRPTR( instore[1] ) );

   return (int) ( retval ? retval : rc );
}
