/*
 * This example lets the interpreter execute a Rexx script with arguments.
 *
 * Used functions: RexxStart
 * Used pseudo-functions: MAKERXSTRING
 * Used structures: RXSTRING
 * You should have read: step2-1.c, step2-2.c
 */
#include "rexx_header.h"
#include <stdio.h>
#include <string.h>

int main( void )
{
   ULONG retval;
   SHORT rc;
   RXSTRING args[3];


   /*
    * Passing arguments is rather simple. You just have to create the
    * array of arguments and pass it to RexxStart.
    * We pass the three strings "Snoopy" "is" "Joe Cool".
    *
    * The whole argument allocating and address are under the responsibility
    * of the caller.
    *
    * If you want to pass more than one argument to the script, you have to
    * choose either RXFUNCTION or RXSUBROUTINE as the CallType.
    * Have a look at regina's command line flag "-a".
    */
   MAKERXSTRING( args[0], "Snoopy",   strlen( "Snoopy"   ) );
   MAKERXSTRING( args[1], "is",       strlen( "is"       ) );
   MAKERXSTRING( args[2], "Joe Cool", strlen( "Joe Cool" ) );

   retval = RexxStart( 3,            /* ArgCount */
                       args,         /* ArgList */
                       "step2.rexx", /* ProgramName */
                       NULL,         /* Instore */
                       "Foo",        /* EnvName */
                       RXFUNCTION,   /* CallType */
                       NULL,         /* Exits */
                       &rc,          /* ReturnCode */
                       NULL );       /* Result */

   return (int) ( retval ? retval : rc );
}
