/*
 * This example lets the interpreter execute a Rexx script.
 *
 * Used functions: RexxStart
 * Used structures: none
 * You should have read: none
 */
#include "rexx_header.h"
#include <stdio.h>

int main( void )
{
   ULONG retval;
   SHORT rc;

   /*
    * Most arguments to RexxStart can be NULL or 0 to indicate you don't want
    * to bother about.
    * You need
    * a) the script's name
    * b) the environment name, probably "COMMAND" or "bash". Check your
    *    interpreter's guide. NULL is valid, but you have to choose a filename
    *    with a suffix which is equivalent to the environment name.
    *    It is much clearer to set the value. The value doesn't have to exist.
    *    You may find this entry as one of the "ADDRESS ENVIRONMENT NAMES" in
    *    the interpreter's user's guide or you may define your own environment.
    * c) the calltype, either RXCOMMAND, RXFUNCTION or RXSUBROUTINE. We
    *    assume a RXCOMMAND here. This is the standard for this situation.
    *    You can choose the other values too, of course. A script can detect
    *    its purpose by this value. FUNCTIONs and SUBROUTINEs may have more
    *    than one argument passed.
    *    This value can be bitwise ORed by RXRESTRICTED. Dangerous operation
    *    are not allowed then. One can use this feature in HTML servers or
    *    other critical applications. RXRESTRICTED is an extension by Regina.
    * d) the returncode for some other interpreters. Regina can work with
    *    a NULL pointer, other interpreter may crash.
    *
    * The return value of RexxStart is a problem. There is no standard. You
    * can assume that the script has been executed in some kind, but you
    * can't really determine, what happened. You will usually get a non-null
    * return code if the script terminated due to a condition, e.g. "HALT"
    * or "SYNTAX".
    *
    * The return value of the script isn't reflected in the return value of
    * RexxStart.
    */
   retval = RexxStart( 0,            /* ArgCount */
                       NULL,         /* ArgList */
                       "step2.rexx", /* ProgramName */
                       NULL,         /* Instore */
                       "Foo",        /* EnvName, we need it later */
                       RXCOMMAND,    /* CallType */
                       NULL,         /* Exits */
                       &rc,          /* ReturnCode */
                       NULL );       /* Result */

   printf( "The return value of RexxStart is %d\n", (int) retval );

   return (int) ( retval ? retval : rc );
}
