/*
 * This example queries the version of Regina.
 *
 * Used functions: ReginaVersion, RexxFreeMemory
 * Used pseudo-functions: RXSTRPTR, RXSTRLEN, MAKERXSTRING
 * Used structures: RXSTRING
 * You should have read: none
 *
 * THIS EXAMPLE IS REGINA SPECIFIC!
 *
 * EACH THREAD HAS ITS OWN MEMORY POOL IN MULTITHREADING ENVIRONMENTS.
 */
#include "rexx_header.h"
#include <stdio.h>
#if !defined(REXXFREEMEMORY) || defined(UNKNOWN_INTERPRETER)
# include "rexxmem.h"
#endif

int main( void )
{
#ifdef USE_REGINA

   ULONG retval;
   char buf[20];
   RXSTRING rx;


   /*
    * There exist 3 different kinds of the usage of ReginaVersion.
    *
    * The simplest is a direct call without a valid argument:
    */
   retval = ReginaVersion( NULL );
   /*
    * We have to cast the output, nobody knows the true type of ULONG...
    */
   printf( "Regina's version is %u.%u\n",
           ( unsigned ) ( ( retval >> 8 ) & 0xFF ),
           ( unsigned ) ( retval & 0xFF ) );



   /*
    * If you need a more specific information, you can add a variables that
    * Regina shall fill. Passing 80 byte shall be sufficient in all cases,
    * but we provide just a buffer of 20 byte to show the correct usage in
    * case of a small buffer (big buffers are a boring example).
    * We ignore the return value. We already know its value.
    * MAKERXSTRING fills the structure's elements properly. You can use
    * RXSTRLEN and RXSTRPTR to access the fields.
    */
   MAKERXSTRING( rx, buf, sizeof( buf ) );
   ReginaVersion( &rx );
   printf( "The first %d characters of the full info are \"%.*s\"\n",
           (int) RXSTRLEN( rx ), (int) RXSTRLEN( rx ), RXSTRPTR( rx ) );
   /*
    * Regina doesn't terminate the version string in case of an insufficient
    * buffer. The construct "%.*s" allows to print a specific count of
    * characters in a string as you already know, hopefully...
    */



   /*
    * The final examples let Regina create a string for you of the needed
    * size. Don't forget to remove the passed back return value. You can
    * do so by either knowing which memory interface is used in which OS
    * or you simply use RexxFreeMemory. Regina knows the correct way.
    * Well, informing Regina that it shall allocate a string for you is
    * always done by setting the string pointer of an RXSTRING to NULL like
    * this:
    */
   MAKERXSTRING( rx, NULL, 0 );
   ReginaVersion( &rx );
   printf( "The full info is \"%.*s\"\n",
           (int) RXSTRLEN( rx ), RXSTRPTR( rx ) );
   RexxFreeMemory( RXSTRPTR( rx ) );

#else

   printf( "This program calls ReginaVersion() and this interpreter isn't Regina\n" );

#endif

   return 0;
}
