                           THE - The Hessling Editor
                                 Version 3.2
     
     ========================================================================
     INTRODUCTION
     ========================================================================
     
     THE is a text editor that uses both command line commands and key bindings
     to operate. It is intended to be similar to the VM/CMS System Product 
     Editor, XEDIT and to KEDIT from Mansfield Software.
     
     THE was originally written to be used by people already familiar with the 
     above editors. For this reason, this document provides limited information 
     on using THE, and concentrates more on reference material, such as command
     syntax and configuration.
     
     ========================================================================
     LICENSE
     ========================================================================
     THE (The Hessling Editor) is Copyright (C) 1990-2002 Mark Hessling
     
     Permission is granted to copy, distribute and/or modify the software
     under the terms of the GNU GENERAL PUBLIC LICENSE, Version 2
     or any later version published by the Free Software Foundation.
     See the file "COPYING" that is distributed with the software.
     
     Permission is granted to copy, distribute and/or modify this document
     under the terms of the GNU Free Documentation License, Version 1.1
     or any later version published by the Free Software Foundation;
     with no Invariant Sections, with no Front-Cover Texts, and no Back-Cover Texts.
     A copy of the license is included in the section entitled 
     "GNU Free Documentation License".
     
     ========================================================================
     THE BASICS
     ========================================================================
     
     The default screen displayed when THE starts consists of several areas:
     
     - a window which displays the contents of the file being editted. This is
       the <filearea>,
     - a <command line> from which commands may be issued,
     - a <prefix area> which shows line numbers and from which prefix commands
       can be issued
     - an <idline> which displays the file name, row/col etc. for the current 
       file and
     - a <status line> which indicates global status info like number of files
       being editted, time etc.
     
     When THE starts, the cursor is positioned on the <command line>. To move 
     between the <command line> and the <filearea>, the <CURSOR> HOME command is
     used. By default this command is bound to the HOME key (under DOS and OS/2),
     the DO key (on vt220s) and HOME (on xterms).
     
     To execute commands from the <command line> simply type the command and
     press the ENTER (or RETURN) key.
     
     To determine what keys are bound to what commands, execute the <SHOWKEY>
     command from the <command line>. As you press each key, THE will respond
     with the name of the key and any commands bound to that key.  To exit from
     the <SHOWKEY> command, press the spacebar.
     
     Key bindings may be changed for the current session by using the <DEFINE>
     command.  To keep key bindings between sessions, the <DEFINE> commands can
     be placed in a <profile> file, which is executed each time THE starts. For
     more information on this, see the next section; PROFILE FILE.
     
     It is possible to make THE look and behave more like either XEDIT or KEDIT.
     See the <SET COMPAT> command for further information.
     
     As mentioned before, this document provides little tutorial information. For
     those users who have a <REXX> enabled version of THE, a self-running
     demonstration <macro> is supplied which will provide a better explanation of
     the capabilities of THE, than any documentation could.  To run this demonstration,
     start THE as follows:
     
          +------------------------------
          the -p demo.the demo.txt
          +------------------------------
     
     ========================================================================
     COMMAND-LINE SWITCHES
     ========================================================================
     
     THE recognises many command-line switches when starting THE.  All switches are
     specified with a single '-' followed by a single character. The case of this
     character is relevant. Some switches take extra parameters; those that take
     optional extra parameters are indicated by the extra parameter being stated
     below in '[]'. The purpose of each of the switches is as follows:
     
     - -n Run THE without any profile. Normally THE tries to find a profile
       file and execute this on startup. This switch suppresses that search
       and execute and runs THE in its default mode. This switch is useful for
       determining if a bug in THE occurs only with certain user-specific
       customisations.
     - -m On ports of THE that support colour, this switch forces THE into
       monochrome mode. More a testing feature than a user feature.
     - -r This switch enabls THE to be run in readonly mode.  In this mode
       commands that alter the contents of a file are invalid.
     - -s On Unix platforms, this switch enables the writing of a core file if
       THE crashes.  Normally, THE traps any internal errors and exits gracefully.
       This switch is a testing feature rather than a user feature.
     - -b When you want to use THE as a non-interactive tool for manipulating
       the contents of one or mode files, this switch will disable any display
       of file contents and disable keybord interaction. Normally used in
       conjunction with a specific profile; see -p option.
     - -q Run quietly in batch mode. This will suppress the introductory
       informative message displayed when errors are encountered running in batch.
     - -k[fmt]  Allows 'soft label keys'. This allows the display of one (or two)
       lines at the bottom of the screen with 'buttons' intended to be used to
       represent function keys. These 'soft label keys' can be manipulated with 
       the <SET SLK> command.  The 'fmt' optional extra argument is a single digit
       representing the format of the display of the 'buttons'.
       o 1 - displays 8 'buttons' in a 4-4 layout
       o 2 - displays 8 'buttons' in a 3-2-3 layout
       o 3 - displays 12 'buttons' in a 4-4-4 layout
       o 4 - displays 12 'buttons' in a 4-4-4 layout with an index line
       o 5 - displays 10 'buttons' in a 5-5 layout
       Not all platforms support all 5 format options.
       On those ports of THE that are mouse-aware, the mouse can be pressed
       on a 'button', and the command assigned the the coresponding function
       key is executed.
     - -l line This switch specifies the line number to make current when THE 
       starts.
     - -c col This switch specifies the column number to make current when THE 
       starts.
     - -p profile Specifies the THE profile to run instead of the default
       profile. See next section for further details.
     - -a profile_arg Specifies the arguments that are passed to the profile
       specified with the -p switch.
     - -w width Specifies the maximum line width for a line in the current
       edit session. Can be overridded with the <SET WIDTH> command.
     - -u display_width THE can run as a binary editor. Specifying this switch
       tells THE to read in the file and display it in 'lines' that are
       'display_width' long.  All end-of-line characters in the file are
       ignored and are treated as other characters in the file.
     - -X X11_switches With the X11 port of THE, standard X11 switches can be
       specified with this switch to dynamically configure the way THE displays
       or behaves.  You can also specify XCurses-specific switches here as well.
       For more information on the XCurses switches available, consult the
       PDCurses documentation.
     - -1[dir] Tells THE to run in 'Single Instance Mode'. The first time THE is run with
       the -1 switch, its starts as normal. Subsequent executions of THE with the same -1
       command-line switch will not start a new instance of THE, rather it will edit
       the file(s) specified on the command-line in the currently running instance
       of THE.  You can optionally supply a directory with the -1 switch to specify where
       the THE FIFO (.thefifo) is created. If not supplied, the THE FIFO is created
       in the users $HOME directory.
       This feature is currently only available with the X11 port of the
       using XCurses 2.5 and greater.  If the first instance of THE with the -1
       switch crashes for any reason, subsequent attempts to run THE with the same -1
       switch will hang.  To fix this remove the FIFO and then run THE with the -1 
       switch again.
     
     After all the above switches are stated on the command line, THE treats
     the remainder of the command line as files or directories to edit.
     
     ========================================================================
     PROFILE FILE
     ========================================================================
     
     Various session defaults may be changed on startup for an individual by
     using a <profile> file. This file contains various commands that set the
     current environment, including key bindings. This <profile> file can also be
     used to process commands in batch mode. 
     
     THE will always execute a default profile. Appendix 1 defines the name of
     the default profile on different platforms.
     
     An example of a profile might be to change all occurrences of 'alligator' 
     to 'crocodile' in the file 'file.ext' in batch mode, a <profile> file; 
     'prf.prf' with the following commands would be used:
     
          +------------------------------
          'c/alligator/crocodile/ * *'
          'file'
          +------------------------------
     
     and the command
     
          +------------------------------
          the -b -p prf.prf file.ext
          +------------------------------
     
     would be issued.
     
     This changes the first string enclosed in delimiters (generally any
     non-alphabetic character not in the string itself) to
     the second string for every line (*) starting at the current line
     (0 initially) changing each occurrence on a line (*).
     
     Maybe you only want to change a string after the first line that contains
     the string 'donkey', but only change the second occurrence of that string.
     The profile commands would then be:
     
          +------------------------------
          '/donkey/'
          'c/alligator/crocodile/ * 1 2'
          'file'
          +------------------------------
     
     The change command uses a <target> specification as its first parameter
     after the string details. A <target> can be a number of lines, an absolute
     line number, BLANK, ALL or a string.
     
     Number of line targets consist of either a positive integer, for
     referencing lines toward the end of the file, negative for referencing
     toward the start of the file or '*', which is all the remaining lines in
     the file or '-*' which is all lines toward the start of the file.
     
     An absolute line number in the form of ':n' is the line number in a file,
     starting with line number 1.
     



     --------------------------------------------------------------------------
     
     
     ========================================================================
     COMMAND REFERENCE
     ========================================================================



     --------------------------------------------------------------------------
     COMMAND
          add - add blank line
     
     SYNTAX
          Add [n]
     
     DESCRIPTION
          The ADD command inserts 'n' blank lines after the <current line>,
          if issued from the <command line> or after the <focus line>,
          if issued from the <filearea> or <prefix area>.
     
          If <SET NEWLINES> is set to ALIGNED, the cursor is positioned in
          the column corresponding to the first column not containing a
          space in the line above.
     
          If <SET NEWLINES> is set to LEFT, the cursor is positioned in the
          first column.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     DEFAULT
          1
     
     SEE ALSO
          <SOS ADDLINE>
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          alert - display a user configurable dialog box with notification
     
     SYNTAX
          ALERT /prompt/ [EDITfield [/val/]] [TITLE /title/] [OK|OKCANCEL|YESNO|YESNOCANCEL] [DEFBUTTON n]
     
     DESCRIPTION
          The ALERT command is identical to the <DIALOG> command except that
          if <SET BEEP> is on, a beep is played.
     
          On exit from the ALERT command, the following Rexx variables are set:
     
               ALERT.0 - 2
               ALERT.1 - value of 'EDITfield'
               ALERT.2 - button selected as specified in the call to the command.
     
          The colours for the alert box are the same as for a dialog box, except
          the prompt area which uses the colour set by <SET COLOR> ALERT.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible. Does not support bitmap icons or font options.
     
     SEE ALSO
          <POPUP>, <DIALOG>, <READV>, <SET COLOR>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          all - select and display restricted set of lines
     
     SYNTAX
          ALL [rtarget]
     
     DESCRIPTION
          The ALL command allows for the selective display, and editting
          (subject to <SET SCOPE>) of lines that match the specified target.
          This target consists of any number of individual targets
          seperated by '&' (logical and) or '|' (logical or).
     
          For example, to display all lines in a file that contain the
          strings 'ball' and 'cat' on the same line or the named lines
          .fred or .bill, use the following command
     
          ALL /ball/ & /cat/ | .fred | .bill
     
          Logical operators act left to right, with no precedence for &.
     
          <rtarget> can also be specified as a regular expression. The syntax of
          this is "Regexp /re/". eg ALL R /[0-9].*$/
     
          ALL without any arguments, is the equivalent of setting the
          selection level of all lines in your file to 0 and running
          <SET DISPLAY> 0 0.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     SEE ALSO
          <SET SCOPE>, <SET DISPLAY>, <SET SELECT>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          backward - scroll backwards [n] screens
     
     SYNTAX
          BAckward [n|*]
     
     DESCRIPTION
          The BACKWARD command scrolls the file contents backwards through
          the file 'n' or '*' screens.
     
          If 0 is specified as the number of screens to scroll, the last
          line of the file becomes the <current line>.
     
          If the BACKWARD command is issued while the current line is
          the <Top-of-File line>, the last line of the file becomes the
          <current line>.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Does not support HALF or Lines options.
     
     DEFAULT
          1
     
     SEE ALSO
          <FORWARD>, <TOP>
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          bottom - move to the bottom of the file
     
     SYNTAX
          Bottom
     
     DESCRIPTION
          The BOTTOM command moves to the very end of the current file.
          The last line of the file is set to the <current line>.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     SEE ALSO
          <FORWARD>, <TOP>
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          cancel - quit from all unaltered files in the ring
     
     SYNTAX
          CANcel
     
     DESCRIPTION
          The CANCEL command exits from THE quickly by executing a <QQUIT>
          command for every file in the ring that does not have any
          outstanding alterations.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     SEE ALSO
          <CCANCEL>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          cappend - append text after column pointer
     
     SYNTAX
          CAppend [text]
     
     DESCRIPTION
          The CAPPEND command moves the column pointer to the end of the
          focus line and appends the specified 'text'.
     
          If no 'text' is specified, the column pointer moves to the first
          trailing space.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     SEE ALSO
          <CLAST>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          ccancel - qquit from all files in the ring
     
     SYNTAX
          CCancel
     
     DESCRIPTION
          The CCANCEL command exits from THE quickly by executing the <QQUIT>
          command for every file in the ring. Any changes made to any of
          the files since the last <SAVE> will be lost.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: N/A
     
     SEE ALSO
          <CANCEL>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          cdelete - delete text starting at column pointer
     
     SYNTAX
          CDelete [column target]
     
     DESCRIPTION
          The CDELETE command deletes characters starting from the current
          column pointer for the specified <'column target'>.
     
          If no <'column target'> is specified, the character at the column
          pointer is deleted.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     STATUS
          Incomplete. No string targets.



     --------------------------------------------------------------------------
     COMMAND
          cfirst - move column pointer to beginning of zone
     
     SYNTAX
          CFirst
     
     DESCRIPTION
          The CFIRST command moves the column pointer to the beginning of
          the zone.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     SEE ALSO
          <SET ZONE>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          change - change one string to another
     
     SYNTAX
          Change [/string1/string2/ [target] [n] [m]]
     
     DESCRIPTION
          The CHANGE command changes one string of text to another.
     
          The first parameter to the change command is the old and new
          string values, seperated by delimiters.
          The first non alphabetic character after the 'change' command
          is the delimiter.
     
          <'target'> specifies how many lines are to be searched for
          occurrences of 'string1' to be changed.
     
          'n' determines how many occurrences of 'string1' are to be
          changed to 'string2' on each line. 'n' may be specified as
          '*' which will result in all occurrences of 'string1' will
          be changed.  '*' is equivalent to the current WIDTH of the
          line.
     
          'm' determines from which occurrence of 'string1' on the line
          changes are to commence.
     
          If no arguments are supplied to the CHANGE command, the last
          change command, if any, is re-executed.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     DEFAULT
          1 1 1
     
     SEE ALSO
          <SCHANGE>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          cinsert - insert text starting at the column pointer
     
     SYNTAX
          CInsert text
     
     DESCRIPTION
          The CINSERT command inserts 'text' starting at the column position.
     
          'text' can include leading or trailing space characters. Thus
          CINSERT immediatley followed by 5 spaces, will insert 4 space
          characters. The first space character is the command seperator.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          clast - move the column pointer to end of zone
     
     SYNTAX
          CLAst
     
     DESCRIPTION
          The CLAST command moves the column pointer to the end of the
          zone.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     SEE ALSO
          <SET ZONE>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          clipboard - manipulate system clipboard
     
     SYNTAX
          CLIPBOARD COPY|CUT|PASTE|CLEAR
     
     DESCRIPTION
          The CLIPBOARD COPY command copies the text in the marked block into the
          system clipboard.
          The CLIPBOARD CUT command copies the text in the marked block into the
          system clipboard and then deletes the marked block.
          The CLIPBOARD PASTE command copies the text in the system clipboard
          into the current file at the cursor position.
          The CLIPBOARD CLEAR command clears the contents of the system clipboard.
     
          Only text objects in the system clipboard can be manipulated.
     
     COMPATIBILITY
          XEDIT: N/A.
          KEDIT: Compatible. Does not support APPEND or PUT options.
     
     STATUS
          InComplete.



     --------------------------------------------------------------------------
     COMMAND
          clocate - move the column pointer
     
     SYNTAX
          CLocate column target
     
     DESCRIPTION
          The CLOCATE command scans the file for the specified <'column target'>
          beginning with the column following (or preceding) the column pointer.
     
          Column targets can be specified as absolute targets, relative
          targets or string targets.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          cmatch - find matching bracket character
     
     SYNTAX
          CMATCH
     
     DESCRIPTION
          The CMATCH command searches for the matching bracket character to
          the character under the cursor.
     
          It handles nested sets of matching pairs.
          The matching character pairs are []{}<>().
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible.
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          cmsg - display text on command line
     
     SYNTAX
          CMSG [text]
     
     DESCRIPTION
          The CMSG command, primarily used in macros, displays 'text' on the
          command line.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     SEE ALSO
          <EMSG>, <MSG>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          command - execute a command without translation
     
     SYNTAX
          COMMAND command [options]
     
     DESCRIPTION
          The COMMAND command executes the specified 'command' without
          synonym or macro translation. THE does not attempt to execute
          the command as a <macro> even if <SET IMPMACRO> is ON. The
          command will be passed to the operating system if <SET IMPOS>
          is ON.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          compress - reduce spaces to tabs
     
     SYNTAX
          COMPress [target]
     
     DESCRIPTION
          The COMPRESS command reduces multiple occurrences of spaces and
          replaces them with tab characters in the <'target'> lines.
          The current tab columns (set by <SET TABS>) are used in
          determining where tab characters will replaces spaces.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     SEE ALSO
          <EXPAND>, <SET TABS>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          controlchar - allow control characters to be entered
     
     SYNTAX
          CONTROLChar
     
     DESCRIPTION
          The CONTROLCHAR command prompts the user to enter a control
          character; an ASCII character between 1 and 31 inclusive.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: N/A
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          copy - copies text from one position to another
     
     SYNTAX
          COPY target1 target2
          COPY BLOCK [RESET]
     
     DESCRIPTION
          With the first form of the COPY command, text is copied from
          'target1' to the line specified by 'target2'. Text can
          only be copied within the same view of the file.
     
          The second form of the COPY command copies text within the
          currently marked block to the current cursor position.
          The text can be in the same file or a different file.
     
     COMPATIBILITY
          XEDIT: COPY BLOCK not available.
          KEDIT: Adds extra functionality with [RESET] option.
                 With the cursor in the marked block this command in KEDIT
                 acts like <DUPLICATE> BLOCK.
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          coverlay - overlay text starting at the column pointer
     
     SYNTAX
          COVerlay text
     
     DESCRIPTION
          The COVERLAY command overlays the supplied 'text' onto the
          characters following the column position.
     
          Spaces in the 'text' do not destroy the existing characters.
     
          An underscore character "_" in the 'text' places a space in the
          corresponding character position. Therefore you cannot use the
          COVERLAY command to place underscores in a line.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          creplace - replace text starting at the column pointer
     
     SYNTAX
          CReplace text
     
     DESCRIPTION
          The CREPLACE command replaces the current characters after the
          column pointer with the supplied 'text'.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          cursor - move cursor to specified position
     
     SYNTAX
          CURsor Column
          CURsor Screen UP|DOWN|LEFT|RIGHT
          CURsor Screen row [col]
          CURsor [Escreen] UP|DOWN
          CURsor [Escreen|Kedit] LEFT|RIGHT
          CURsor [Escreen] row [col]
          CURsor CUA UP|DOWN|LEFT|RIGHT
          CURsor CMdline [n]
          CURsor HOME [SAVE]
          CURsor File line [col]
          CURsor GOTO line col
          CURsor Mouse
          CURsor Prefix
     
     DESCRIPTION
          The CURSOR command allows the user to specify where the cursor
          is to be positioned.
     
          CURSOR 'Column' moves the cursor to the current column of the
          <focus line>.
     
          CURSOR 'Screen' 'UP'|'DOWN'|'LEFT'|'RIGHT' moves the cursor in the
          indicated direction one line or column. If the cursor is
          positioned on the first or last line of the screen, the cursor
          wraps to the first or last enterable line. If the cursor is
          positioned on the left or right edges of the screen, the cursor
          moves to the left or right edge of the screen on the same line.
     
          CURSOR 'Screen' 'row' ['col'] is similar to CURSOR 'Escreen'
          'row' ['col'], but all coordinates are relative the the top left
          corner of the screen, not the top left corner of the
          <filearea>. Hence, 1,1 would be an invalid cursor position because
          it would result in the cursor being moved to the <idline>.
          Specification of 'row' and/or 'col' outside the boundaries of the
          logical window is regarded as an error.
     
          CURSOR ['Escreen'] 'UP'|'DOWN'|'LEFT'|'RIGHT' is similar to CURSOR
          'Screen' 'UP'|'DOWN'|'LEFT'|'RIGHT', except that where scrolling
          of the window is possible, then scrolling will take place.
     
          CURSOR ['Escreen'] 'row' ['col'] moves the cursor to the specified
          'row'/'col' position within the <filearea>. The top left corner of
          the <filearea> is 1,1.
          'row' and 'col' may be specified as '=', which will default to the
          current row and/or column position.
          If 'row' or 'col' are greater than the maximum number of rows or
          columns in the <filearea>, the cursor will move to the last
          row/column available.
          If the specified 'row' is a <reserved line>, <scale line> or <tab line>
          an error will be displayed.
          If the 'row' specified is above the <Top-of-File line> or below the
          <Bottom-of-File line> the cursor will be placed on the closest
          one of these lines.
     
          CURSOR 'Kedit' 'LEFT'|'RIGHT' mimics the default behaviour of
          CURL and CURR in KEDIT.
     
          CURSOR 'CUA' 'UP'|'DOWN'|'LEFT'|'RIGHT' moves the cursor in the
          indicated direction one line or column. The behaviour of the
          cursor at the the end of a line and at the start of a line is
          consistent with the Common User Access (CUA) definition.
     
          CURSOR 'CMdline' moves the cursor to the indicated column of the
          <command line>.
     
          CURSOR 'HOME' moves the cursor to the first column of the <command line>
          (if not on the command line), or to the last row/column of
          the <filearea> if on the <command line>. With the ['SAVE'] option,
          the cursor will move to the last row/column of the <filearea> or
          <prefix area> (which ever was the last position) if on the
          <command line>.
     
          CURSOR 'File' moves the cursor to the line and column of the file.
          If the line and/or column are not currently displayed, an error
          message is displayed.
     
          CURSOR 'GOTO' moves the cursor to the specified line and column
          of the file, whether the row and column are currently displayed or
          not.  If the 'line' and 'col' are currently displayed, then this
          command behaves just like CURSOR 'FIle'. If not, then the
          <current line> will be changed to the specified <line>.
     
          CURSOR 'Mouse' moves the cursor to the position where a mouse button
          was last activated.  This command is specific to THE.
     
          CURSOR 'PREFIX' moves the cursor to the first column of the <prefix area>
          (if not in the prefix area), or to the first column of the <filearea> if
          in the <prefix area>. This command has no effect if run from the <command line>.
          This command replaces TABPRE.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible. Added GOTO and PREFIX option.
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          define - assign one or many commands to a key or mouse event
     
     SYNTAX
          DEFine key-name [REXX] [command [args] [[#command [args]...]]]
          DEFine mouse-key-definition IN window [REXX] [command [args] [[#command [args]...]]]
     
     DESCRIPTION
          The DEFINE command allows the user to assign one or many 
          commands and optional parameter(s) to a key or a mouse button
          specification.
     
          Commands may be abbreviated.
     
          If multiple commands are assigned, then the LINEND setting
          must be ON and the LINEND character must match the character
          that delimits the commands at the time that the DEFINE command
          is executed. LINEND can be OFF at the time the key is pressed.
     
          With no arguments, any existing definition for that key is
          removed and the key reverts back to its default assignation (if
          it had any).
     
          'key-name' corresponds to the key name shown with the <SHOWKEY> command.
     
          If the optional keyword; 'REXX', is supplied, the remainder of the
          command line is treated as a Rexx macro and is passed onto the
          Rexx interpreter (if you have one) for execution.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible.
                 KEDIT does not allow multiple commands except as KEXX
                 macros.
     
     SEE ALSO
          <SHOWKEY>, <SET LINEND>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          delete - delete lines from a file
     
     SYNTAX
          DELete [target]
     
     DESCRIPTION
          The DELETE command removes lines from the current file.
          The number of lines removed depends on the <'target'> specified.
          Lines are removed starting with the <focus line>.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     DEFAULT
          1
     
     SEE ALSO
          <SOS DELLINE>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          dialog - display a user configurable dialog box
     
     SYNTAX
          DIALOG /prompt/ [EDITfield [/val/]] [TITLE /title/] [OK|OKCANCEL|YESNO|YESNOCANCEL] [DEFBUTTON n]
     
     DESCRIPTION
          The DIALOG command displays a dialog box in the middle of the screen
          with user-configurable settings.
     
          The mandatory 'prompt' parameter, is the text of a prompt displayed
          near the top of the dialog window. Up to 10 lines can be displayed
          by separating lines with a character (decimal 10).
     
          'EDITfield' creates a user enterable field, with a default value
          of 'val', if supplied. While the cursor is in the editfield, "normal"
          edit keys are in effect. See <READV> for more details on keys that are
          useable in the editfield.  The same keys that exit from the <READV>
          command also exit the editfield. On exit from the editfield, the
          first button becomes active.
     
          'title' specifies optional text to be displayed on the border of
          the dialog box.
     
          The type of button combination can be specifed as one of the following:
     
               OK - just an OK button is displayed
               OKCANCEL - an OK and a CANCEL button are displayed
               YESNO - a YES and a NO button are displayed
               YESNOCANCEL - a YES, a NO and a CANCEL button are displayed
     
          If no button combination is selected, an OK button is displayed.
     
          If 'DEFBUTTON' is specified, it indicates which of the buttons is to
          be set as the active button. This is a number between 1 and the
          number of buttons displayed. By default, button 1 is active. If
          'EDITfield' is specified, no active button is set.
     
          The active button can be selected by pressing the TAB key; to exit
          from the DIALOG, press the RETURN or ENTER key, or click the first
          mouse button on the required button.
     
          On exit from the DIALOG command, the following Rexx variables are set:
     
               DIALOG.0 - 2
               DIALOG.1 - value of 'EDITfield'
               DIALOG.2 - button selected as specified in the call to the command.
     
          The colours used for the dialog box are:
     
               Border          -  <SET COLOR> DIVIDER
               Prompt area     -  <SET COLOR> DIALOG
               Editfield       -  <SET COLOR> CMDLINE
               Inactive button -  <SET COLOR> BLOCK
               Active button   -  <SET COLOR> CBLOCK
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible. Does not support bitmap icons or font options.
     
     SEE ALSO
          <POPUP>, <ALERT>, <READV>, <SET COLOR>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          directory - list the specified directory as an editable file
     
     SYNTAX
          DIRectory [file specification]
     
     DESCRIPTION
          The DIRECTORY command displays all files matching the specified 
          'file specification'.
     
          When no parameter is supplied, all files in the current directory 
          are displayed subject to any <SET DIRINCLUDE> restrictions.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible.
     
     SEE ALSO
          <LS>, <SET DIRINCLUDE>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          dos - execute an operating system command
     
     SYNTAX
          DOS [command]
     
     DESCRIPTION
          The DOS command executes the supplied operating system 'command'
          or runs an interactive shell if no 'command' is supplied.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible.
     
     SEE ALSO
          <OS>, <!>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          dosnowait - execute an operating system command - no prompt
     
     SYNTAX
          DOSNowait command
     
     DESCRIPTION
          The DOSNOWAIT command executes the supplied operating system 
          command not waiting for the user to be prompted once the
          command has completed.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible.
     
     SEE ALSO
          <OSNOWAIT>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          dosquiet - execute an operating system command quietly
     
     SYNTAX
          DOSQuiet command
     
     DESCRIPTION
          The DOSQUIET command executes the supplied operating system 'command'
          as quietly as possible.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible.
     
     SEE ALSO
          <OSQUIET>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          down - move forward in the file a number of lines
     
     SYNTAX
          Down [relative target]
     
     DESCRIPTION
          The DOWN command moves the <current line> forwards the number of
          lines specified by the <'relative target'>. This <'relative target'> 
          can only be a positive integer or the character "*". 
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     DEFAULT
          1
     
     SEE ALSO
          <NEXT>, <UP>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          duplicate - duplicate lines
     
     SYNTAX
          DUPlicate [n [target|BLOCK]]
     
     DESCRIPTION
          The DUPLICATE command copies the number of lines extrapolated from
          <'target'> or the marked 'BLOCK', 'n' times.
     
     COMPATIBILITY
          XEDIT: Equivalent of DUPLICAT command.
          KEDIT: Compatible.
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          edit - edit another file or switch to next file
     
     SYNTAX
          Edit [file]
     
     DESCRIPTION
          The EDIT command allows the user to edit another 'file'. The new file
          is placed in the file <ring>. The previous file being edited remains
          in memory and can be returned to by issuing an EDIT command without
          any parameters. Several files can be edited at once, and all files
          are arranged in a ring, with subsequent EDIT commands moving through
          the ring, one file at a time.
     
     COMPATIBILITY
          XEDIT: Does not provide options switches.
          KEDIT: Does not provide options switches.
     
     SEE ALSO
          <THE>, <XEDIT>, <KEDIT>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          editv - set and retrieve persistent macro variables
     
     SYNTAX
          EDITV GET|PUT|GETF|PUTF var1 [var2 ...]
          EDITV SET|SETF var1 value1 [var2 value2 ...]
          EDITV SETL|SETLF|SETFL var1 value1
          EDITV LIST|LISTF [var1 ...]
     
     DESCRIPTION
          The EDITV command manipulates variables for the lifetime of the
          edit session or the file, depending on the subcommand used.
     
          Edit variables are useful for maintaining variable values from 
          one execution of a macro to another.
     
          EDITV GET, PUT, GETF and PUTF are only valid from within a macro
          as they reference Rexx variables.  All other subcommands are valid
          from within a macro or from the command line.
     
          EDITV GET sets a Rexx macro variable, with the same name as the
          edit variable, to the value of the edit variable.
     
          EDITV PUT stores the value of a Rexx macro variable as an edit
          variable.
     
          EDITV SET stores an edit variable with a value.
     
          EDITV SET can only work with variable values comprising a single
          space-seperated word.  To specify a variable value that contains
          spaces, use EDITV SETL.
     
          EDITV LIST displays the values of the specified edit variables, or
          all variables if no edit variables are specified.
     
          EDITV GETF, PUTF, SETF, SETLF, SETFL, and LISTF all work the same
          way as their counterparts without the F, but the variables are
          only available while the particular file is the current file.  This
          enables you to use the same edit variable name but with different
          values for different files.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          emsg - display message
     
     SYNTAX
          EMSG [message]
     
     DESCRIPTION
          The EMSG command displays an 'message' on the <message line>.
          This command is usually issued from a macro file.
     
     COMPATIBILITY
          XEDIT: Does not support [mmmnnns text] option
          KEDIT: Compatible
     
     SEE ALSO
          <CMSG>, <MSG>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          ENTER - execute a command
     
     SYNTAX
          ENTER [CUA]
     
     DESCRIPTION
          If the cursor is currently on the <command line>, the ENTER command
          executes the command currently displayed.
     
          If the cursor is in the <filearea>, the ENTER command results in
          a new line being added after the <focus line>, and the cursor
          placed on the next line depending on the value of <SET NEWLINES>.
          If <SET READONLY> is ON, then no new lines is added and the cursor
          is moved to the first column of the next line.
     
          If the cursor is in the <prefix area>, any pending prefix commands
          will be executed.
     
          With the optional 'CUA' argument, when in the <filearea>, the enter
          command acts like the <SPLIT>.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: N/A
     
     SEE ALSO
          <SOS EXECUTE>, <SET NEWLINES>, <SET READONLY>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          expand - expand tab characters to spaces
     
     SYNTAX
          EXPand [target]
     
     DESCRIPTION
          The EXPAND command converts all tab characters to spaces in the
          <'target'> depending on the size of a tab determined by the 
          <SET TABS> command.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     SEE ALSO
          <COMPRESS>, <SET TABS>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          extract - obtain various internal information about THE
     
     SYNTAX
          EXTract /item/[...]
     
     DESCRIPTION
          The EXTRACT command is used to relay information about settings
          within THE from within a Rexx macro. EXTRACT is only valid within
          a Rexx macro.
     
          The '/' in the syntax clause represents any delimiter character.
     
          For a complete list of 'item's that can be extracted, see the section;
          <QUERY, EXTRACT and STATUS>.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          ffile - force a FILE of the current file to disk
     
     SYNTAX
          FFile  [filename]
     
     DESCRIPTION
          The FFILE command writes the current file to disk to the current
          file name or to the supplied 'filename'.
          Unlike the <FILE> command, if the optional 'filename' exists, this
          command will overwrite the file.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible.
     
     DEFAULT
          With no parameters, the current file is written.
     
     SEE ALSO
          <FILE>, <SAVE>, <SSAVE>
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          file - write the current file to disk and remove from ring
     
     SYNTAX
          FILE  [filename]
     
     DESCRIPTION
          The FILE command writes the current file to disk to the current
          file name or to the supplied 'filename'.
          Unlike the <FFILE> command, if the optional 'filename' exists, this
          command will not overwrite the file.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     DEFAULT
          With no parameters, the current file is written.
     
     SEE ALSO
          <FFILE>, <SAVE>, <SSAVE>
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          fillbox - fill the marked block with a character
     
     SYNTAX
          FILLbox [c]
     
     DESCRIPTION
          The FILLBOX command fills the marked block with the specified
          character, 'c'. If no parameters are supplied and the command is run
          from the command line, then the block will be filled with spaces.
          If the command is not run from the command line, the user is
          prompted for a character to fill the box.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible.
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          find - locate forwards the line which begins with the supplied string
     
     SYNTAX
          Find [string]
     
     DESCRIPTION
          The FIND command attempts to locate a line towards the end of
          the file that begins with 'string'.
          If the optional 'string' is not supplied the last 'string' used
          in any of the family of find commands is used.
     
          'string' can contain two special characters:
     
               space - this will match any single character in the target line
               underscore - this will match any single space in the target line
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     SEE ALSO
          <FINDUP>, <NFIND>, <NFINDUP>
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          findup - locate backwards the line which begins with the supplied string
     
     SYNTAX
          FINDUp [string]
     
     DESCRIPTION
          The FINDUP command attempts to locate a line towards the start of
          the file that begins with 'string'.
          If the optional 'string' is not supplied the last 'string' used
          in any of the family of find commands is used.
     
          'string' can contain two special characters:
     
               space - this will match any single character in the target line
               underscore - this will match any single space in the target line
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     SEE ALSO
          <FIND>, <NFIND>, <NFINDUP>, <FUP>
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          forward - scroll forwards [n] screens
     
     SYNTAX
          FOrward [n]
     
     DESCRIPTION
          The FORWARD command scrolls the file contents forwards 'n' screens.
     
          If 0 is specified as the number of screens to scroll, the 
          <Top-of-File line> becomes the <current line>.
     
          If the FORWARD command is issued while the <current line> is the
          <Bottom-of-File line>, the <Top-of-File line> becomes the
          <current line>.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Does not support HALF or Lines options.
     
     DEFAULT
          1
     
     SEE ALSO
          <BACKWARD>, <TOP>
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          fup - locate backwards the line which begins with the supplied string
     
     SYNTAX
          FUp [string]
     
     DESCRIPTION
          The FUP command is a synonym for the <FINDUP> command.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     SEE ALSO
          <FIND>, <NFIND>, <NFINDUP>, <FINDUP>
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          get - insert into file the contents of specified file
     
     SYNTAX
          GET [filename] [fromline] [numlines]
          GET CLIP: [STREAM|BOX|LINE]
     
     DESCRIPTION
          The GET command reads a file into the current file, inserting
          lines after the current line.
     
          When no 'filename' is supplied the temporary file generated by the
          last <PUT> or <PUTD> command is used.
     
          When 'fromline' is specified, reading of the file begins at the
          line number specified.
          If 'fromline' is not specifed, reading begins at line 1.
     
          When 'numlines' is specified, reading of the file ends when the
          specified number of lines has been read.
          If 'numlines' is not specified, or 'numlines' is specified as '*',
          all files from the 'fromline' to the end of file are read.
     
          The second form implements interaction with the system clipboard.
          The optional parameter indicates how the contents of the
          clipboard is to be inserted into the file. If not supplied the
          contents of the clipboard is treated as a LINE block.
          This option only available for X11, OS/2 and Win32 ports of THE.
          (Incomplete)
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     SEE ALSO
          <PUT>, <PUTD>
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          help - edit help file for THE
     
     SYNTAX
          HELP
     
     DESCRIPTION
          The HELP command displays help for the editor.
          Uses THE_HELP_FILE environment variable to point to the help file.
          See Appendix 1 for details on this and other environemnt variables.
     
     COMPATIBILITY
          XEDIT: Similar in concept.
          KEDIT: Similar in concept.
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          hit - simulate hitting of the named key
     
     SYNTAX
          HIT key
     
     DESCRIPTION
          The HIT command enables the simulation of hitting the named 'key'.
          This is most useful from within a macro.
     
          Be very careful when using the HIT command with the <DEFINE> command.
          If you assign the HIT command to a key, DO NOT use the same key
          name. eg. DEFINE F1 HIT F1
          This will result in an infinite processing loop.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Similar, but more like the <MACRO> command.
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          input - insert the command line contents into the file
     
     SYNTAX
          Input [string]
     
     DESCRIPTION
          The INPUT command inserts the 'string' specified on the <command line>
          into the current file after the <current line>.
     
          If <SET INPUTMODE> FULL is in effect, and the INPUT command is
          entered on the command line with no arguments, THE is put into
          full input mode.  If the <prefix area> is on, it is turned off,
          the cursor moved to the <filearea> and blank lines inserted
          into the file from the <current line> to the end of the screen.
     
          To get out of full input mode, press the key assigned to the 
          <CURSOR> HOME [SAVE] command.
     
     COMPATIBILITY
          XEDIT: Does not provide full input mode option.
          KEDIT: Does not provide full input mode option.
     
     STATUS
          Complete. Except for full input mode capability.



     --------------------------------------------------------------------------
     COMMAND
          join - join a line with the line following
     
     SYNTAX
          Join [ALigned] [Column|CURSOR]
     
     DESCRIPTION
          The JOIN command makes one line out of the focus line and the
          line following.
     
          If 'Aligned' is specified, any leading spaces in the following line
          are ignored. If 'Aligned' is not specified, all characters, including
          spaces are added.
     
          If 'Column' (the default) is specified, the current line is joined
          at the current column location.
     
          If 'CURSOR' is specified, the focus line is joined at the cursor
          position.
     
     COMPATIBILITY
          XEDIT: Compatible.
                 Does not support Colno option
          KEDIT: Compatible.
     
     SEE ALSO
          <SPLIT>, <SPLTJOIN>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          kedit - edit another file or switch to next file
     
     SYNTAX
          Kedit [file]
     
     DESCRIPTION
          The KEDIT command allows the user to edit another 'file'. The new file
          is placed in the file <ring>. The previous file being edited remains
          in memory and can be returned to by issuing a KEDIT command without
          any parameters. Several files can be edited at once, and all files
          are arranged in a ring, with subsequent KEDIT commands moving through
          the ring, one file at a time.
     
     COMPATIBILITY
          XEDIT: Does not provide options switches.
          KEDIT: Does not provide options switches.
     
     SEE ALSO
          <EDIT>, <THE>, <XEDIT>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          left - scroll the screen to the left
     
     SYNTAX
          LEft [n|HALF]
     
     DESCRIPTION
          The LEFT command scrolls the screen to the left.
     
          If 'n' is supplied, the screen scrolls by that many columns.
     
          If 'HALF' is specified the screen is scrolled by half the number
          of columns in the <filearea>.
     
          If 'FULL' is specified the screen is scrolled by the number
          of columns in the <filearea>.
     
          If no parameter is supplied, the screen is scrolled by one
          column. 
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     SEE ALSO
          <RIGHT>, <RGTLEFT>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          locate - search for a target
     
     SYNTAX
          [Locate] target [command]
     
     DESCRIPTION
          The LOCATE command searches for the next or previous occurrence 
          of the specified <'target'>.  If no parameter is supplied, LOCATE
          uses the the last target specified. If no prior target has been
          specified, an error message is displayed. 
     
          <target> can also be specified as a regular expression. The syntax of 
          this is "Regexp /re/". eg LOCATE RE /[0-9].*$/
     
          With an optional 'command', this command is executed after finding
          the <'target'>.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          lowercase - change uppercase characters to lowercase
     
     SYNTAX
          LOWercase [target]
     
     DESCRIPTION
          The LOWERCASE command changes all uppercase characters in all 
          lines up to the <'target'> line to lowercase. All other characters
          remain untouched.
     
     COMPATIBILITY
          XEDIT: Equivalent of LOWERCAS command.
          KEDIT: Compatible.
     
     SEE ALSO
          <UPPERCASE>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          ls - list the specified directory as an editable file
     
     SYNTAX
          LS [file specification]
     
     DESCRIPTION
          The LS command displays all files matching the specified
          'file specification'.
     
          When no parameter is supplied, all files in the current directory 
          are displayed subject to any <SET DIRINCLUDE> restrictions.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible.
     
     SEE ALSO
          <DIRECTORY>, <SET DIRINCLUDE>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          macro - execute a macro command file
     
     SYNTAX
          MACRO [?] filename [arguments ...]
     
     DESCRIPTION
          The MACRO command executes the contents of the specified 'filename'
          as command line commands. The 'filename' can contain either a series
          of THE commands, or can be a Rexx program. The 'filename' is considered
          a <macro>.
     
          Rexx macros can be passed optional 'arguments'.
     
          With the optional '?' parameter, interactive tracing of the Rexx
          macro is possible, but this does not set interactive tracing on;
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          mark - mark a portion of text
     
     SYNTAX
          MARK Box [line1 col1 line2 col2]
          MARK Line [line1 line2]
          MARK Stream [line1 col1 line2 col2]
          MARK Column [col1 col2]
          MARK Word [line1 col1]
          MARK CUA [LEFT|RIGHT|UP|DOWN|START|END|FOrward|BAckward|TOP|Bottom|MOUSE]
     
     DESCRIPTION
          The MARK command marks a portion of text for later processing
          by a <COPY>, <MOVE> or <DELETE> command. This marked area is
          known as a <block>.
     
          When the MARK command is executed with the optional line/column
          arguments, these values are used to specify the position of the
          marked <block>.  Without the optional arguments, the position of
          the cursor is used to determine which portion of text is marked.
     
          'line1' and 'line2' specify the first or last line of the 
          marked block.
     
          'col1' and 'col2' specify the first or last column of the
          marked block.
     
          Any existing marked block will be replaced with the block specified
          in this command.
     
          When marking a <word block>, 'line1' and 'col1' refer to any position
          within the word.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Adds CUA, WORD, and COLUMN options and position specifiers.
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          modify - display current SET command for alteration
     
     SYNTAX
          MODify set-command
     
     DESCRIPTION
          The MODIFY command displays the current setting of a <SET> command
          on the command line enabling the user to change that setting.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     SEE ALSO
          <SET>, <QUERY>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          move - move a portion of text
     
     SYNTAX
          MOVE target1 target2
          MOVE BLOCK [RESET]
     
     DESCRIPTION
          The MOVE command copies the contents of a portion of the file to
          the same or a different file, and deletes the marked portion from 
          the original file.
     
          The first form of the MOVE command, moves the portion of the file
          specified by 'target1' to the line spcified by 'target2' in the
          same file.
     
          The second form of the MOVE command moves the contents of the marked
          <block> to the current cursor position. If the optional ['RESET']
          argument is supplied, the marked block is reset as though a
          <RESET> BLOCK command had been issued.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Adds extra functionality with [RESET] option.
     
     STATUS
          Incomplete. First form is not supported.



     --------------------------------------------------------------------------
     COMMAND
          msg - display message on error line
     
     SYNTAX
          MSG [message]
     
     DESCRIPTION
          The MSG command displays a 'message' on the <message line>.
          This command is usually issued from a macro file.
          This is similar to <EMSG>, but MSG does not sound the bell if 
          <SET BEEP> is on.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     SEE ALSO
          <CMSG>, <EMSG>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          next - move forward in the file a number of lines
     
     SYNTAX
          Next [relative target]
     
     DESCRIPTION
          The NEXT command moves the <current line> forwards the number of
          lines specified by the <relative target>. This <relative target> can
          only be a positive integer or the character "*". 
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     DEFAULT
          1
     
     SEE ALSO
          <DOWN>, <UP>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          nextwindow - switch focus of editing session to another file
     
     SYNTAX
          NEXTWindow
     
     DESCRIPTION
          The NEXTWINDOW command moves the focus of the editing session to
          the other screen (if <SET SCREEN> 2 is in effect) or to the next 
          file in the <ring>.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: N/A
     
     SEE ALSO
          <PREVWINDOW>, <EDIT>, <SET SCREEN>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          nfind - locate forwards the line which does NOT begin with the supplied string
     
     SYNTAX
          NFind [string]
     
     DESCRIPTION
          The NFIND command attempts to locate a line towards the end of
          the file that does NOT begin with 'string'.
          If the optional 'string' is not supplied the last 'string' used
          in any of the family of find commands is used.
     
          'string' can contain two special characters:
     
               space - this will match any single character in the target line
               underscore - this will match any single space in the target line
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     SEE ALSO
          <FIND>, <FINDUP>, <NFINDUP>
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          nfindup - locate backwards the line which does NOT begin with the supplied string
     
     SYNTAX
          NFINDUp [string]
     
     DESCRIPTION
          The NFINDUP command attempts to locate a line towards the start of
          the file that does NOT begin with 'string'.
          If the optional 'string' is not supplied the last 'string' used
          in any of the family of find commands is used.
     
          'string' can contain two special characters:
     
               space - this will match any single character in the target line
               underscore - this will match any single space in the target line
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     SEE ALSO
          <FIND>, <FINDUP>, <NFIND>, <NFUP>
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          nfup - locate backwards the line which does NOT begin with the supplied string
     
     SYNTAX
          NFUp [string]
     
     DESCRIPTION
          The NFUP command is a synonym for the <NFINDUP> command.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     SEE ALSO
          <FIND>, <FINDUP>, <NFIND>, <NFINDUP>
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          nomsg - execute a command suppressing any messages 
     
     SYNTAX
          NOMSG command [arguments]
     
     DESCRIPTION
          The NOMSG command executes the supplied 'command' but suppresses
          messages that would normally be displayed as a result of the 
          command.
     
          Optional 'arguments' may be passed to the 'command'.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible.
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          nop - no operation command
     
     SYNTAX
          NOP
     
     DESCRIPTION
          The NOP command does nothing. It is used as a means of turning
          off an assignment to a key.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: N/A
     
     SEE ALSO
          <DEFINE>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          os - execute an operating system command
     
     SYNTAX
          OS [command]
     
     DESCRIPTION
          The OS command executes the supplied operating system 'command'
          or runs an interactive shell if no 'command' is supplied.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Equivalent to DOS command.
     
     SEE ALSO
          <DOS>, <!>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          osnowait - execute an operating system command - no prompt
     
     SYNTAX
          OSNowait command
     
     DESCRIPTION
          The OSNOWAIT command executes the supplied operating system 
          'command' not waiting for the user to be prompted once the
          command has completed.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Equivalent of <DOSNOWAIT> command.
     
     SEE ALSO
          <DOSNOWAIT>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          osquiet - execute an operating system command quietly
     
     SYNTAX
          OSQuiet command
     
     DESCRIPTION
          The OSQUIET command executes the supplied operating system 'command'
          as quietly as possible.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Equivalent of <DOSQUIET> command.
     
     SEE ALSO
          <DOSQUIET>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          osredir - execute an operating system command and capture output
     
     SYNTAX
          OSRedir filename command [arguments ...]
     
     DESCRIPTION
          The OSREDIR command executes the supplied operating system 'command'
          and redirects output destined for STDOUT and STDERR to the specified 
          'filename'.
     
          Optional 'arguments' may be supplied to the 'command'.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: N/A
     
     SEE ALSO
          <OS>, <OSQUIET>, <OSNOWAIT>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          overlaybox - overlay marked block on current cursor position
     
     SYNTAX
          OVERLAYBox
     
     DESCRIPTION
          The OVERLAYBOX command overlays the contents of the marked <block>;
          <box block> or <line block>, over the characters or lines at the
          <focus line> and <focus column>.
     
          This command implies that only <box block>s are handled.  This used
          to be the case, and for compatibility reasons the name remains.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible.
     
     SEE ALSO
          <MOVE>, <COPY>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          popup - display popup menu
     
     SYNTAX
          POPUP [MOUSE|TEXT|CENTER|CENTRE|BELOW|ABOVE] [INITIAL n] [ESCAPE keyname] /item1[/item2/...]
     
     DESCRIPTION
          The POPUP command allows the user to create and display a popup
          menu containing a list of selectable options.
     
          The location of the popup menu is specified by the first parameter.
     
          'MOUSE' specifies that the top left corner of the popup menu is to
          be displayed where the mouse cursor currenlty is displayed. This option
          is only valid if the popup window is initiated from a macro assigned to
          a mouse event.
     
          'TEXT' specifies that the top left corner of the popup menu is to
          be displayed where the text cursor is displayed.
     
          'ABOVE' specifies that the bottom row of the popup window is to be displayed
          above the line where the text cursor is displayed.  The popup window will use at
          most from the line above the text cursor to the top of the screen.
     
          'BELOW' specifies that the top row of the popup window is to be displayed
          below the line where the text cursor is displayed.  The popup window will use at
          most from the line below the text cursor to the bottom of the screen.
     
          'CENTRE' or 'CENTER' specifies that the popup window is centred in the
          middle of the screen.  This option will use all of the screen to display the
          popup window if necessary.
     
          If the location is not specified, then the default is 'CENTRE'
     
          'INITIAL' specifies the item to be highlighted when the popup window
          is first displayed.  This value must be within the bounds of the items
          specified.
     
          'ESCAPE' specifies the keyname that can be used to quit from the popup
          window without making a selection.  By default 'q' will quit. Only keynames
          that are valid with the <DEFINE> command are allowed.
     
          On return from the popup menu, the following Rexx variables are set:
     
               popup.0 = 2
               popup.1 = Item selected or empty string if no item selected.
               popup.2 = Item number selected or zero if no item selected.
               popup.3 = Item number on which the cursor was last positioned.
     
          If mouse support is available, an item is selectable by clicking
          the first mouse button on the item.  To quit from the popup window
          without making a selection, click the mouse outside the popup
          window, or on the border of the window.
     
          Keyboard keys that take effect in the POPUP command are CURU, CURD,
          CURL, CURR, and ENTER.
     
          The colours used for the popup are:
     
               Border           -  <SET COLOR> DIVIDER
               Non-current line -  <SET COLOR> BLOCK
               Current line     -  <SET COLOR> CBLOCK
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: KEDIT does not support INITIAL, ESCAPE, ABOVE or BELOW options.
     
     SEE ALSO
          <DIALOG>, <ALERT>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          preserve - save various editor settings
     
     SYNTAX
          PREServe
     
     DESCRIPTION
          The PRESERVE command saves various editing settings at the time
          the command is issued.  These settings can then be restored by
          using the <RESTORE> command.
     
          The following view level settings are saved:
              ARBCHAR
              ARROW
              CASE
              CMDLINE
              CURLINE
              DISPLAY
              HEX
              HEXSHOW
              HIGHLIGHT
              IDLINE
              IMPMACRO
              IMPOS
              INPUTMODE
              LINEND
              MACRO
              MARGINS
              MSGLINE
              MSGMODE
              NEWLINE
              NUMBER
              POSITION
              PREFIX
              SCALE
              SCOPE
              SHADOW
              STAY
              SYNONYM
              TABLINE
              TABS
              VERIFY
              VERSHIFT
              WORD
              WORDWRAP
              ZONE
     
          The following file level settings are saved:
              AUTOSAVE
              BACKUP
              COLOUR
              ECOLOUR
              EOLOUT
              TABSOUT
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     SEE ALSO
          <RESTORE>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          prevwindow - switch focus of editing session to another file
     
     SYNTAX
          PREVWindow
     
     DESCRIPTION
          The PREVWINDOW command moves the focus of the editing session to
          the other screen (if <SET SCREEN> 2 is in effect) or to the previous
          file in the <ring>.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: N/A
     
     SEE ALSO
          <NEXTWINDOW>, <EDIT>, <SET SCREEN>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          print - send text to default printer or print spooler
     
     SYNTAX
          PRint [target] [n]
          PRint LINE [text]
          PRint STRING [text]
          PRint FORMfeed
          PRint CLOSE
     
     DESCRIPTION
          The PRINT command writes a portion of the current file to the default
          printer or print spooler, or text entered on the command line.
     
          PRINT [<'target'>] ['n']
             Sends text from the file contents up to the <'target'> to the printer
             followed by a CR/LF (DOS) or LF(UNIX) after each line.
             When ['n'] is specified, this sends a formfeed after ['n'] successive
             lines of text.
          PRINT 'LINE' ['text']
             Sends the remainder of the 'text' on the command line to the printer
             followed by a LF(UNIX), CR(MAC) or CR/LF (DOS).
          PRINT 'STRING' ['text']
             Sends the remainder of the 'text' on the command line to the printer
             without any trailing line terminator.
          PRINT 'FORMfeed'
              Sends a formfeed (^L) character to the printer.
          PRINT 'CLOSE'
              Closes the printer spooler.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible.
     
     SEE ALSO
          <SET PRINTER>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          put - write part of a file to another
     
     SYNTAX
          PUT [target] [filename]
     
     DESCRIPTION
          The PUT command writes a portion of the current file, defined by
          <'target'> to another file, either explicit or temporary.
     
          When no 'filename' is supplied the temporary file used for <PUT>
          and <GET> commands is overwritten.
     
          When a 'filename' is supplied the portion of the file written out
          is appended to the specified file.
     
          If 'CLIP:' is used in place of 'filename', the portion of the file
          specified by <'target'> is written to the clipboard.
          This option only available for X11, OS/2 and Win32 ports of THE.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     SEE ALSO
          <PUTD>, <GET>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          putd - write part of a file to another and delete
     
     SYNTAX
          PUTD [target] [filename]
     
     DESCRIPTION
          The PUTD command writes a portion of the current file, defined by
          <'target'> to another file, either explicit or temporary, and then
          deletes the lines written.
     
          When no 'filename' is supplied the temporary file used for <PUT>
          and <GET> commands is overwritten.
     
          When a 'filename' is supplied the portion of the file written out
          is appended to the specified file.
     
          If 'CLIP:' is used in place of 'filename', the portion of the file
          specified by <'target'> is written to the clipboard.
          This option only available for X11, OS/2 and Win32 ports of THE.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     SEE ALSO
          <PUT>, <GET>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          qquit - exit from the current file without saving changes
     
     SYNTAX
          QQuit
     
     DESCRIPTION
          The QQUIT command exits the user from the current file, whether
          changes made to the file have been saved or not.
     
          The previous file in the <ring> then becomes the current file.
     
          If the current file is the only file in the <ring>, THE terminates.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     SEE ALSO
          <QUIT>
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          query - display various option settings
     
     SYNTAX
          Query item
     
     DESCRIPTION
          The QUERY command displays the various settings for options set
          by THE.
     
          For a complete list of 'item's that can be extracted, see the section;
          <QUERY, EXTRACT and STATUS>.
     
          Results of the QUERY command are displayed at the top of the
          display window, and ignore the setting of <SET MSGLINE>.
     
     COMPATIBILITY
          XEDIT: Compatible functionality, but not all options.
          KEDIT: Compatible functionality, but not all options.
     
     SEE ALSO
          <STATUS>, <MODIFY>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          quit - exit from the current file if no changes made
     
     SYNTAX
          QUIT
     
     DESCRIPTION
          The QUIT command exits the user from the current file, provided
          that any changes made to the file have been saved, otherwise an
          error message is displayed.
     
          The previous file in the <ring> then becomes the current file.
     
          If the current file is the only file in the <ring>, THE terminates.
     
     COMPATIBILITY
          XEDIT: Does not support return code option.
          KEDIT: Compatible.
     
     SEE ALSO
          <QQUIT>
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          readv - read keystrokes and pass to macro
     
     SYNTAX
          READV Cmdline [initial text]
          READV KEY
     
     DESCRIPTION
          The READV command allows a Rexx macro to interact with the user
          by accepting either individual keystrokes ('KEY') or a complete
          line of text ('Cmdline').
     
          The READV 'Cmdline' can take optional 'initial text' to be
          displayed on the command line.
     
          The 'macro' obtains the entered information by setting Rexx
          variables. These are set as follows.
     
          'KEY' option:
     
               readv.0 = 4
               readv.1 = name of key (empty if unknown)
               readv.2 = ASCII value of key (null if not an ASCII code)
               readv.3 = curses key value (or ASCII code if an ASCII code)
               readv.4 = shift status (see below)
     
          'CMDLINE' option:
     
               readv.0 = 1
               readv.1 = contents of command line
     
          While editting the command in READV 'Cmdline', any key redefinitions
          you have made will be in effect.  Therefore you can use your
          "normal" editting keys to edit the line.  THE will allow the
          following commands to be executed while in READV 'Cmdline':
     
               <CURSOR> LEFT, <CURSOR> RIGHT, <CURSOR> DOWN, <CURSOR> UP,
               <SOS FIRSTCHAR>, <SOS ENDCHAR>, <SOS STARTENDCHAR>,
               <SOS DELEND>, <SOS DELCHAR>, <SOS DELCHAR>,
               <SOS TABB>, <SOS TABF>, <SOS TABWORDB>, <SOS TABWORDF>,
               <SOS UNDO>, <SOS DELWORD>, <SET INSERTMODE>, <TEXT>
     
          Either of the keys, ENTER, RETURN and NUMENTER will terminate
          READV 'Cmdline', irrespective of what THE commands have been
          assigned.
     
          The shift status of the key is an eight character string of
          0 or 1; each position represented by the following.
     
               Position
                  1      1 if INSERTMODE is ON
                  2      always 0
                  3      always 0
                  4      always 0
                  5      1 if ALT key pressed
                  6      1 if CTRL key pressed
                  7      1 if SHIFT key pressed
                  8      same as position 7
     
     COMPATIBILITY
          XEDIT: Similar to READ CMDLINE option.
          KEDIT: Compatible.
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          record - records all keystrokes into a macro file
     
     SYNTAX
          RECORD stop_key filename
     
     DESCRIPTION
          The RECORD command alows the user to record all keystrokes
          from the time that RECORD is executed until the first time
          that the specified 'stop_key' is hit.  All commands associated
          with each keystroke are stored into the specified 'filename'
          as THE commands. This 'filename' can then be run with the
          <MACRO> command.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: N/A
     
     SEE ALSO
          <MACRO>
     
     STATUS
          InComplete.



     --------------------------------------------------------------------------
     COMMAND
          recover - recover changed or deleted lines
     
     SYNTAX
          RECover [n|*]
     
     DESCRIPTION
          The RECOVER command restores the last 'n', or all '*' changed or
          deleted lines back into the body of the file.
     
     COMPATIBILITY
          XEDIT: Also recovers changes to lines, not just lines deleted.
          KEDIT: Compatible.
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          redit - re-edit the current file
     
     SYNTAX
          REDIT
     
     DESCRIPTION
          The REDIT command removes the current file from ring, discarding
          any changes since the file was last saved either explicitly with
          the <SAVE> command or implicitly by <SET AUTOSAVE>, and loads the
          file back into the ring.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: N/A
     
     SEE ALSO
          <CANCEL>, <SAVE>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          redraw - redraw the current screen
     
     SYNTAX
          REDRAW
     
     DESCRIPTION
          The REDRAW command redraws the current contents of the screen.
          This is usually used when some outside influence has affected
          the display.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: N/A
     
     SEE ALSO
          <REFRESH>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          refresh - refresh the contents of the current screen
     
     SYNTAX
          REFRESH
     
     DESCRIPTION
          The REFRESH command refreshes what is being displayed on the screen.
          This is usually used from within a <macro> to indicate the progress
          of the <macro>.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     SEE ALSO
          <REDRAW>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          repeat - repeat the last command
     
     SYNTAX
          REPEat [target]
     
     DESCRIPTION
          The REPEAT command advances the current line and executes the
          last command. It is equivalent to <NEXT> 1 (or <UP> 1) and <=> for
          the specified number of times specified by <'target'>.
     
          To determine how many lines on which to execute the last command,
          THE uses the target to determine how many lines from the current
          position to the target.  This is the number of times the last
          command is executed.
     
          If the last command to be executed, changes the current line,
          (because it has a target specification), the next execution of
          the last command will begin from where the previous execution of
          last command ended.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          replace - replace the current line with supplied text
     
     SYNTAX
          Replace [text]
     
     DESCRIPTION
          The REPLACE command replaces the <focus line> with the supplied
          'text'.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          reset - cancel the marked block or prefix commands or both
     
     SYNTAX
          RESet ALL|Block|Prefix|THIGHlight
     
     DESCRIPTION
          The RESET command unmarks any marked <block> or outstanding <prefix>
          commands, the text highlight area or all or the above.
     
     COMPATIBILITY
          XEDIT: Adds Block, All and THIGHlight options.
          KEDIT: Missing some features.
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          restore - restore various editor settings
     
     SYNTAX
          REStore
     
     DESCRIPTION
          The RESTORE command restores various editing settings at the time
          the command is issued.  These settings must have been saved with
          the <PRESERVE> command.
     
          If an attempt is made to restore settings that have not been preserved,
          an error results.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     SEE ALSO
          <PRESERVE>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          rexx - execute Rexx instructions
     
     SYNTAX
          REXX rexx instructions
     
     DESCRIPTION
          The REXX command allows  the user to enter Rexx instructions
          from the command line.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: N/A
     
     SEE ALSO
          <MACRO>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          rgtleft - scroll the screen to the left or right
     
     SYNTAX
          RGTLEFT [n]
     
     DESCRIPTION
          The RGTLEFT command scrolls the screen 'n' columns to the right
          if the value of <vershift> is less than or equal to 0, or if
          the value of <vershift> is greater than 0, the screen is
          scrolled 'n' columns to the left.
     
          If 'n' is not specified, the screen scrolls by three quarters the
          number of columns displayed.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     SEE ALSO
          <LEFT>, <RIGHT>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          right - scroll the screen to the right
     
     SYNTAX
          RIght [n|HALF|FULL]
     
     DESCRIPTION
          The RIGHT command scrolls the screen to the right.
     
          If 'n' is supplied, the screen scrolls by that many columns.
     
          If 'HALF' is specified the screen is scrolled by half the number
          of columns in the <filearea>.
     
          If 'FULL' is specified the screen is scrolled by the number
          of columns in the <filearea>.
     
          If no parameter is supplied, the screen is scrolled by one
          column.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     SEE ALSO
          <LEFT>, <RGTLEFT>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          save - save changes to current file
     
     SYNTAX
          SAVE [filename]
     
     DESCRIPTION
          The SAVE command writes the current file to disk. If a 'filename' is
          supplied, the current file is saved in that file, unless the file
          already exists which will result in an error message being
          displayed. Both 'Alterations' counters on the <idline> are
          reset to zero.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     SEE ALSO
          <SSAVE>, <FILE>, <FFILE>
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          schange - selectively change strings
     
     SYNTAX
          SCHange /string1/string2/ [target] [n] [m]
     
     DESCRIPTION
          The SCHANGE command changes one string of text to another only
          after confirming each individual change with the user.
     
          The first parameter to the change command is the old and new
          string values, seperated by delimiters.
          The allowable delimiters are '/' '\' and '@'.
     
          The second parameter is the <target>; how many lines are to be
          searched for occurrences of 'string1' to be changed.
     
          'n' determines how many occurrences of 'string1' are to be
          changed to 'string2' on each line.
     
          'm' determines from which occurrence of 'string1' on the line
          changes are to commence.
     
     COMPATIBILITY
          XEDIT: Functionally compatible, but syntax different.
          KEDIT: Compatible.
     
     DEFAULT
          1 1 1
     
     SEE ALSO
          <CHANGE>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          search - locate a string
     
     SYNTAX
          SEArch string target
     
     DESCRIPTION
          The SEARCH command searches for the next or previous occurrence
          of the specified <'string target'>.  If no parameter is supplied,
          SEARCH uses the the last target specified. If no prior target has been
          specified, an error message is displayed.
     
          The SEARCH command is similar to the <LOCATE> command, but it
          only locates strings or regular expressions. The advantage of SEARCH
          over LOCATE, is that targets are searched from the current <focus line>
          and <focus column> and if the found target is not currently in view,
          it will change the view to make the target visible. This behaviour is
          more compatible with other editors than the behaviour of <LOCATE>.
     
          When searching backwards, not only is the search done from the <focus line>
          to the end of file, but the searching within a line is done from right to left.
     
          <string target> can also be specified as a regular expression. The syntax of
          this is "Regexp /re/". eg SEARCH RE /[0-9].*$/
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: N/A
     
     SEE ALSO
          <LOCATE>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          set - execute various set commands
     
     SYNTAX
          SET set_command [set_command parameter(s) ...]
     
     DESCRIPTION
          The SET command is a front end to existing <SET> commands. It treats
          the first parameter it receives as a command and executes it.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          shift - move text left or right
     
     SYNTAX
          SHift Left|Right [n] [target]
     
     DESCRIPTION
          The SHIFT command moves text in the direction specified the number
          of columns 'n' for the specified <'target'> lines.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          showkey - display current key value and command assignation
     
     SYNTAX
          SHOWkey [ALL]
     
     DESCRIPTION
     
          With no parameter, the SHOWKEY command prompts the user to enter
          a key and responds with the key name and associated command
          (if applicable).
          To exit from SHOWKEY, press the space bar.
     
          With 'ALL' specified, a new file is added to the <ring> with all
          default key mappings and any key mappings assigned with the <DEFINE>
          command shown.  The key mappings are displayed as <DEFINE> commands.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: N/A
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          sort - sort selected lines in a file
     
     SYNTAX
          SORT target [[sort field 1] [...] [sort field 10]]
     
     DESCRIPTION
          The SORT command sort a portion of a file based on the 'sort field'
          specifications.
     
          A 'sort field' specification consists of:
     
               order flag   - [Ascending|Descending]
               left column  - left column of field to sort on
               right column - right column of field to sort on
     
          The right column MUST be >= left column.
     
          Only 10 sort fields are allowed.
     
          <'target'> can be any valid target including ALL, *, -*, and BLOCK.
     
     COMPATIBILITY
          XEDIT: XEDIT only allows ordering flag for all fields
          KEDIT: Compatible.
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          sos - execute various sos commands
     
     SYNTAX
          SOS sos_command [sos_command ...]
     
     DESCRIPTION
          The SOS command is a front end to existing <SOS> commands. It treats
          each parameter it receives as a command and executes it.
     
          The SOS command will execute each command until the list of commands
          has been exhausted, or until one of the commands returns a non-zero
          return code.
     
     COMPATIBILITY
          XEDIT: XEDIT only permits 1 command
          KEDIT: Compatible.
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          split - split a line into two lines
     
     SYNTAX
          SPlit [ALigned] [Column|CURSOR]
     
     DESCRIPTION
          The SPLIT command splits the <focus line> into two lines.
     
          If 'Aligned' is specified, the first non-blank character of the new
          line is positioned under the first non-blank character of the
          <focus line>.
     
          If 'Aligned' is not specified, the text of the new line starts in
          column 1.
     
          If 'Column' (the default) is specified, the current line is split at
          the current column location.
     
          If 'CURSOR' is specified, the focus line is split at the cursor
          position.
     
     COMPATIBILITY
          XEDIT: Compatible.
                 Does not support Before/After/Colno options
          KEDIT: Compatible.
     
     SEE ALSO
          <JOIN>, <SPLTJOIN>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          spltjoin - split/join two lines
     
     SYNTAX
          spltjoin
     
     DESCRIPTION
          The SPLTJOIN command splits the <focus line> into two or joins the
          <focus line> with the next line depending on the position of the
          cursor.
     
          If the cursor is after the last column of a line, the <JOIN>
          command is executed, otherwise the <SPLIT> command is executed.
     
          The text in the new line is aligned with the text in the <focus line>.
     
          This command can only be used by assigning it to a function key.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     SEE ALSO
          <JOIN>, <SPLIT>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          ssave - force SAVE to specified file
     
     SYNTAX
          SSave [filename]
     
     DESCRIPTION
          The SSAVE command writes the current file to disk. If a 'filename' is
          supplied, the current file is saved in that file, otherwise the
          current name of the file is used.
     
          If a 'filename' is supplied and that 'filename' already exists,
          the previous contents of that 'filename' will be replaced with the
          current file.
     
          Both 'Alterations' counters on the <idline> are reset to zero.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible.
     
     SEE ALSO
          <SAVE>, <FILE>, <FFILE>
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          status - display current settings of various variables
     
     SYNTAX
          STATus [filename]
     
     DESCRIPTION
          The STATUS command, without the optional 'filename', displays a full
          screen of current settings for various variables.
     
          With the 'filename', the STATUS command creates a file containing a
          series of <SET> commands with the current values of these settings.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible. KEDIT does not support ['filename'] option.
     
     SEE ALSO
          <QUERY>, <EXTRACT>, <MODIFY>
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          suspend - suspend THE and return to operating system
     
     SYNTAX
          SUSPend
     
     DESCRIPTION
          The SUSPEND command suspends the current editing session and
          returns control to the operating system. Under DOS and OS/2 this
          is the equivalent of <OSNOWAIT>. Under UNIX, the process gets placed
          in the background until it is brought to the foreground.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: N/A
     
     SEE ALSO
          <OSNOWAIT>
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          tabfile - edit the file under the file tab or shift FILETABS view
     
     SYNTAX
          TABFILE [+|-]
     
     DESCRIPTION
          The TABFILE makes the file pointed to by the mouse in the FILETABS
          window the current file.
     
          If run from the command line, without a paramter, the leftmost file 
          displayed in the FILETABS window will be made the current file.
     
     
          TABFILE -, shifts the files in the FILETABS window one file to the right.
          TABFILE +, shifts the files in the FILETABS window one file to the left.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: N/A
     
     SEE ALSO
          <SET FILETABS>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          tag - displays lines matching target in different colour
     
     SYNTAX
          TAG [More|Less] [rtarget]
     
     DESCRIPTION
          The TAG command is similar to the <ALL> command, in that it allows
          lines that match the specified target to be displayed.  Where it
          differs to <ALL> is that the lines that don't match are still
          displayed, but the lines that do match are displayed in the colour
          specified by <SET COLOUR> HIGHLIGHT.
          This target consists of any number of individual targets
          seperated by '&' (logical and) or '|' (logical or). 
     
          For example, to display all lines in a file that contain the 
          strings 'ball' and 'cat' on the same line or the named lines 
          .fred or .bill, use the following command
     
          TAG /ball/ & /cat/ | .fred | .bill
     
          Logical operators act left to right, with no precedence for &.
     
          TAG without any arguments displays all lines without any highlighting.
     
          If <SET HIGHLIGHT> is not set to TAGGED, then if the specified 'rtarget'
          is found, <SET HIGHLIGHT> is set to TAGGED.
     
          When the optional 'More' argument is specified, all lines that match
          the 'rtarget' are highlighted in addition to those already highlighted.
     
          When the optional 'Less' argument is specified, all lines that match
          the 'rtarget' and are currently highlighted have their highlighting
          removed.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible.
     
     SEE ALSO
          <ALL>, <SET HIGHLIGHT>, <SET COLOUR>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          text - simulate keyboard entry of characters
     
     SYNTAX
          TEXT text
     
     DESCRIPTION
          The TEXT command simulates the entry of 'text' from the
          keyboard. This command is actually called when you enter text
          from the keyboard.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible.
                 Does not allow trailing spaces in text.
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          the - edit another file or switch to next file
     
     SYNTAX
          THE [filename]
     
     DESCRIPTION
          The THE command allows the user to edit another 'file'. The new file
          is placed in the file <ring>. The previous file being edited remains
          in memory and can be returned to by issuing a THE command without
          any parameters. Several files can be edited at once, and all files
          are arranged in a ring, with subsequent THE commands moving through
          the ring, one file at a time.
     
     COMPATIBILITY
          XEDIT: Does not provide options switches.
          KEDIT: Does not provide options switches.
     
     SEE ALSO
          <XEDIT>, <EDIT>, <KEDIT>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          toascii - convert the target from EBCDIC to ASCII
     
     SYNTAX
          TOASCII [target]
     
     DESCRIPTION
          The TOASCII command converts the characters in the target from
          EBCDIC encoding to ASCII coding.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: N/A
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          top - move to the top of the file
     
     SYNTAX
          TOP
     
     DESCRIPTION
          The TOP command moves to the very start of the current file.
          The <Top-of-File line> is set to the <current line>.
     
          TOP is equivalent to <BACKWARD> *.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     SEE ALSO
          <BACKWARD>, <BOTTOM>
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          up - move backward in the file a number of lines
     
     SYNTAX
          Up [relative target]
     
     DESCRIPTION
          The UP command moves the <current line> backwards the number of
          lines specified by the <relative target>. This <relative target> can
          only be a positive integer or the character "*". 
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     DEFAULT
          1
     
     SEE ALSO
          <NEXT>, <DOWN>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          uppercase - change lowercase characters to uppercase
     
     SYNTAX
          UPPercase [target]
     
     DESCRIPTION
          The UPPERCASE command changes all lowercase characters in all
          lines up to the <'target'> line to uppercase. All other characters
          remain untouched.
     
     COMPATIBILITY
          XEDIT: Equivalent of UPPERCAS
          KEDIT: Compatible.
     
     SEE ALSO
          <LOWERCASE>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          xedit - edit another file or switch to next file
     
     SYNTAX
          Xedit [file]
     
     DESCRIPTION
          The XEDIT command allows the user to edit another 'file'. The new file
          is placed in the file <ring>. The previous file being edited remains
          in memory and can be returned to by issuing an XEDIT command without
          any parameters. Several files can be edited at once, and all files
          are arranged in a ring, with subsequent XEDIT commands moving through
          the ring, one file at a time.
     
     COMPATIBILITY
          XEDIT: Does not provide options switches.
          KEDIT: Does not provide options switches.
     
     SEE ALSO
          <EDIT>, <THE>, <KEDIT>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          ? - retrieve - return the next/prior command on the command line
     
     SYNTAX
          ?[+|?...]
     
     DESCRIPTION
          The ? command returns the next or prior command from the command
          line ring and displays it on the command line.
     
          With the ['+'] argument, the next command in the command ring is
          retrieved.
     
          With no arguments, the previous command entered on the command
          line is retrieved.
     
          With multiple, concatenated ?s as argument, the pervious command
          entered on the command line is retrieved corresponding to the
          number of ?s entered.
     
          For Example:
          The command; ????? will retrieve the fifth last command entered.
     
     COMPATIBILITY
          XEDIT: Compatible. Adds extra support for multiple ?s.
          KEDIT: See below..
          This command is bound to the up and down arrows when on the
          command line depending on the setting of <SET CMDARROWS>.
     
     SEE ALSO
          <SET CMDARROWS>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          = - re-execute the last command issued on the command line
     
     SYNTAX
          =
     
     DESCRIPTION
          The = command retrieves the most recently issued command from
          the <command line> and re-executes it.
     
     COMPATIBILITY
          XEDIT: Does not support optional [subcommand] option.
          KEDIT: Does not support optional [command] option.
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          ! - execute an operating system command
     
     SYNTAX
          ! [command]
     
     DESCRIPTION
          The ! command executes the supplied operating system 'command'
          or runs an interactive shell if no 'command' is supplied.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Equivalent to DOS command.
     
     SEE ALSO
          <DOS>, <OS>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          & - execute and re-display command
     
     SYNTAX
          &[command]
     
     DESCRIPTION
          The & command executes the supplied 'command' in the normal
          way, but when the command completes, instead of clearing
          the THE command line, the command, and the & are 
          re-displayed.  This makes it easy to repeat the same
          command, or make changes to it.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     
     
     ========================================================================
     SOS COMMAND REFERENCE
     ========================================================================



     --------------------------------------------------------------------------
     COMMAND
          sos addline - add blank line after focus line
     
     SYNTAX
          SOS ADDline
     
     DESCRIPTION
          The SOS ADDLINE command inserts a blank line in the file following
          the focus line. The cursor is placed in the column under the first
          non-blank in the focus line.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     SEE ALSO
          <SOS LINEADD>, <SOS DELLINE>
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          sos blockend - move cursor to end of marked block
     
     SYNTAX
          SOS BLOCKEnd
     
     DESCRIPTION
          The SOS BLOCKEND command moves the cursor to the ending line
          and column of the marked block.  If the cursor is on the command 
          line, the last line of the marked block becomes the current line.
     
          If no marked block is in the current file, an error is displayed.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible.
     
     SEE ALSO
          <SOS BLOCKSTART>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          sos blockstart - move cursor to start of marked block
     
     SYNTAX
          SOS BLOCKStart
     
     DESCRIPTION
          The SOS BLOCKSTART command moves the cursor to the starting line
          and column of the marked block.  If the cursor is on the command 
          line, the first line of the marked block becomes the current line.
     
          If no marked block is in the current file, an error is displayed.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible.
     
     SEE ALSO
          <SOS BLOCKEND>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          sos bottomedge - move cursor to bottom edge of FILEAREA
     
     SYNTAX
          SOS BOTTOMEdge
     
     DESCRIPTION
          The SOS BOTTOMEDGE command moves the cursor to the last 
          enterable line in the <filearea> or <prefix area>. If the cursor
          is on the command line, the cursor moves to the first 
          enterable line of the <filearea>.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Comaptible.
     
     SEE ALSO
          <SOS TOPEDGE>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          sos cuadelback - delete the character to the left of the cursor
     
     SYNTAX
          SOS CUADELBAck
     
     DESCRIPTION
          The SOS CUADELBACK command deletes the character to the right of the
          current cursor position.  It differs from <SOS DELBACK> in the case
          when the cursor is in the first column of the file and in the 
          FILEAREA. Then, the cursor first moves to the last character of the 
          previous line, and deletes this character.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: N/A
     
     SEE ALSO
          <SOS DELBACK>, <SOS CUADELCHAR>
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          sos cuadelchar - delete character under cursor
     
     SYNTAX
          SOS CUADELChar
     
     DESCRIPTION
          The SOS CUADELCHAR command deletes the character under the cursor.
          Text to the right is shifted to the left.
          It differs from <SOS DELCHAR> in the case when the cursor is after
          the last character of the line and in the FILEAREA. Then, the 
          next line is joined with the current line.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: N/A
     
     SEE ALSO
          <SOS CURDELBACK>, <SOS DELCHAR>
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          sos current - move cursor to current line
     
     SYNTAX
          SOS CURRent
     
     DESCRIPTION
          The SOS CURRENT command moves the cursor to the current column
          of the cursor line from any window.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible.
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          sos cursoradj - move first non-blank character to cursor
     
     SYNTAX
          SOS CURSORAdj
     
     DESCRIPTION
          The SOS CURSORADJ command moves text in the <focus line> so that
          the first non-blank character appears under the cursor position.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible.
     
     SEE ALSO
          <SOS CURSORSHIFT>
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          sos cursorshift - move text to right of cursor to cursor
     
     SYNTAX
          SOS CURSORSHIFT
     
     DESCRIPTION
          The SOS CURSORSHIFT command moves text in the <focus line> so that
          the first non-blank character to the right of the cursor is
          shifted to under the cursor position.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: N/A
     
     SEE ALSO
          <SOS CURSORADJ>
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          sos delback - delete the character to the left of the cursor
     
     SYNTAX
          SOS DELBAck
     
     DESCRIPTION
          The SOS DELBACK command moves the cursor one character to the left
          and deletes the character now under the cursor.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible.
     
     SEE ALSO
          <SOS DELCHAR>, <SOS CUADELCHAR>
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          sos delchar - delete character under cursor
     
     SYNTAX
          SOS DELChar
     
     DESCRIPTION
          The SOS DELCHAR command deletes the character under the cursor.
          Text to the right is shifted to the left.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible.
     
     SEE ALSO
          <SOS DELBACK>
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          sos delend - delete to end of line
     
     SYNTAX
          SOS DELEnd
     
     DESCRIPTION
          The SOS DELEND command deletes all characters from the current
          column to the end of line.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible.
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          sos delline - delete focus line
     
     SYNTAX
          SOS DELLine
     
     DESCRIPTION
          The SOS DELLINE command deletes the <focus line>.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     SEE ALSO
          <SOS LINEDEL>, <SOS ADDLINE>
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          sos delword - delete word at or right of cursor
     
     SYNTAX
          SOS DELWord
     
     DESCRIPTION
          The SOS DELWORD command deletes the word at or to the right
          of the current cursor position and any spaces following the 
          word.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible.
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          sos doprefix - execute any pending prefix commands
     
     SYNTAX
          SOS DOPREfix
     
     DESCRIPTION
          The SOS DOPREFIX command executes any pending prefix commands.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible.
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          sos edit - edit a file from directory list
     
     SYNTAX
          SOS EDIT
     
     DESCRIPTION
          The SOS EDIT command allows the user to edit a file, chosen from
          a directory list (the file DIR.DIR).
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible with default definition for Alt-X key.
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          sos endchar - move cursor to end of focus line
     
     SYNTAX
          SOS ENDChar
     
     DESCRIPTION
          The SOS ENDCHAR command moves the cursor to the position after
          the last character displayed in the current window.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible.
     
     SEE ALSO
          <SOS STARTENDCHAR>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          sos execute - move cursor to command line and execute command
     
     SYNTAX
          SOS EXecute
     
     DESCRIPTION
          The SOS EXECUTE command moves the cursor to the <command line>
          and executes any command that is displayed there.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible
     
     STATUS
          Complete. 



     --------------------------------------------------------------------------
     COMMAND
          sos firstchar - move cursor to first non-blank of field
     
     SYNTAX
          SOS FIRSTCHar
     
     DESCRIPTION
          The SOS FIRSTCHAR command moves the cursor to the first
          non-blank character of the cursor field
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible
     
     SEE ALSO
          <SOS FIRSTCOL>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          sos firstcol - move cursor to first column of field
     
     SYNTAX
          SOS FIRSTCOl
     
     DESCRIPTION
          The SOS FIRSTCOL command moves the cursor to the first
          column of the <cursor field>.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible
     
     SEE ALSO
          <SOS FIRSTCHAR>, <SOS LASTCOL>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          sos instab - shift text to next tab column
     
     SYNTAX
          SOS INSTAB
     
     DESCRIPTION
          The SOS INSTAB command shifts all text from the current cursor
          position in the <filearea> to the next tab column.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible.
     
     SEE ALSO
          <SET TABS>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          sos lastcol - move cursor to last column of field
     
     SYNTAX
          SOS LASTCOl
     
     DESCRIPTION
          The SOS LASTCOL command moves the cursor to the last column
          of the <cursor field>.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: N/A
     
     SEE ALSO
          <SOS FIRSTCOL>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          sos leftedge - move cursor to left edge of window
     
     SYNTAX
          SOS LEFTEdge
     
     DESCRIPTION
          The SOS LEFTEDGE command moves the cursor to the leftmost edge
          of the <filearea> if not on the command line or to the leftmost
          edge of the command line if on the <command line>.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible
     
     SEE ALSO
          <SOS RIGHTEDGE>, <SOS PREFIX>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          sos lineadd - add blank line after focus line
     
     SYNTAX
          SOS LINEAdd
     
     DESCRIPTION
          The SOS LINEADD command inserts a blank line in the file following
          the <focus line>. The cursor is placed in the column under the first
          non-blank in the <focus line>.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     SEE ALSO
          <SOS ADDLINE>, <SOS LINEDEL>
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          sos linedel - delete focus line
     
     SYNTAX
          SOS LINEDel
     
     DESCRIPTION
          The SOS LINEDEL command deletes the <focus line>.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     SEE ALSO
          <SOS DELLINE>, <SOS LINEADD>        
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          sos makecurr - make focus line the current line
     
     SYNTAX
          SOS MAKECURR
     
     DESCRIPTION
          The SOS MAKECURR command set the <current line> to the <focus line>.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible.
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          sos marginl - move cursor to the left margin column
     
     SYNTAX
          SOS MARGINL
     
     DESCRIPTION
          The SOS MARGINL command moves the cursor to the left margin
          column.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible.
                 Although, when issued from the command line, nothing
                 happens.
     
     SEE ALSO
          <SOS MARGINR>
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          sos marginr - move cursor to the right margin column
     
     SYNTAX
          SOS MARGINR
     
     DESCRIPTION
          The SOS MARGINR command moves the cursor to the right margin
          column.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible.
                 Although, when issued from the command line, nothing
                 happens.
     
     SEE ALSO
          <SOS MARGINL>
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          sos parindent - move cursor to the paragraph indent column
     
     SYNTAX
          SOS PARINDent
     
     DESCRIPTION
          The SOS PARINDENT command moves the cursor to the paragraph
          indent column.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible.
                 Although, when issued from the command line, nothing
                 happens.
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          sos pastecmdline - copy contents of marked block to command line
     
     SYNTAX
          SOS PASTECMDline
     
     DESCRIPTION
          The SOS PASTECMDLINE command copies the contents of the marked
          block to the command line at the current cursor location.
     
          Marked blocks that span one line only are allowed to be pasted.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: N/A
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          sos prefix - move cursor to leftmost edge of prefix area
     
     SYNTAX
          SOS PREfix
     
     DESCRIPTION
          The SOS PREFIX command moves the cursor to the leftmost edge
          of the <prefix area> if the cursor is in the <filearea> or the
          <prefix area>. The command has no effect when executed from the
          <command line>.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible
     
     SEE ALSO
          <SOS LEFTEDGE>, <SOS RIGHTEDGE>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          sos qcmnd - move cursor to command line and clear
     
     SYNTAX
          SOS QCmnd
     
     DESCRIPTION
          The SOS QCMND command moves the cursor to the first column of
          the <command line> and clears it.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible
     
     SEE ALSO
          <SOS EXECUTE>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          sos rightedge - move cursor to right edge of window
     
     SYNTAX
          SOS RIGHTEdge
     
     DESCRIPTION
          The SOS RIGHTEDGE command moves the cursor to the rightmost edge
          of the <filearea> if not on the command line or to the rightmost
          edge of the command line if on the <command line>.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible
     
     SEE ALSO
          <SOS LEFTEDGE>, <SOS PREFIX>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          sos settab - set a tab column at the cursor position
     
     SYNTAX
          SOS SETTAB
     
     DESCRIPTION
          The SOS SETTAB command sets a tab column at the position of the
          cursor in the <filearea>.  This command is ignored if issued 
          elsewhere.
          If a tab column is already set at the cursor position, the tab 
          column is cleared.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Kedit does not toggle the tab column, but only sets it.
     
     SEE ALSO
          <SET TABS>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          sos startendchar - move cursor to end/start of focus line
     
     SYNTAX
          SOS STARTENDChar
     
     DESCRIPTION
          The SOS STARTENDCHAR command moves the cursor to the first character
          displayed in the <cursor field>, if the cursor is after the last
          character displayed in the <cursor field>, or to the position after
          the last character displayed in the <cursor field>, if the cursor is
          anywhere else.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: N/A
     
     SEE ALSO
          <SOS ENDCHAR>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          sos tabb - move cursor to previous tab stop
     
     SYNTAX
          SOS TABB
     
     DESCRIPTION
          The SOS TABB command causes the cursor to move to the previous tab
          column as set by the <SET TABS> command.
          If the resulting column is beyond the left hand edge of the main
          window, the window will scroll half a window.
     
     COMPATIBILITY
          XEDIT: Does not allow arguments.
          KEDIT: Compatible. See below.
          Does not line tab to next line if before the left hand tab column.
     
     SEE ALSO
          <SET TABS>, <SOS TABF>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          sos tabf - move cursor to next tab stop
     
     SYNTAX
          SOS TABf
     
     DESCRIPTION
          The SOS TABF command causes the cursor to move to the next tab column
          as set by the <SET TABS> command.
          If the resulting column is beyond the right hand edge of the main
          window, the window will scroll half a window.
     
     COMPATIBILITY
          XEDIT: Does not allow arguments.
          KEDIT: Compatible. See below.
          Does not line tab to next line if after the right hand tab column.
     
     SEE ALSO
          <SET TABS>, <SOS TABB>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          sos tabfieldb - move cursor to previous enterable field
     
     SYNTAX
          SOS TABFIELDB
     
     DESCRIPTION
          The SOS TABFIELDB command causes the cursor to move to the first
          column of the current enterable field. If the cursor is already
          in the first column of the current field the cursor moves to the
          first column of the previous enterable field on the screen. 
          This command is intended to mimic the behaviour of the SHIFT-TAB 
          key on a 3270 terminal.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible.
     
     SEE ALSO
          <SOS TABFIELDF>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          sos tabfieldf - move cursor to next enterable field
     
     SYNTAX
          SOS TABFIELDf
     
     DESCRIPTION
          The SOS TABFIELDF command causes the cursor to move to the next 
          enterable field on the screen. This command is intended to
          mimic the behaviour of the TAB key on a 3270 terminal.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible.
     
     SEE ALSO
          <SOS TABFIELDB>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          sos tabwordb - move cursor to beginning of previous word
     
     SYNTAX
          SOS TABWORDB
     
     DESCRIPTION
          The SOS TABWORDB command causes the cursor to move to the first 
          character of the word to the left or to the start of the line if 
          no more words precede.
          If the resulting column is beyond the left hand edge of the 
          <filearea>, the window will scroll half a window.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible.
     
     SEE ALSO
          <SOS TABWORDF>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          sos tabwordf - move cursor to start of next word
     
     SYNTAX
          SOS TABWORDf
     
     DESCRIPTION
          The SOS TABWORDF command causes the cursor to move to the first 
          character of the next word to the right or to the end of the line 
          if no more words follow.
          If the resulting column is beyond the right hand edge of the
          <filearea>, the window will scroll half a window.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible.
     
     SEE ALSO
          <SOS TABWORDB>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          sos topedge - move cursor to top edge of filearea
     
     SYNTAX
          SOS TOPEdge
     
     DESCRIPTION
          The SOS TOPEDGE command moves the cursor to the first enterable
          line in the <filearea> or <prefix area>. If the cursor is on the 
          <command line>, the cursor moves to the first enterable line of 
          the <filearea>.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Comaptible.
     
     SEE ALSO
          <SOS BOTTOMEDGE>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          sos undo - undo changes to the current line
     
     SYNTAX
          SOS UNDO
     
     DESCRIPTION
          The SOS UNDO command causes the contents of the <focus line> (or the
          <command line>) to be reset to the contents before the cursor was
          positioned there.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible. 
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     
     
     ========================================================================
     SET COMMAND REFERENCE
     ========================================================================



     --------------------------------------------------------------------------
     COMMAND
          set alt - change alteration counts
     
     SYNTAX
          [SET] ALT [n] [m]
     
     DESCRIPTION
          The SET ALT command allows the user to change the alteration counts.
          This command is usually called from within a macro.
     
          The first number; 'n' sets the number of changes since the last
          AUTOSAVE was issued.
     
          The second number; 'm' sets the number of changes since the last
          SAVE or SSAVE command was issued.
     
          All options can be specified as the current EQUIVCHAR to retain the
          existing value.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     DEFAULT
          OFF
     
     SEE ALSO
          <SET EQUIVCHAR>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          set arbchar - set arbitrary character(s) for targets
     
     SYNTAX
          [SET] ARBchar ON|OFF [char1] [char2]
     
     DESCRIPTION
          Set the character to use as an 'arbitrary character' in string
          targets. The first arbitrary character matches a group of zero
          or more characters, the second will match exactly one character.
     
          All options can be specified as the current EQUIVCHAR to retain the
          existing value.
     
     COMPATIBILITY
          XEDIT: Compatible.
                 Single arbitrary character not supported.
          KEDIT: Compatible.
                 Arbitrary character not supported in <CHANGE> or <SCHANGE> commands.
     
     DEFAULT
          Off $ ?
     
     SEE ALSO
          <SET EQUIVCHAR>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          set autocolor - specifies which parser to use for syntax highlighting
     
     SYNTAX
          [SET] AUTOCOLOR mask parser [MAGIC]
     
     DESCRIPTION
          The SET AUTOCOLOR command allows the user to specify which syntax
          highlighting <parser> is to be used for which file masks.
     
          The 'parser' argument specifies a syntax highlighting <parser> that
          already exists, either as a default <parser>, or added by the user
          with <SET PARSER>.  The special parser name of '*NULL' can be
          specified; this will effectively remove the association between
          the <parser> and the file mask.
     
          The 'mask' argument specifies the file mask (or <magic number>) to
          associate with the specified parser.  The 'mask' can be any valid
          file mask for the operating system. eg *.c fred.* joe.?
     
          If the 'magic' option is specified, the 'mask' argument refers to
          the last element of the <magic number> that is specified in the
          first line of a Unix shell script comment. eg if the first line of
          a shell script contains:
          #!/usr/local/bin/rexx
          then the file mask argument would be specified as "rexx".
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Similar. KEDIT does not have MAGIC option.
     
     DEFAULT
          See <QUERY> AUTOCOLOR
     
     SEE ALSO
          <SET COLORING>, <SET ECOLOUR>, <SET PARSER>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          set autocolour - specifies which parser to use for syntax highlighting
     
     SYNTAX
          [SET] AUTOCOLOUR mask parser [MAGIC]
     
     DESCRIPTION
          The SET AUTOCOLOUR command is a synonym for the <SET AUTOCOLOR> command.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Similar. KEDIT does not have MAGIC option.
     
     DEFAULT
          See <QUERY> AUTOCOLOR
     
     SEE ALSO
          <SET AUTOCOLOR>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          set autosave - set autosave period
     
     SYNTAX
          [SET] AUtosave n|OFF
     
     DESCRIPTION
          The SET AUTOSAVE command sets the interval between automatic saves
          of the file, or turns it off altogether.  The interval 'n' refers
          to the number of alterations made to the file.  Hence a value of
          10 for 'n' would result in the file being automatically saved after
          each 10 alterations have been made to the file.
     
          It is not possible to set AUTOSAVE for 'psuedo' files such as the
          directory listing 'file', Rexx output 'file' and the key definitions
          'file'
     
     COMPATIBILITY
          XEDIT: Does not support [mode] option.
          KEDIT: Compatible.
     
     DEFAULT
          OFF
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          set autoscroll - set rate of automatic horizontal scrolling
     
     SYNTAX
          [SET] AUTOSCroll n|OFF|Half
     
     DESCRIPTION
          The SET AUTOSCROLL allows the user to set the rate at which automatic
          horizontal scrolling occurs.
     
          When the cursor reaches the last (or first) column of the <filearea>
          the <filearea> can automatically scroll if AUTOSCROLL is not 'OFF' and
          a <CURSOR> RIGHT or <CURSOR> LEFT command is issued.
          How many columns are scrolled is determined by the setting of AUTOSCROLL.
     
          If AUTOSCROLL is set to 'HALF', then half the number of columns in the
          <filearea> window are scrolled.  Any other value will result in that
          many columns scrolled, or the full width of the <filearea> window if
          the set number of columns is larger.
     
          Autoscrolling does not occur if the key pressed is assigned to
          <CURSOR> SCREEN LEFT or RIGHT, which is the case if <SET COMPAT> XEDIT
          key defintions are active.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible.
     
     DEFAULT
          HALF
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          set backup - indicate if a backup copy of the file is to be kept
     
     SYNTAX
          [SET] BACKup OFF|TEMP|KEEP|ON|INPLACE
     
     DESCRIPTION
          The SET BACKUP command allows the user to determine if a backup copy
          of the original file is to be kept when the file being edited is
          saved or filed.
     
          'KEEP' and 'ON' options are the same. 'ON' is
          kept for compatability with previous versions of THE.
     
          With 'OFF', the file being written to disk will replace an
          existing file. There is a chance that you will end up with neither
          the old version of the file or the new one if problems occur
          while the file is being written.
     
          With 'TEMP' or 'KEEP' options, the file being written is first
          renamed to the filename with a .bak extension. The file in memory
          is then written to disk. If 'TEMP' is in effect, the backup
          file is then deleted.
     
          With 'INPLACE', the file being written is first copied to a file
          with a .bak extension. The file in memory is then written to disk
          in place of the original.  This option ensures that all operating
          system file attributes are retained.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible.
     
     DEFAULT
          KEEP
     
     SEE ALSO
          <FILE>, <FFILE>, <SAVE>, <SSAVE>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          set beep - turn on or off the audible alarm when displaying errors
     
     SYNTAX
          [SET] BEEP ON|OFF
     
     DESCRIPTION
          The SET BEEP command allows the user to determine if an audible
          alarm is sounded when an error is displayed.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible.
     
     DEFAULT
          OFF
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          set boundmark - set bounds marker display
     
     SYNTAX
          [SET] BOUNDMARK OFF|Zone|TRunc|MARgins|TABs|Verify
     
     DESCRIPTION
          The BOUNDMARK command indicates if boundary markers are to be
          displayed and if so, where. Boundary markers are vertical lines
          drawn before or after certain columns within the <filearea>.
          This command only has a visible effect on GUI platforms, currently
          only the X11 port.
     
          'OFF' turns off the display of boundary markers.
     
          'ZONE' turns on the display of boundary markers, before the zone
          start column and after the zone end column.
     
          'TRUNC' turns on the display of boundary markers, after the
          truncation column. Not supported.
     
          'MARGINS' turns on the display of boundary markers, before the left
          margin and after the right margin.
     
          'TABS' turns on the display of boundary markers, before each tab
          column.
     
          'VERIFY' turns on the display of boundary markers, before each verify
          column. Not supported.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible, but no support for TRUNC or VERIFY option.
     
     DEFAULT
          Zone
     
     STATUS
          Incomplete



     --------------------------------------------------------------------------
     COMMAND
          set case - set case sensitivity parameters
     
     SYNTAX
          [SET] CASE Mixed|Lower|Upper [Respect|Ignore] [Respect|Ignore] [Respect|Ignore]
     
     DESCRIPTION
          The CASE command sets the editor's handling of the case of text.
     
          The first option (which is mandatory) controls how text is entered
          by the user. When 'LOWER' or 'UPPER' are in effect, the shift or caps
          lock keys have no effect on the text being entered. When 'MIXED' is
          in effect, text is entered in the case set by the use of the shift
          and caps lock keys.
     
          The second option determines how the editor determines if a string
          target matches text in the file when the target is used in a <LOCATE>
          command.  With 'IGNORE' in effect, a match is
          found irrespective of the case of the target or the found text.
          The following strings are treated as equivalent: the THE The ThE...
          With 'RESPECT' in effect, the target and text must be the same case.
          Therefore a target of 'The' only matches text containing 'The', not
          'THE' or 'ThE' etc.
     
          The third option determines how the editor determines if a string
          target matches text in the file when the target is used in a <CHANGE>
          command.  With 'IGNORE' in effect, a match is
          found irrespective of the case of the target or the found text.
          The following strings are treated as equivalent: the THE The ThE...
          With 'RESPECT' in effect, the target and text must be the same case.
          Therefore a target of 'The' only matches text containing 'The', not
          'THE' or 'ThE' etc.
     
          The fourth option determines how the editor determines the sort
          order of upper and lower case with the <SORT> command.
          With 'IGNORE' in effect, upper and lower case letters are treated as
          equivalent.
          With 'RESPECT' in effect, upper and lower case letters are treated as
          different values and uppercase characters will sort before lowercase
          characters.
     
          All options can be specified as the current EQUIVCHAR to retain the
          existing value.
     
     COMPATIBILITY
          XEDIT: Adds support for case significance in CHANGE commands.
          KEDIT: Adds support for LOWER option.
          Both:  Adds support for case significance in SORT command.
     
     DEFAULT
          Mixed Ignore Respect Respect
     
     SEE ALSO
          <SET EQUIVCHAR>
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          set clearerrorkey - specify which key clears the message line
     
     SYNTAX
          [SET] CLEARErrorkey *|keyname
     
     DESCRIPTION
          The SET CLEARERRORKEY command allows the user to specify which
          key clears the message line.  By default, any key pressed will
          cause the message line to be cleared.  The keyname specified
          is the name returned via the <SHOWKEY> command.
     
          As the <QUERY> command also uses the same mechanism for displaying
          its results as errors, then this command affects when results from
          the <QUERY> command are cleared.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: N/A
     
     DEFAULT
          *
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          set clearscreen - indicate if the screen is to be cleared on exit
     
     SYNTAX
          [SET] CLEARScreen ON|OFF
     
     DESCRIPTION
          The SET CLEARSCREEN command allows the user to request that the
          screen be cleared on exit from THE.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: N/A
     
     DEFAULT
          OFF
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          set clock - turn on or off display of time on status line
     
     SYNTAX
          [SET] CLOCK ON|OFF
     
     DESCRIPTION
          The SET CLOCK command turns on or off the display of the time on the
          <status line>.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible.
     
     DEFAULT
          ON
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          set cmdarrows - sets the behaviour of the up and down arrow keys
     
     SYNTAX
          [SET] CMDArrows Retrieve|Tab
     
     DESCRIPTION
          The SET CMDARROWS command determines the action that occurs when the
          up and down arrows keys are hit while on the <command line>.
     
          'RETRIEVE' will set the up and down arrows to retrieve the last or
          next command entered on the <command line>.
     
          'TAB' will set the up and down arrows to move to the last
          or first line respectively of the main window.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: N/A
     
     DEFAULT
          RETRIEVE
     
     SEE ALSO
          <CURSOR>, <?>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          set cmdline - sets the position of the command line.
     
     SYNTAX
          [SET] CMDline ON|OFF|Top|Bottom
     
     DESCRIPTION
          The SET CMDLINE command sets the position of the <command line>,
          either at the top of the screen, the bottom of the screen or off.
     
     COMPATIBILITY
          XEDIT: Compatible.
                 CMDLINE ON is equivalent to CMDLINE Bottom
          KEDIT: Compatible.
     
     DEFAULT
          BOTTOM
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          set color - set colours for display
     
     SYNTAX
          [SET] COLOR  area [modifier[...]] [foreground] [ON] [background]
          [SET] COLOR  area [modifier[...]] ON|OFF
     
     DESCRIPTION
          The SET COLOR command changes the colours or display attributes of
          various display areas in THE.
     
          Valid values for 'area':
     
               ALERT      - alert boxes; see <ALERT>
               Arrow      - command line prompt
               Block      - marked <block>
               BOUNDmarker- bound markers (GUI platforms only)
               CBlock     - <current line> if in marked <block>
               CHIghlight - highlighted line if the same as <current line>
               Cmdline    - <command line>
               CTofeof    - as for TOfeof if the same as <current line>
               CUrline    - the <current line>
               DIALOG     - dialog boxes; see <DIALOG>
               Divider    - dividing line between vertical split screens
               Filearea   - area containing file lines
               GAP        - the gap between the <prefix area> and <filearea>
               CGAP       - the gap between the <prefix area> and <filearea> - current
               HIghlight  - highlighted line
               Idline     - line containing file specific info
               Msgline    - error messages
               Nondisp    - Non-display characters (<SET ETMODE> OFF)
               Pending    - pending commands in <prefix area>
               PRefix     - <prefix area>
               CPRefix    - <prefix area> if the same as <current line>
               Reserved   - default for <reserved line>
               Scale      - line showing <scale line>
               SHadow     - hidden line marker lines
               SLK        - soft label keys
               STatarea   - line showing status of editing session
               Tabline    - line showing tab positions
               TOfeof     - <Top-of-File line> and <Bottom-of-File line>
               *          - All area (second format only)
     
          Valid values for 'foreground' and 'background':
     
               BLAck
               BLUe
               Brown
               Green
               GRAy
               GREy
               Cyan
               RED
               Magenta
               Pink
               Turquoise
               Yellow
               White
     
          Valid values for 'modifier':
     
               NORmal
               BLInk
               BOld
               BRIght
               High
               REVerse
               Underline
               DARK
               Italic - only available on X11 port with valid Italic font
     
          The second format of this command allows the user to turn on or off
          any of the valid modifiers.
     
          It is an error to attempt to set a colour on a mono display.
     
     COMPATIBILITY
          XEDIT: Functionally compatible. See below.
          KEDIT: Functionally compatible. See below.
          Does not implement all modifiers.
     
     DEFAULT
          Depends on compatibility mode setting and monitor type.
     
     SEE ALSO
          <SET COMPAT>, <SET COLOUR>, <SET ECOLOUR>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          set colour - set colours for display
     
     SYNTAX
          [SET] COLOUR area [modifier[...]] [foreground] [on background]
          [SET] COLOUR area [modifier[...]] ON|OFF
     
     DESCRIPTION
          The SET COLOUR command is a synonym for the <SET COLOR> command.
     
     COMPATIBILITY
          XEDIT: Functionally compatible. See below.
          KEDIT: Functionally compatible. See below.
          Does not implement all modifiers.
     
     DEFAULT
          Depends on compatibility mode setting and monitor type.
     
     SEE ALSO
          <SET COLOR>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          set coloring - enable or disable syntax highlighting
     
     SYNTAX
          [SET] COLORING ON|OFF [AUTO|parser]
     
     DESCRIPTION
          The SET COLORING command allows the user to turn on or off syntax
          highlighting for current file.  It also allows the <parser> used to be
          specified explicitly, or automatically determined by the file
          extension or <magic number>.
     
          ON turns on syntax highlighting for the current file, OFF turns it
          off.
     
          AUTO determines the <parser> to use for the current file based on the
          file extension.  The <parser> to use is controlled by the <SET AUTOCOLOR>
          command.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible.
     
     DEFAULT
          ON AUTO
     
     SEE ALSO
          <SET COLOURING>, <SET ECOLOUR>, <SET AUTOCOLOR>, <SET PARSER>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          set colouring - enable or disable syntax highlighting
     
     SYNTAX
          [SET] COLOURING ON|OFF [AUTO|parser]
     
     DESCRIPTION
          The SET COLOURING command is a synonym for the <SET COLORING> command.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible.
     
     DEFAULT
          ON AUTO
     
     SEE ALSO
          <SET COLORING>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          set compat - set compatibility mode
     
     SYNTAX
          [SET] COMPat The|Xedit|Kedit|KEDITW|Ispf|= [The|Xedit|Kedit|KEDITW|Ispf|=] [The|Xedit|Kedit|KEDITW|Ispf|=]
     
     DESCRIPTION
          The SET COMPAT command changes some settings of THE to make it
          more compatible with the look and/or feel of XEDIT, KEDIT,
          KEDIT for Windows, or ISPF.
     
          This command is most useful as the first <SET> command in a
          profile file. It will change the default settings of THE to
          initially look like the chosen editor. You can then make any
          additional changes in THE by issuing other <SET> commands.
     
          It is recommended that this command NOT be executed from the
          command line, particularly if you have 2 files being displayed
          at the same time.  Although the command works, things may look
          and behave strangely :-)
     
          The first parameter affects the look of THE, the second parameter
          affects the feel of THE, and the third parameter determines
          which default function key settings you require.
     
          Any of the parameters can be specified as =, which will not
          change that aspect of THE's compatability.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: N/A
     
     DEFAULT
          THE THE THE
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          set ctlchar - define control character attributes
     
     SYNTAX
          [SET] CTLchar OFF
          [SET] CTLchar char Escape | OFF
          [SET] CTLchar char Protect|Noprotect [modifier[...]] [fore [ON back]]
     
     DESCRIPTION
          The SET CTLCHAR command defines control characters to be used when
          displaying a <reserved line>.  Control characters determine how parts
          of a <reserved line> are displayed.
     
          See <SET COLOUR> for valid values for 'modifier', 'fore' and 'back'.
     
          The 'Protect' and 'Noprotect' arguments are ignored.
     
     COMPATIBILITY
          XEDIT: Similar, but does not support all parameters.
          KEDIT: N/A.
     
     DEFAULT
          OFF
     
     SEE ALSO
          <SET COLOUR>, <SET RESERVED>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          set curline - set position of current line on screen
     
     SYNTAX
          [SET] CURLine [ON] M[+n|-n] | [+|-]n
     
     DESCRIPTION
          The SET CURLINE command sets the position of the <current line> to
          the physical screen line specified by supplied arguments.
     
          The first form of parameters is:
     
          M[+n|-n]
          this sets the <current line> to be relative to the middle of
          the screen. A positive value adds to the middle line number,
          a negative subtracts from it.
          eg. M+3 on a 24 line screen will be line 15
              M-5 on a 24 line screen will be line 7
     
          The second form of parameters is:
     
          [+|-]n
          this sets the <current line> to be relative to the top of the
          screen (if positive or no sign) or relative to the bottom
          of the screen if negative.
          eg. +3 or 3 will set current line to line 3
              -3 on a 24 line screen will be line 21
     
          If the resulting line is outside the bounds of the screen
          the position of the current line will become the middle line
          on the screen.
     
          It is optional to specify the ON argument.
     
          It is an error to try to position the CURLINE on the same
          line as a line already allocated by one of <SET HEXSHOW>,
          <SET RESERVED>, <SET SCALE> or <SET TABLINE>.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     DEFAULT
          M
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          set cursorstay - set on or off the behaviour of the cursor on a scroll
     
     SYNTAX
          [SET] CURSORSTay ON|OFF
     
     DESCRIPTION
          The SETCURSORSTAY command allows the user to set the behaviour of
          the cursor when the file is scrolled with a <FORWARD> or <BACKWARD>
          command.
     
          Before this command was introduced, the position of the cursor
          after the file was scrolled depended on <SET COMPAT>; for
          THE, the cursor moved to the current line, for XEDIT and KEDIT
          modes the cursor stayed on the same screen line.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: N/A
     
     DEFAULT
          ON
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          set defsort - specify the order in which files appear in DIR.DIR
     
     SYNTAX
          [SET] DEFSORT OFF|DIRectory|Size|Date|Time|Name [Ascending|Descending]
     
     DESCRIPTION
          The SET DEFSORT command allows the user to determine the order
          in which files appear in a DIR.DIR file.
     
          'Directory' specifies that directories within the current directory
          are shown before other files.
     
          'Size' specifies that the size of the file determines the order
          in which files are displayed.
     
          'Date' specifies that the date of the last change to the file
          determines the order in which files are displayed. If the dates
          are the same, the time the file was last changed is used as a
          secondary sort key.
     
          'Time' specifies that the time of the file determines the order
          in which files are displayed.
     
          'Name' specifies that the name of the file determines the order in
          which files are displayed. This is the default.  Files are sorted
          by name as a secondary sort key when any of the above options are
          specified and two files have equal values for that sort option.
     
          'OFF' indicates that no ordering of the files in the directory
          is performed.  On directories with a large number of files, this
          option results in a displayed DIR.DIR file much quicker than any
          sorted display.
     
          The second parameter specifies if the sort order is ascending or
          descending.
     
          If this command is issued while the DIR.DIR pseudo file is the current
          file, the settings are applied immediately.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Similar in functionality.
     
     DEFAULT
          NAME ASCENDING
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          set dirinclude - set the file mask for directory command
     
     SYNTAX
          [SET] DIRInclude *
          [SET] DIRInclude [Normal] [Readonly] [System] [Hidden] [Directory]
     
     DESCRIPTION
          The DIRINCLUDE command sets the file mask for files that will be
          displayed on subsequent DIRECTORY commands. The operand "*" will
          set the mask to all files, the other options will set the
          mask to include those options specified together with "normal"
          files eg.
     
             DIRINCLUDE R S
     
          will display readonly and system files together with "normal" files
          the next time the DIRECTORY command is issued.
     
          The effects of DIRINCLUDE are ignored in the Unix version.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: N/A
     
     DEFAULT
          *
     
     SEE ALSO
          <DIRECTORY>, <LS>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          set display - specify which level of lines to display
     
     SYNTAX
          [SET] DISPlay n [m|*]
     
     DESCRIPTION
          The SET DISPLAY command sets the selection level for lines to be
          displayed on the screen.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     DEFAULT
          0 0
     
     SEE ALSO
          <SET SCOPE>, <SET SELECT>, <ALL>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          set ecolor - set colors for syntax highlighting
     
     SYNTAX
          [SET] ECOLOR char [modifier[...]] [foreground] [on background]
          [SET] ECOLOR char [modifier[...]] ON|OFF
     
     DESCRIPTION
          The SET ECOLOR command allows the user to specify the colors of
          each category of items used in syntax highlighting.
     
          'char' refers to one of the following valid values:
     
          A - comments
          B - strings
          C - numbers
          D - keywords
          E - labels
          F - preprocessor directives
          G - header lines
          H - extra right paren, matchable keyword (N/A)
          I - level 1 paren
          J - level 1 matchable keyword (N/A)
          K - level 1 matchable preprocessor keyword (N/A)
          L - level 2 paren, matchable keyword (N/A)
          M - level 3 paren, matchable keyword (N/A)
          N - level 4 paren, matchable keyword (N/A)
          O - level 5 paren, matchable keyword (N/A)
          P - level 6 paren, matchable keyword (N/A)
          Q - level 7 paren, matchable keyword (N/A)
          R - level 8 paren or higher, matchable keyword (N/A)
          S - incomplete string
          T - HTML markup tags
          U - HTML character/entity references
          V - Builtin functions
          W - not used
          X - not used
          Y - not used
          Z - not used
          1 - alternate keyword color 1
          2 - alternate keyword color 2
          3 - alternate keyword color 3
          4 - alternate keyword color 4
          5 - alternate keyword color 5
          6 - alternate keyword color 6
          7 - alternate keyword color 7
          8 - alternate keyword color 8
          9 - alternate keyword color 9
          N/A indicates that this capability is not yet implemented.
     
          For valid values for 'modifier', 'foreground' and 'background'
          see <SET COLOR>.
     
          The second format of this command allows the user to turn on or off
          any of the valid modifiers.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible.
     
     DEFAULT
          See <QUERY> ECOLOR
     
     SEE ALSO
          <SET COLORING>, <SET AUTOCOLOR>, <SET PARSER>, <SET COLOR>
          Appendix 4
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          set ecolour - set colours for syntax highlighting
     
     SYNTAX
          [SET] ECOLOUR char [modifier[...]] [foreground] [on background]
          [SET] ECOLOUR char [modifier[...]] ON|OFF
     
     DESCRIPTION
          The SET ECOLOUR command allows the user to specify the colours of
          each category of items used in syntax highlighting.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible.
     
     DEFAULT
          See <QUERY> ECOLOR
     
     SEE ALSO
          <SET COLOURING>, <SET AUTOCOLOUR>, <SET PARSER>, <SET COLOUR>
          Appendix 4
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          set eolout - set end of line terminating character(s)
     
     SYNTAX
          [SET] EOLout CRLF|LF|CR|NONE
     
     DESCRIPTION
          The EOLOUT command allows the user to specify the combination of
          characters that terminate a line. Lines of text in Unix files are
          usually terminated with a 'LF', DOS file usually end with a 'CR' and
          'LF' combination. Files on the Apple Macintosh are usually terminated
          with a 'CR'.
     
          The 'NONE' option can be used to specify that no end of line
          character is written.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: N/A
     
     DEFAULT
          LF - UNIX
          CRLF - DOS/OS2/WIN32
          NONE - if THE started with -u option
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          set equivchar - set the equivalence character
     
     SYNTAX
          [SET] EQUIVChar char
     
     DESCRIPTION
          The SET EQUIVChar command allows the user to change the character
          that is used to specify eqivalence in command parameters.
     
          In many THE commands, an equivalence character, usually '=', can
          be used as a parameter to default to values in the current file
          or view.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: N/A
     
     DEFAULT
          =
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          set etmode - indicate if extended display mode is possible
     
     SYNTAX
          [SET] ETMODE ON|OFF [character list]
     
     DESCRIPTION
          The SET ETMODE command allows the user to specify which characters
          in a character set are to be displayed as their actual representation.
     
          Those characters not explicitly specified to be displayed as they are
          represented, will be displayed as the <SET NONDISP> character in the
          colour specified by <SET COLOUR> NONDISP. Characters below 32, will
          be displayed with an alphabetic character representing the "control"
          code.
     
          eg.
          character code with a value of 7, will display as "G" in the colour
          specified by <SET COLOUR> NONDISP.
     
          'ON' with no optional 'character list' will display ALL
          characters as their actual representation.
     
          'OFF' with no optional 'character list' will display control
          characters below ASCII 32, as a "control" character; characters
          greater than ASCII 126 will be displayed as the <SET NONDISP>
          characters. On ASCII based machines, [SET] ETMODE OFF is
          equivalent  to [SET] ETMODE ON 32-126. On EBCDIC based machines
          [SET] ETMODE OFF is equivalent to [SET] ETMODE ON ??-??
     
          The 'character list' is a list of positive numbers between 0 and
          255 (inclusive).  The format of this character list can be either
          a single number; eg. 124, or a range of numbers specified; eg.
          32-126. (The first number must be less than or equal to the second
          number).
     
          As an example; ETMODE ON 32-127 160-250  would result in the
          characters with a decimal value between 32 and 127 inclusive
          and 160 and 250 inclusive being displayed as their actual
          representation (depending on the current font), and the
          characters between 0 and 31 inclusive, being displayed as
          an equivalent "control" character; characters between 128 and
          159 inculsive and 250 to 255 being displayed with the <SET NONDISP>
          character.
     
          Up to 20 character specifiers (single number or range) can be
          specified.
     
     COMPATIBILITY
          XEDIT: Similar function but deals with Double-Byte characters
          KEDIT: N/A
     
     DEFAULT
          ON - DOS/OS2/WIN32
          ON 32-255 - X11
          OFF - UNIX/AMIGA/QNX
     
     SEE ALSO
          <SET NONDISP>, <SET COLOUR>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          set fext - change the extension of the existing file
     
     SYNTAX
          [SET] FExt ext
          [SET] FType ext
     
     DESCRIPTION
          The SET FEXT command allows the user to change the path of
          the file currently being edited.
     
          The 'path' parameter can be specified with or without the
          trailing directory seperator.  Under DOS, OS/2 and Windows ports,
          the drive letter is considered part of the file's path.
     
          See <SET FILENAME> for a full explanation of THE's definitions
          of fpath, filename, fname, fext and fmode.
     
          It is not possible to use this command on pseudo files.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: N/A
     
     SEE ALSO
          <SET FNAME>, <SET FILENAME>, <SET FTYPE>, <SET FMODE>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          set filename - change the filename of the file being edited
     
     SYNTAX
          [SET] FILEName filename
     
     DESCRIPTION
          The SET FILEName command allows the user to change the filename of
          the file currently being edited.
     
          In THE, a fully qualified file name consists of a file path and a
          file name.  THE treats all characters up to and including the
          last directory seperator (usually / or \) as the file's path.
          From the first character after the end of the file's path, to
          the end of the fully qualified file name is the file name.
     
          A file name is further broken down into a fname and fext.
          The fname of a file consists of all characters from the start
          of the filename up to but not including the last period (if
          there is one).  The fext of a file consists of all characters
          from the end of the filename up to but not including the last
          period. If there is no period in the filename then the fext is
          empty.
     
          The fmode of a file is equivalent to the drive letter of the file's
          path. This is only valid under DOS, OS/2 and Windows ports.
     
          Some examples.
     
          *----------------------------------------------------------------
          Full File Name     File            File     Fname  Fext     Fmode
                             Path            Name
          -----------------------------------------------------------------
          /usr/local/bin/the /usr/local/bin/ the      the             N/A
          c:\tools\the.exe   c:\tools\       the.exe  the    exe      c
          /etc/a.b.c         /etc/           a.b.c    a.b    c        N/A
          *----------------------------------------------------------------
     
          A limited amount of validation of the resulting file name is
          carried out by this command, but some errors in the file name
          will not be evident until the file is saved.
     
          A leading "=" indicates that the fname portion of the current file
          name is be retained.  This is equivalent to the command
          <SET FEXT>.  A trailing "=" indicates that the fext portion of
          the current file name is to be retained. This is equivalent to the
          command <SET FNAME>.
     
          Only one "=" is allowed in the parameter.
     
          Some examples.
     
          *----------------------------------------------------------------
          File Name   Parameter  New File Name
          -----------------------------------------------------------------
          a.b.c       fred.c=    fred.c.c      SET FNAME fred.c
          a.b.c       fred.c.=   fred.c..c     SET FNAME fred.c.
          a.b.c       =fred      a.c.fred      SET FEXT fred
          a.b.c       =.fred     a.c..fred     SET FEXT .fred
          a           =d         a.d           SET FEXT d
          a.b.c       =          a.b.c         does nothing
          *----------------------------------------------------------------
     
          It is not possible to use this command on pseudo files.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible.
     
     SEE ALSO
          <SET FPATH>, <SET FNAME>, <SET FEXT>, <SET FMODE>, <SET EQUIVCHAR>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          set filetabs - determine if and where where file tabs are positioned
     
     SYNTAX
          [SET] FILETABS ON|OFF
     
     DESCRIPTION
          The SET FILETABS command allows the user to determine if file tabs
          are to be displayed and where. FILETABS is a single line at the
          top of the display showing all files currently in the ring, except
          the current file.
          It provides a mechanism where the user running THE with mouse support
          can simply click on the filename in the FILETABS line to change focus
          to that file.
     
          The colour of the file tabs can be set with <SET COLOUR> FILETABS.
          The colour of the file dividers can be set with <SET COLOUR> FILETABSDIV.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: N/A
     
     SEE ALSO
          <SET COLOUR>, <TABFILE>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          set fmode - change the drive letter of the existing file
     
     SYNTAX
          [SET] FMode d[:]
     
     DESCRIPTION
          The SET FMode command allows the user to change the drive letter
          of the file currently being edited.
     
          This command is only valid under the DOS, OS/2 and Windows ports.
     
          See <SET FILENAME> for a full explanation of THE's definitions
          of fpath, filename, fname, fext and fmode.
     
          It is not possible to use this command on pseudo files.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible
     
     SEE ALSO
          <SET FNAME>, <SET FILENAME>, <SET FEXT>, <SET FPATH>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          set fname - change the filename of the file being edited
     
     SYNTAX
          [SET] FName filename
     
     DESCRIPTION
          The SET FNAME command allows the user to change the fname of
          the file currently being edited.
     
          See <SET FILENAME> for a full explanation of THE's definitions
          of fpath, filename, fname, fext and fmode.
     
          A limited amount of validation of the resulting file name is
          carried out by this command, but some errors in the file name
          will not be evident until the file is saved.
     
          It is not possible to use this command on pseudo files.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible.
     
     SEE ALSO
          <SET FPATH>, <SET FILENAME>, <SET FEXT>, <SET FMODE>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          set fpath - change the path of the existing file
     
     SYNTAX
          [SET] FPath path
     
     DESCRIPTION
          The SET FPATH command allows the user to change the path of
          the file currently being edited.
     
          The 'path' parameter can be specified with or without the
          trailing directory seperator.  Under DOS, OS/2 and Windows ports,
          the drive letter is considered part of the file's path.
     
          See <SET FILENAME> for a full explanation of THE's definitions
          of fpath, filename, fname, fext and fmode.
     
          It is not possible to use this command on pseudo files.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: N/A
     
     SEE ALSO
          <SET FNAME>, <SET FILENAME>, <SET FEXT>, <SET FMODE>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          set ftype - change the extension of the existing file
     
     SYNTAX
          [SET] FType ext
     
     DESCRIPTION
          The SET FTYPE is a synonym for <SET FEXT>.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: N/A
     
     SEE ALSO
          <SET FNAME>, <SET FILENAME>, <SET FEXT>, <SET FMODE>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          set fullfname - specify if complete filename to be displayed
     
     SYNTAX
          [SET] FULLFName ON|OFF
     
     DESCRIPTION
          The SET FULLFNAME command allows the user to determine if the
          fully qualified filename is displayed on the IDLINE or just the
          FNAME component.
          See <SET FILENAME> for a full explanation of THE's definitions
          of fpath, filename, fname, fext and fmode.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: N/A
     
     DEFAULT
          ON
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          set header - turn on or off syntax highlighting headers
     
     SYNTAX
          [SET] HEADer section ON|OFF
     
     DESCRIPTION
          The SET HEADER command allows fine tuning of which sections of a
          TLD file are to be applied for the current view.
     
          'section' refers to one of the following headers that can be specified
          in a TLD file:
          NUMBER, COMMENT, STRING, KEYWORD, FUNCTION, HEADER, LABEL, MATCH,
          COLUMN, POSTCOMPARE, MARKUP.
          'section' can also be specified as '*', in which case, all headers
          are applied or not applied.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: N/A
     
     DEFAULT
          * ON
     
     SEE ALSO
          <SET PARSER>, <SET COLORING>, <SET AUTOCOLOR>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          set hex - set how hexadecimal strings are treated in string operands
     
     SYNTAX
          [SET] HEX ON|OFF
     
     DESCRIPTION
          The SET HEX set command determines whether hexadecimal strings are
          treated as such in string operands.
     
          With the 'ON' option, any string operand of the form
             /x'31 32 33'/ or
             /d'49 50 51'/
          will be converted to /123/ before the command is executed.
     
          With the 'OFF' option, no conversion is done.
     
          This conversion should work wherever a string operand is used
          in any command.
     
     COMPATIBILITY
          XEDIT: Adds support for decimal representation. See below.
          KEDIT: Compatible. See below.
          Spaces must seperate each character representation.
     
     DEFAULT
          OFF
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          set hexdisplay - turn on or off display of character under cursor
     
     SYNTAX
          [SET] HEXDISPlay ON|OFF
     
     DESCRIPTION
          The SET HEXDISPLAY command turns on or off the display of the
          character under the cursor on the <status line>.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible.
     
     DEFAULT
          ON
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          set hexshow - turn on or off hex display of current line
     
     SYNTAX
          [SET] HEXShow ON|OFF [M[+n|-n]|[+|-]n]
     
     DESCRIPTION
          The SET HEXShow command indicates if and where a hexadecimal
          representation of the <current line> will be displayed.
     
          The first form of parameters is:
     
          M[+n|-n]
          this sets the hexshow line to be relative to the middle of
          the screen. A positive value adds to the middle line number,
          a negative subtracts from it.
          eg. M+3 on a 24 line screen will be line 15
              M-5 on a 24 line screen will be line 7
     
          The second form of parameters is:
     
          [+|-]n
          this sets the hexshow line to be relative to the top of the
          screen (if positive or no sign) or relative to the bottom
          of the screen if negative.
          eg. +3 or 3 will set current line to line 3
              -3 on a 24 line screen will be line 21
     
          If the resulting line is outside the bounds of the screen
          the position of the hexshow line will become the middle line
          on the screen.
     
          The position argument specifies the position of the first line
          of the hexadecimal display.
     
          It is an error to try to position the HEXSHOW lines on the same
          line as <SET CURLINE>.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: N/A
     
     DEFAULT
          OFF 7
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          set highlight - specify which lines (if any) are to be highlighted
     
     SYNTAX
          [SET] HIGHlight OFF|TAGged|ALTered|SELect n [m]
     
     DESCRIPTION
          The SET HIGHLIGHT command allows for the user to specify which
          lines are to be displayed in the highlighted colour.
     
          'OFF' turns all highlighting display off
     
          'TAGGED' displays all tagged lines in the highlight colour.
     
          'ALTERED' displays all lines that have been added or
          changed in the current session in the highlight colour.
     
          'SELECT n [m]' displays all lines with the specified selection
          level in highlight colour.
     
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible
     
     DEFAULT
          OFF
     
     SEE ALSO
          <SET SELECT>, <TAG>, <SET LINEFLAG>
     
     STATUS
          Ccomplete.



     --------------------------------------------------------------------------
     COMMAND
          set idline - specify if IDLINE is displayed
     
     SYNTAX
          [SET] IDline ON|OFF
     
     DESCRIPTION
          The SET IDLINE set command determines if the <idline> for a file is
          displayed or not.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible.
     
     DEFAULT
          ON
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          set impcmscp - set implied operating system command processing
     
     SYNTAX
          [SET] IMPcmscp ON|OFF
     
     DESCRIPTION
          The SET IMPCMSCP command is used to toggle implied operating system
          command processing from the command line. By turning this feature
          on you can then issue an operating system command without the need
          to prefix the operating system command with the <OS> command.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: N/A
     
     DEFAULT
          ON
     
     SEE ALSO
          <SET IMPOS>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          set impmacro - set implied macro command processing
     
     SYNTAX
          [SET] IMPMACro ON|OFF
     
     DESCRIPTION
          The SET IMPMACRO command is used to toggle implied macro processing
          from the command line. By turning this feature on you can then
          issue a <macro> command without the need to prefix the macro name
          with the <MACRO> command.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible.
     
     DEFAULT
          ON
     
     SEE ALSO
          <MACRO>, <SET MACROPATH>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          set impos - set implied operating system command processing
     
     SYNTAX
          [SET] IMPOS ON|OFF
     
     DESCRIPTION
          The SET IMPOS command is used to toggle implied operating system
          command processing from the command line. By turning this feature
          on you can then issue an operating system command without the need
          to prefix the operating system command with the <OS> command.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: N/A
     
     DEFAULT
          ON
     
     SEE ALSO
          <SET IMPCMSCP>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          set inputmode - set input mode behaviour
     
     SYNTAX
          [SET] INPUTMode OFF|FUll|LIne
     
     DESCRIPTION
          The SET INPUTMODE command changes the way THE handles input.
     
          When INPUTMODE LINE is in effect, pressing the ENTER key while
          in the <filearea> will result in a new line being added.
     
          When INPUTMODE OFF is in effect, pressing the ENTER key while
          in the <filearea> will result in the cursor moving to the
          beginning of the next line; scrolling the screen if necessary.
     
          When INPUTMODE FULL is in effect, pressing the ENTER key while
          in the <filearea> will result in the cursor moving to the
          beginning of the next line; scrolling the screen if necessary.
     
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible.
     
     DEFAULT
          LINE
     
     SEE ALSO
          <INPUT>
     
     STATUS
          Incomplete. No support for FULL option.



     --------------------------------------------------------------------------
     COMMAND
          set insertmode - put editor into or out of insert mode
     
     SYNTAX
          [SET] INSERTMode ON|OFF|TOGGLE
     
     DESCRIPTION
          The SET INSERTMODE command enable the user to set the insert mode
          within THE.
     
          The 'TOGGLE' option turns insert mode 'ON' if it is currently
          'OFF' and vice versa.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible.
     
     DEFAULT
          OFF
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          set interface - set overall behaviour of THE
     
     SYNTAX
          [SET] INTerface CLASSIC|CUA
     
     DESCRIPTION
          The SET INTERFACE command changes the behaviour of several operations
          within THE.  THE normally operates in a block-mode manner, however
          many applications conform to the Common User Access (CUA) standard
          developed by IBM.  This command specifies that CUA behaiour should
          occur on various actions during the edit session.
     
          The major differences between CLASSIC and CUA behaviour, involve
          keyboard and mouse actions. Various THE commands have CUA options to
          allow the user to customise the behaviour individual keys or the
          mouse to behave in a CUA manner.
     
          Where behaviour is not related to particular key or mouse actions,
          this command provides the mechanism for changing the behaviour.
          The behaviour that SET INTERFACE affects:
     
          - entering text in the filearea with a marked CUA block will
            first delete the block and reposition the cursor
          - executing <SOS DELCHAR> or <SOS DELBACK> will delete the
            marked CUA block
          - executing any positioning command, such as <CURSOR> DOWN,
            <FORWARD> or <CURSOR> MOUSE, will unmark the CUA block
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible with KEDIT for Windows.
     
     DEFAULT
          CLASSIC
     
     SEE ALSO
          <MARK> <CURSOR>
     
     STATUS
          Incomplete.



     --------------------------------------------------------------------------
     COMMAND
          set lastop - set the contents of the lastop argument
     
     SYNTAX
          [SET] LASTOP operand text
     
     DESCRIPTION
          The SET LASTOP command sets the valus of the specified 'operand' to the
          'text' supplied. This command is most useful when run from a macro, to
          set the string to be passed to the next invocation of the equivalent
          'operand' command; eg LOCATE, FIND, etc.
     
          Because THE does not save the contents of the lastop from a command when
          run from a macro, sometimes the macro is intended to set this value. This
          command allows that capability.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible.
     
     SEE ALSO
          <LOCATE>, <FIND>, <SEARCH>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          set lineflag - set the line characteristics of lines
     
     SYNTAX
          [SET] LINEFLAG CHAnge|NOCHange NEW|NONEW TAG|NOTAG [target]
     
     DESCRIPTION
          The SET LINEFLAGS command controls the line characteristics of lines
          in a file.
     
          Each line in a file has certain characteristics associated with it
          depending on how the line has been modified.  On reading a file from
          disk, all lines in the file are set to their default values.
     
          Once a line is modified, or tagged, the characteristics of the line
          are set appropriately.  A line that is added, is set to NEW; a line
          that is changed is set to CHANGE, and a line that is tagged with the
          <TAG> command, is set to TAG.  All three characteristics can be on
          at the one time.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible.
     
     DEFAULT
          NOCHANGE NONEW NOTAG
     
     SEE ALSO
          <TAG>, <SET HIGHLIGHT>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          set linend - allow/disallow multiple commands on command line
     
     SYNTAX
          [SET] LINENd ON|OFF [character]
     
     DESCRIPTION
          The SET LINEND command allows or disallows the execution of multiple
          commands on the <command line>. When setting LINEND ON, a 'character'
          is specified as the LINEND character which delimits each command.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     DEFAULT
          OFF #
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          set macro - indicate if macros executed before commands
     
     SYNTAX
          SET MACRO ON|OFF
     
     DESCRIPTION
          The SET MACRO command allows the user to determine if macros
          are executed before a built-in command of the same name.
     
          This command MUST be prefixed with <SET> to distinguish it
          from the <MACRO> command.
     
          A macro with the same name as a built-in command will only
          be executed before the built-in command if <SET IMPMACRO>
          is ON, <SET MACRO> is ON, and the command was NOT executed
          with the <COMMAND> command.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: N/A
     
     DEFAULT
          OFF
     
     SEE ALSO
          <MACRO>, <SET IMPMACRO>, <COMMAND>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          set macroext - set default macro extension value
     
     SYNTAX
          [SET] MACROExt [ext]
     
     DESCRIPTION
          The SET MACROEXT command sets the value of the file extension to be
          used for <macro> files. When a macro file name is specified on the
          <command line>, a period '.', then this value will be appended.
          If no value is specified for 'ext', then THE assumes that the
          supplied macro file name is the fully specified name for a macro.
     
          The length of 'ext' must be 10 characters or less.
     
          The macro extension is only appended to a file if that file does
          not include any path specifiers.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: N/A
     
     DEFAULT
          the
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          set macropath - set default path for macro commands
     
     SYNTAX
          [SET] MACROPath PATH|path[s]
     
     DESCRIPTION
          The SET MACROPATH command sets up the search path from which macro
          command files are executed. Each directory is seperated by a
          colon (Unix) or semi-colon (DOS & OS/2). Only 20 directories are
          allowed to be specified.
     
          When 'PATH' is specified, the search path is set to the system
          PATH environment variable.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Incompatible.
     
     DEFAULT
          Path specified by env variable THE_MACRO_PATH
     
     SEE ALSO
          <MACRO>, <SET IMPMACRO>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          set margins - set left and right margins for wordwrap
     
     SYNTAX
          [SET] MARgins left right [[+|-]indent]
     
     DESCRIPTION
          The SET MARGINS command sets the 'left' and 'right' margins and the
          number of columns to 'indent' a paragraph.
     
          These values are used with the <SET WORDWRAP> option.
     
          All options can be specified as the current EQUIVCHAR to retain the
          existing value.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible.
     
     DEFAULT
          1 72 +0
     
     SEE ALSO
          <SET WORDWRAP>, <SET EQUIVCHAR>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          set mouse - turn mouse support on or off
     
     SYNTAX
          [SET] MOUSE ON|OFF
     
     DESCRIPTION
          The SET MOUSE command allows the user to turn on or off mouse
          support in THE.  With mouse support, THE commands assigned to
          a mouse button event will be executed.  See APPENDIX 3 for
          details on default mouse support.
     
          If the platform does not support mouse operations, the default
          setting will be OFF.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible. Does not support all options.
     
     DEFAULT
          ON - if mouse supported, OFF - otherwise
     
     SEE ALSO
          <DEFINE>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          set msgline - set position and size of message line
     
     SYNTAX
          [SET] MSGLine ON M[+n|-n]|[+|-]n [lines] [Overlay]
          [SET] MSGLine CLEAR
     
     DESCRIPTION
          The SET MSGLINE set command specifies the position of the
          <message line> and the size of the message line window.
     
          The first form of positional parameters is:
     
          M[+n|-n]
          this sets the first line to be relative to the middle of
          the screen. A positive value adds to the middle line number,
          a negative subtracts from it.
          eg. M+3 on a 24 line screen will be line 15
              M-5 on a 24 line screen will be line 7
     
          The second form of positional parameters is:
     
          [+|-]n
          this sets the first line to be relative to the top of the
          screen (if positive or no sign) or relative to the bottom
          of the screen if negative.
          eg. +3 or 3 will set first line to line 3
              -3 on a 24 line screen will set first line to line 21
     
          If the resulting line is outside the bounds of the screen
          the position of the message line will become the middle line
          on the screen.
     
          The 'lines' argument specifies the maximum number of lines of
          error messages to display at the one time.  If this value is
          specified as a whole number it must be less than or equal to the
          number of lines that could fit on the screen from the starting row.
          '*' can be specified to indicate that as many lines as possible should
          be displayed.
     
          All options can be specified as the current EQUIVCHAR to retain the
          existing value.
     
          The second format of the command clears the messages being displayed.
          This is useful in macros where you need to display an error message
          but also want to be able to clear it.
     
     COMPATIBILITY
          XEDIT: Compatible.
                 The OVERLAY option is the default but ignored.
                 The second format is not supported.
          KEDIT: Compatible
                 The OVERLAY option is the default but ignored.
                 The second format is not supported.
     
     DEFAULT
          ON 2 5 Overlay
     
     SEE ALSO
          <SET EQUIVCHAR>
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          set msgmode - set display of messages on or off
     
     SYNTAX
          [SET] MSGMode ON|OFF
     
     DESCRIPTION
          The SET MSGMODE set command determines whether error messages will
          be displayed or suppressed.
     
     COMPATIBILITY
          XEDIT: Does not support [Short|Long] options.
          KEDIT: Compatible
     
     DEFAULT
          ON
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          set newlines - set position of cursor after adding blank line
     
     SYNTAX
          [SET] NEWLines Aligned|Left
     
     DESCRIPTION
          The SET NEWLINES set command determines where the cursor displays
          after a new line is added to the file.
     
          With 'ALIGNED', the cursor will display in the column of the new line
          immediately underneath the first non-blank character in the line
          above.
          With 'LEFT', the cursor will display in the first column of the new
          line.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Same command, different functionality.
     
     DEFAULT
          Aligned
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          set nondisp - specify character to display for non-displaying characters
     
     SYNTAX
          [SET] NONDisp character
     
     DESCRIPTION
          The SET NONDISP command allows the user to change the 'character'
          that is displayed for non-displaying commands when <SET ETMODE>
          is OFF.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: N/A
     
     DEFAULT
          #
     
     SEE ALSO
          <SET ETMODE>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          set number - turn prefix numbers on or off
     
     SYNTAX
          [SET] NUMber ON|OFF
     
     DESCRIPTION
          The SET NUMBER command allows the user to toggle the display of
          numbers in the <prefix area>.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     DEFAULT
          ON
     
     SEE ALSO
          <SET PREFIX>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          set pagewrap - determine if page scrolling wraps at bottom/top of file
     
     SYNTAX
          [SET] PAGEWRAP ON|OFF
     
     DESCRIPTION
          The SET PAGEWRAP command allows the user to turn on or off the
          automatic wrapping of <FORWARD> and <BACKWARD> commands when the cursor
          is at the <Bottom-of-File line> or <Top-of-File line> respectively.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: N/A
     
     DEFAULT
          ON
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          set parser - associates a language definition file with a parser
     
     SYNTAX
          [SET] PARSER parser file
     
     DESCRIPTION
          The SET PARSER defines a new syntax highlighting <parser>; 'parser' based
          on a language definition file; 'file'.
     
          The 'file' is looked for in the directories specified by <SET MACROPATH>.
     
          To specify one of the builtin parsers, prefix the filename with '*'.
          Therefore to define a <parser> called FRED using the builtin C parser,
          the command would be: SET PARSER FRED *C.TLD.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible.
     
     SEE ALSO
          <SET COLORING>, <SET ECOLOUR>, <SET AUTOCOLOR>, <SET MACROPATH>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          set pending - set status of pending prefix commands
     
     SYNTAX
          [SET] PENDing ON string
          [SET] PENDing OFF
          [SET] PENDing BLOCK string
     
     DESCRIPTION
          The SET PENDING command allows the user to insert or remove commands
          from the pending prefix list.
     
          ON string, simulates the user typing 'string' in the <prefix area>
          of the <focus line>.
     
          OFF, removes any pending prefix command from the focus line.
     
          BLOCK string, simulates the user typing 'string' in the PREFIX
          area of the focus line and identifies the prefix command to be
          a BLOCK command.
     
     COMPATIBILITY
          XEDIT: Does not support ERROR option.
          KEDIT: N/A
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          set point - assign a name to the current line
     
     SYNTAX
          [SET] Point .name [OFF]
     
     DESCRIPTION
          The SET POINT command assignes the specified name to the
          <focus line>, or removes the name from the line with the specified
          name.
          A valid line name must start with a '.' followed by alphanumeric
          characters. eg. .a .fred and .3AB are valid names.
     
          When a line is moved within the same file, its line name stays
          with the line.
     
     COMPATIBILITY
          XEDIT: Compatible. See below.
          KEDIT: Compatible. See below.
          Does not allow for multiple names for the same line.
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          set position - determine if LINE/COL is displayed on idline
     
     SYNTAX
          [SET] POSition ON|OFF
     
     DESCRIPTION
          The SET POSITION command allows the user to turn on or off the
          display of LINE/COL on the <idline>.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: N/A
     
     DEFAULT
          ON
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          set prefix - set prefix area attributes
     
     SYNTAX
          [SET] PREfix ON [Left|Right] [n [m]]
          [SET] PREfix Nulls [Left|Right] [n [m]]
          [SET] PREfix OFF
          [SET] PREfix Synonym newname oldname
     
     DESCRIPTION
          The first form of the SET PREFIX command allows the user to display
          the <prefix area> and optionally to select the position were the
          prefix should be displayed.
     
          The second form of the SET PREFIX command is functionally the same
          as the first form. The difference is that when the prefix area
          is displayed with <SET NUMBER> ON, numbers are displyed with leading
          spaces rather than zeros; with <SET NUMBER> OFF, blanks are displayed
          instead of equal signs.
     
          The third form, turns the display of the prefix area off.
          Executed from within the profile, the only effect is that the
          defaults for all files is changed.
          Executed from the command line, the SET PREFIX command changes the
          current window displays to reflect the required options.
     
          The fourth form of the SET PREFIX command allows the user to specify
          a synonym for a prefix command or Rexx prefix macro. The 'newname'
          is the command entered in the prefix area and 'oldname' corresponds
          to an existing prefix command or a Rexx macro file in the MACROPATH
          ending in .the or whatever the value of <SET MACROEXT> is at the time the
          prefix command is executed. The 'oldname' can also be the fully
          qualified filename of a Rexx macro.
     
          The first and second forms of the SET PREFIX command allows the user
          to specify the width of the prefix area and optionally a gap between
          the prefix area and the filearea.
          'm' can be specified as an unsigned number between 2 and 20 inclusive.
          'n' can be specified as an unsigned number between 0 and 18, but less
          than the number specified in 'm'.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
          Specification of prefix width is a THE-only option.
     
     DEFAULT
          ON Left 6 0
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          set printer - define printer spooler name
     
     SYNTAX
          [SET] PRINTER spooler|[OPTION options]
     
     DESCRIPTION
          The SET PRINTER command sets up the print spooler name to determine
          where output from the <PRINT> command goes.
     
          The 'options' can be one of the following:
          CPI n                           (characters per inch)
          LPI n                           (lines per inch)
          ORIENTation Portrait|Landscape
          FONT fontname                   (name of fixed width font)
     
          No checking is done for printer options. ie. You may specify a
          font that THE doesn't know about, and the printing process may
          not work after that.
     
          The defaults for page layout for Win32 are:
          CPI 16
          LPI 8
          ORIENTation Portrait
          FONT LinePrinter BM
     
          'options' are only valid for Win32 platform.
          Printer output for the Win32 platform ALWAYS goes to the default
          printer. Therefore, the 'spooler' option is invalid on this
          platform.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible. THE adds more funtionality.
     
     DEFAULT
          LPT1 - DOS/OS2, lpr - Unix, default - Win32
     
     SEE ALSO
          <PRINT>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          set pscreen - set physical size of screen
     
     SYNTAX
          [SET] PSCReen height [width] [RESET|PRESET]
     
     DESCRIPTION
          The SET PSCREEN command allows the user to adjust the size of the
          physical screen to the size specified by 'height' and 'width'.
     
          This command does not work on all platforms.
     
          The optional argument [RESET|PRESET] are ignored; they are there
          for Kedit compatibility.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible. Ignores RESET|PRESET argument
     
     DEFAULT
          System Dependent
     
     STATUS
          Incomplete.



     --------------------------------------------------------------------------
     COMMAND
          set readonly - allow/disallow changes to a file if it is readonly
     
     SYNTAX
          [SET] READONLY ON|OFF|FORCE
     
     DESCRIPTION
          The SET READONLY command allows the user to disallow changes to
          files if they are readonly.  Normally, if a file is readonly, THE
          allows the user to make changes to the file contents while in the
          editing session, but does not allow the file to be saved.
     
          With READONLY ON, THE disallows any changes to be made to the
          contents of the file in memory, in much the same way that THE
          disallows changes to be made to any files, if THE is started
          with the -r command line switch.
     
          With READONLY FORCE, THE disallows any changes to be made to the
          contents of the file in memory, in the same way that THE
          disallows changes to be made to any files, if THE is started
          with the -r command line switch.
     
          While the -r command line switch disallows changes to be made to
          any files, SET READONLY ON, only disallows changes to be made to
          readonly files. SET READONLY FORCE disallows changes to be made to
          the current file irrespective of whether it is readonly on disk.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: N/A
     
     DEFAULT
          OFF
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          set regexp - specify the regular expression syntax to use
     
     SYNTAX
          [SET] REGEXP syntax
     
     DESCRIPTION
          The SET REGEXP command allows the user specify which of the many
          regular expression syntaxes to use when using regular expressions
          in a <target>.
          The 'syntax' can be specified as one of:
     
               EMACS
               AWK
               POSIX_AWK
               GREP
               EGREP
               POSIX_EGREP
               SED
               POSIX_BASIC
               POSIX_MINIMAL_BASIC
               POSIX_EXTENDED
               POSIX_MINIMAL_EXTENDED
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: N/A
     
     DEFAULT
          EMACS
     
     SEE ALSO
          <LOCATE>, <ALL>
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          set reprofile - indicate if profile file to be executed for all files
     
     SYNTAX
          [SET] REPROFile ON|OFF
     
     DESCRIPTION
          The SET REPROFILE command allows the user to determine if the
          <profile> file is to reexecuted for files subsequenlty edited.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible.
     
     DEFAULT
          OFF
     
     SEE ALSO
          <XEDIT>, <EDIT>, <THE>
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          set reserved - display a reserved line
     
     SYNTAX
          [SET] RESERved *|+|-n [colour] [text|OFF]
     
     DESCRIPTION
          The SET RESERVED command reserves a line for the display of arbitrary
          text by the user. The position is determined by +|-n.
          This number, if positive, specifies the line relative from the
          top of the display. A negative number is relative from the
          bottom of the display.
     
          By specifying a line, say +3, then the third line from the top will
          be reserved, with the supplied text being displayed in that line.
     
          The <idline> of a file will always be displayed after any reserved
          lines.
     
          The <status line> is not considered part of the displayable area,
          so any positioning specifications ignore that line.
     
          A <reserved line> can only be turned off by identifying it in the
          same way that it was defined.  If a <reserved line> was added with
          the position specification of -1, it cannot be turned off with
          a position specification of 23, even though both position
          specifiers result in the same display line.
     
          All reserved lines may be turned of by specifying * as the number
          of lines.
     
          The colour option specifies the colours to use to display the
          reserved line. The format of this colour specifier is the same
          as for <SET COLOUR>. If no colour is specified, the colour of the
          reserved line will be the colour set by any <SET COLOUR> RESERVED
          command for the view or white on black by default.
     
          The text of reserved lines can also included embedded control
          characters to control the colour of portions of the text.
          Assume the following <SET CTLCHAR> commands have been issued:
     
               SET CTLCHAR ESCAPE !
               SET CTLCHAR @ PROTECT BOLD RED ON WHITE
               SET CTLCHAR % PROTECT GREEN ON BLACK
     
          Then to display a <reserved line> using the specified colours:
     
               SET RESERVED -1 normal!@bold red on white!%green on black
     
          It is an error to try to reserve a line which is the same line as
          <SET CURLINE>.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     SEE ALSO
          <SET COLOUR>, <SET CTLCHAR>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          set rexxoutput - indicate where Rexx output is to go
     
     SYNTAX
          [SET] REXXOUTput File|Display n
     
     DESCRIPTION
          The SET REXXOUTPUT command indicates where output from the Rexx
          interpreter is to go; either captured to a file in the ring
          or displayed in a scrolling fashion on the screen.
     
          Also specified is the maximum number of lines from the Rexx
          interpreter that are to be displayed or captured. This is
          particularly useful when a Rexx <macro> gets into an infinite
          loop.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: N/A
     
     DEFAULT
          Display 1000
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          set scale - set position and status of scale line on screen
     
     SYNTAX
          [SET] SCALe ON|OFF [M[+n|-n]|[+|-]n]
     
     DESCRIPTION
          The SET SCALE command sets the position and status of the scale line
          for the current view.
     
          The first form of parameters is:
     
          M[+n|-n]
          this sets the <scale line> to be relative to the middle of
          the screen. A positive value adds to the middle line number,
          a negative subtracts from it.
          eg. M+3 on a 24 line screen will be line 15
              M-5 on a 24 line screen will be line 7
     
          The second form of parameters is:
     
          [+|-]n
          this sets the <scale line> to be relative to the top of the
          screen (if positive or no sign) or relative to the bottom
          of the screen if negative.
          eg. +3 or 3 will set current line to line 3
              -3 on a 24 line screen will be line 21
     
          If the resulting line is outside the bounds of the screen
          the position of the current line will become the middle line
          on the screen.
     
          It is an error to try to position the SCALE line on the same
          line as <SET CURLINE>.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     DEFAULT
          OFF M+1
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          set scope - sets which lines are to be excluded from commands
     
     SYNTAX
          [SET] SCOPE All|Display
     
     DESCRIPTION
          The SET SCOPE command indicates whether lines not displayed as
          the result of a <SET DISPLAY> or <ALL> command are included in
          the scope of lines to be acted upon by other THE commands.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     DEFAULT
          Display
     
     SEE ALSO
          <SET DISPLAY>, <SET SELECT>, <ALL>
     
     STATUS
          Completed.



     --------------------------------------------------------------------------
     COMMAND
          set screen - specify number of screens displayed
     
     SYNTAX
          [SET] SCReen n [Horizontal|Vertical]
          [SET] SCReen Size l1|* [l2|*]
     
     DESCRIPTION
          The SET SCREEN command specifies the number of views of file(s) to
          display on screen at once. If the number of views specified is 2
          and only one file is currently in the <ring>, two views of the
          same file are displayed.
     
          The second form of SET SCREEN allows the user to specify the
          number of lines that each screen occupies.  The sum of 'l1' and
          'l2' must equal to lscreen.5 or lscreen.5 - 1 if the <status line>
          is displayed.
     
          The value of 'l1' specifies the size of the topmost screen; 'l2'
          specifies the size of the bottommost screen.
     
          Either 'l1' or 'l2' can be set to *, but not both.  The * signifies
          that the screen size for the specified screen will be the remainder
          of the full display window after the size of the other screen
          has been subtracted.
     
          The THE display can only be split into 1 or 2 screens.
     
     COMPATIBILITY
          XEDIT: Does not support Width or Define options.
          KEDIT: Does not support Split option.
          A maximum of 2 screens are supported.
     
     DEFAULT
          1
     
     SEE ALSO
          <SET STATUSLINE>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          set select - sets the selection level for the specified lines
     
     SYNTAX
          [SET] SELect [+|-]n [target]
     
     DESCRIPTION
          The SET SELECT command sets the selection level for the indicated
          lines equal to 'n' (if no signs are specified) or adds or subtracts
          n from the selection level currently set for the lines in the
          target.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     DEFAULT
          0
     
     SEE ALSO
          <SET SCOPE>, <SET DISPLAY>, <ALL>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          set shadow - determines if shadow lines are displayed or not
     
     SYNTAX
          [SET] SHADOW ON|OFF
     
     DESCRIPTION
          The SET SHADOW command indicates whether <shadow line>s are to be
          displayed.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     DEFAULT
          ON
     
     SEE ALSO
          <SET DISPLAY>, <SET SELECT>, <ALL>
     
     STATUS
          Completed.



     --------------------------------------------------------------------------
     COMMAND
          set slk - set Soft Label Key definitions
     
     SYNTAX
          [SET] SLK n|OFF [text]
     
     DESCRIPTION
          The SET SLK command allows the user to specify a short text
          description to be displayed on the bottom of the screen, using
          the terminal's built-in Soft Label Keys, or the last line of
          the screen.
     
          The 'n' argument of the command represents the label
          number from left to right, with the first label numbered 1.
     
          'OFF' turns off display of the Soft Label Keys. This is the same as
          executing [SET] SLK n with no optional text for each label
          displayed.
     
          The main use for this command is to describe the function assigned
          to a function key, in place of a <reserved line>.
     
          On those platforms that support a pointing device, clicking the
          left mouse button on the Soft Label Key, is equivalent to pressing
          the associated function key.
     
          The number of Soft Label Keys displayed is dependent on which
          curses library THE is using.  PDCurses can display 10 keys with
          the length of the 'text' argument 7 characters on a screen that
          is 80 columns wide.  The number of characters that can be
          displayed increases with the width of the screen.
          Other curses implementations, limit the number of Soft Label Keys
          to 8, with a text width of 8 characters.  Some curses
          implementations do not support Soft Label Keys.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: N/A
     
     DEFAULT
          OFF
     
     SEE ALSO
          <SET COLOUR>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          set span - specify if a string target can span multiple lines (unavailable)
     
     SYNTAX
          [SET] SPAN ON|OFF [Blank|Noblank [n|*]]
     
     DESCRIPTION
          The SET SPAN set command determines if a character string that is
          the subject of a target search can span more than one line of the
          file.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: N/A
     
     DEFAULT
          OFF Blank 2
     
     STATUS
          Not started.



     --------------------------------------------------------------------------
     COMMAND
          set spill - specify if a string target can span multiple lines (unavailable)
     
     SYNTAX
          [SET] SPILL ON|OFF|WORD
     
     DESCRIPTION
          The SET SPILL set command determines how characters are spilt
          off the end of a line when the length of the line exceeds the
          truncation column.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: N/A
     
     DEFAULT
          OFF
     
     STATUS
          Not started.



     --------------------------------------------------------------------------
     COMMAND
          set statopt - set display options on statusline
     
     SYNTAX
          [SET] STATOPT ON option column [length [prompt] ]
          [SET] STATOPT OFF option|*
     
     DESCRIPTION
          The SET STATOPT command allows the user to specify which internal
          settings of THE are to be displayed on the <status line>.
     
          The 'option' argument is any value returned by the <EXTRACT>
          command. eg NBFILE.1.
     
          The syntax of the ON option, displays the specified value, at the
          position in the <status line> specified by 'column'.  If supplied,
          'length' specifies the number of characters, beginning at the
          first character of the returned value, to display.  A value of 0
          indicates that the full value if to be displayed.  The optional
          'prompt' argument, allows the user to specify a string to display
          immediately before the returned value.
     
          OFF, removes the specified 'option' from displaying.  If '*'
          is specified, all displayed options will be removed.
     
          'column' is relative to the start of the <status line>.  The
          value of 'column' must be > 9, so that the version of THE is
          not obscured.
     
          Options will be displayed in the order in which they are set.
     
          If <SET CLOCK> or <SET HEX> are ON, these will take precedence
          over options specified with this command.
     
          The more values you display the longer it will take THE to display
          the <status line>.  Also, some values that are available via
          <EXTRACT> are not really suitable for use here. eg CURLINE.3.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: N/A
     
     DEFAULT
          ON NBFILE.1 13 0 Files=
          ON WIDTH.1 23 0 Width=
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          set statusline - set position of status line
     
     SYNTAX
          [SET] STATUSLine Top|Bottom|Off|GUI
     
     DESCRIPTION
     
          The SET STATUSLINE command determines the position of the
          <status line> for the editing session. TOP will place the status
          line on the first line of the screen; BOTTOM will place the status
          line on the last line of the screen; OFF turns off the display of
          the status line.
     
          The GUI option is only meaningful for those platforms that support
          a separate status line window. If specified for non-GUI ports, the
          GUI option is equivalent to OFF.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible.
                 Added GUI option for THEdit port.
     
     DEFAULT
          Bottom
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          set stay - set condition of cursor position after CHANGE/LOCATE commands
     
     SYNTAX
          [SET] STAY ON|OFF
     
     DESCRIPTION
          The SET STAY set command determines what line is displayed as the
          current line after an unsuccessful <LOCATE> or successful <CHANGE>
          command.
     
          With STAY ON, the <current line> remains where it currently is.
     
          With STAY OFF, after an unsuccessful <LOCATE>, the <current line>
          becomes the <Bottom-of-File line> (or <Top-of-File line> if direction
          is backwards).
     
          After a successful <CHANGE>, the <current line> is the last
          line affected by the <CHANGE> command.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     DEFAULT
          ON
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          set synonym - define synonyms for commands (unavailable)
     
     SYNTAX
          [SET] SYNonym ON|OFF
          [SET] SYNonym [LINEND char] newname [n] definition
     
     DESCRIPTION
          The SET SYNONYM command allows the user to define synonyms for
          commands or macros.
     
          The first format indicates if synonym processing is to be performed.
     
          The second format defines a command synonym.
     
          The synonym is 'newname', which effectively adds a new THE
          command with the definition specified by 'definition'.  The 'n'
          parameter defines the minimum length of the abbreviation for
          the new command
          An optional LINEND character can be specified prior to 'newname'
          if the 'definition' contains multiple commands.
     
          'definition' can be of the form:
          [REXX] command [args] [#command [args] [...]]
          (where # represents the LINEND character specified prior to
          'newname')
     
          If the optional keyword; 'REXX', is supplied, the remainder of the
          command line is treated as a Rexx macro and is passed onto the
          Rexx interpreter (if you have one) for execution.
     
          Only 1 level of synonym processing is carried out; therefore
          a synonym cannot be specified in the 'definition'.
     
     COMPATIBILITY
          XEDIT: Compatible. Does not support format that can reorder paramaters.
          KEDIT: Compatible.
     
     DEFAULT
          OFF
     
     STATUS
          Incomplete.



     --------------------------------------------------------------------------
     COMMAND
          set tabkey - set characteristics of the SOS TABF command
     
     SYNTAX
          [SET] TABKey Tab|Character Tab|Character
     
     DESCRIPTION
          The SET TABKEY sets the action to be taken when the <SOS TABF>
          command is executed. Depending on the insert mode, the <SOS TABF>
          command will either display a raw tab character or will move to
          the next tab column.
     
          The first operand refers to the behaviour of the <SOS TABF> command
          when <SET INSERTMODE> is OFF.
     
          The second operand specifies the behaviour when the <SOS TABF>
          command is executed when <SET INSERTMODE> is ON.
     
          All options can be specified as the current EQUIVCHAR to retain the
          existing value.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: N/A
     
     DEFAULT
          Tab Character
     
     SEE ALSO
          <SET EQUIVCHAR>
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          set tabline - set position and status of tab line on screen
     
     SYNTAX
          [SET] TABLine ON|OFF [M[+n|-n]|[+|-]n]
     
     DESCRIPTION
          The SET TABLINE command sets the position and status of the <tab line>
          for the current view.
     
          The first form of parameters is:
     
          M[+n|-n]
          this sets the <tab line> to be relative to the middle of
          the screen. A positive value adds to the middle line number,
          a negative subtracts from it.
          eg. M+3 on a 24 line screen will be line 15
              M-5 on a 24 line screen will be line 7
     
          The second form of parameters is:
     
          [+|-]n
          this sets the <tab line> to be relative to the top of the
          screen (if positive or no sign) or relative to the bottom
          of the screen if negative.
          eg. +3 or 3 will set current line to line 3
              -3 on a 24 line screen will be line 21
     
          If the resulting line is outside the bounds of the screen
          the position of the current line will become the middle line
          on the screen.
     
          It is an error to try to position the TABL line on the same
          line as <SET CURLINE>.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     DEFAULT
          OFF -3
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          set tabs - set tab columns or tab length
     
     SYNTAX
          [SET] TABS n1 [n2 ... n32]
          [SET] TABS INCR n
          [SET] TABS OFF
     
     DESCRIPTION
          The SET TABS command determines the position of tab columns in THE.
     
          The first format of SET TABS, specifies individual tab columns. Each
          column must be greater than the column to its left.
     
          The second format specifies the tab increment to use. ie each tab
          column will be set at each 'n' columns.
     
          The third format specifies that no tab columns are to be set.
     
          Tab columns are used by <SOS TABF>, <SOS TABB> and <SOS SETTAB>
          commands to position the cursor and also by the <COMPRESS> and
          <EXPAND> commands.
     
     COMPATIBILITY
          XEDIT: Compatible. Does not support OFF option.
          KEDIT: Compatible. Does not support OFF option.
     
     DEFAULT
          INCR 8
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          set tabsin - set tab processing on file input
     
     SYNTAX
          [SET] TABSIn ON|OFF [n]
     
     DESCRIPTION
          The SET TABSIN command determines if tabs read from a file are to be
          expanded to spaces and if so how many spaces.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Does not support TABQUOTE option.
     
     DEFAULT
          OFF 8
     
     SEE ALSO
          <SET TABSOUT>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          set tabsout - set tab processing on file output
     
     SYNTAX
          [SET] TABSOut ON|OFF [n]
     
     DESCRIPTION
          The SET TABSOUT command determines if spaces written to a file are to
          be compressed to tabs and if so how many spaces.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible.
     
     DEFAULT
          OFF 8
     
     SEE ALSO
          <SET TABSIN>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          set targetsave - set type(s) of targets to save for subsequent LOCATEs
     
     SYNTAX
          [SET] TARGETSAVE ALL|NONE| STRING REGEXP ABSOLUTE RELATIVE POINT BLANK
     
     DESCRIPTION
          The SET TARGETSAVE command allows you to specify which target
          types are saved for subsequent calls to the LOCATE command without any
          parameters.
     
          By default; SET TARGETSAVE ALL, the LOCATE command without any
          parameters, locates the last target irrespective of the type of target.
     
          SET TARGETSAVE NONE turns off saving of targets, but does not delete
          any already saved target.
     
          Any combination of the target types, STRING, REGEXP, ABSOLUTE, RELATIVE,
          POINT, or BLANK can be supplied. eg. SET TARGETSAVE STRING POINT.
     
          As an example, having SET TARGETTYPE STRING then the only target saved
          will be one that has a string target component.
          ie. if you executed LOCATE /fred/ then LOCATE :3 then LOCATE, the final
          LOCATE will look for /fred/ NOT :3
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: N/A
     
     DEFAULT
          ALL
     
     SEE ALSO
          <LOCATE>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          set thighlight - specify if text highlighting is supported
     
     SYNTAX
          [SET] THIGHlight ON|OFF
     
     DESCRIPTION
          The SET THIGHLIGHT command allows the user to specify if a the result
          of a string <LOCATE> command should be highlighted.  The colour that is
          used to highlight the found string is set by the THIGHLIGHT option
          of <SET COLOUR>.
          The found string is highlighted until a new line is added or deleted, a
          command is issued from the command line, another <LOCATE> or <CLOCATE>
          command is executed, a block is marked, or <RESET> THIGHLIGHT is executed.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible.
     
     DEFAULT
          ON - THE/KEDIT/KEDITW OFF - XEDIT/ISPF
     
     SEE ALSO
          <LOCATE>, <SET COLOUR>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          set timecheck - specify if time stamp checking done
     
     SYNTAX
          [SET] TIMECHECK ON|OFF
     
     DESCRIPTION
          The SET TIMECHECK command allows the user to specify if a check
          is made of the modification time of the file being saved at the
          time of saving.  This is done to alert the user if a file has
          changed since they began editing the file.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible.
     
     DEFAULT
          ON
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          set tofeof - specify if TOF and BOF lines are displayed
     
     SYNTAX
          [SET] TOFEOF ON|OFF
     
     DESCRIPTION
          The SET TOFEOF command allows the user to specify if the
          <Top-of-File line> and the <Bottom-of-File line> are displayed.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible.
     
     DEFAULT
          ON
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          set trailing - specify how to treat trailing blanks on lines
     
     SYNTAX
          [SET] TRAILING ON|OFF|SINGLE|EMPTY
     
     DESCRIPTION
          The SET TRAILING set command determines how trailing blanks on
          lines are handled when written to disk.
          TRAILING ON means that THE will not treat trailing blanks any
          differently from any other characters in the file.
          With TRAILING OFF, THE will remove trailing blanks when a file is
          read, remove them during an edit session, and not write any trailing
          blanks to the file.
          TRAILING SINGLE is the same as TRAILING OFF, except that a single
          blank character is appended to the end of every line when the file
          is written.
          TRAILING EMPTY is the same as TRAILING OFF, except that otherwise
          empty lines will be written with a single trailing blank.
     
          Note that the default for this under THE is ON. This is because of
          the way that THE processes profile files.  If the default was OFF,
          and you had TRAILING ON in your profile, then there would be no
          way to retain the original trailing blanks.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: N/A
     
     DEFAULT
          ON
     
     STATUS
          Complete.  Some trailing blank behaviour while editing files incomplete.



     --------------------------------------------------------------------------
     COMMAND
          set trunc - specify the truncation column
     
     SYNTAX
          [SET] TRunc n|*
     
     DESCRIPTION
          The SET TRUNC set command determines the truncation column.  This
          is the rightmost column of text upon which THE commands are
          effective.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     DEFAULT
          *
     
     STATUS
          Incomplete.



     --------------------------------------------------------------------------
     COMMAND
          set typeahead - set behaviour of screen redraw
     
     SYNTAX
          [SET] TYPEAhead ON|OFF
     
     DESCRIPTION
          The SET TYPEAHEAD set command determines whether or not THE uses the
          curses screen display optimization techniques.
     
          With TYPEAHEAD ON, curses will abort screen display if a keystroke
          is pending.
     
          With TYPEAHEAD OFF, curses will not abort screen display if a
          keystroke is pending.
     
          For BSD based curses, this function has no effect.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: N/A
     
     DEFAULT
          OFF
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          set undoing - turn on or off undo facility for the current file
     
     SYNTAX
          [SET] UNDOING ON|OFF
     
     DESCRIPTION
          The SET UNDOING command allows the user to turn on or off the
          undo facility for the current file.
     
          At this stage in the development of THE, setting UNDOING to OFF
          stops THE from saving changes made to lines in a file, and
          prevents those lines from being able to be RECOVERed.
     
          Setting UNDOING to OFF will increase the speed at which THE can
          execute CHANGE and DELETE commands.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Does not support optional arguments.
     
     DEFAULT
          ON
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          set untaa - specifies if "Unsigned Numerical Targets Are Absolute"
     
     SYNTAX
          [SET] UNTAA ON|OFF
     
     DESCRIPTION
          The SET UNTAA command allows the user to turn on or off the
          behaviour of unsigned numerical targets.
     
          Numerical targets have the form [:|;|+|-]nn. By default, if the
          optional portion of the target is not supplied, then a '+' is
          assumed.  WIth SET UNTAA set to ON, if the optional portion of the
          target is not supplied, then a ':' is assumed.
     
          Caution:  This SET command affects all numerical targets, not
          just targets in the LOCATE command.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: N/A
     
     DEFAULT
          OFF
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          set verify - set column display limits
     
     SYNTAX
          [SET] Verify first [last]
     
     DESCRIPTION
          The SET VERIFY command sets the column limits for the display of the
          current file. 'first' specifies the first column to be displayed
          and 'last' specifies the last column to be displayed.
     
          If no 'last' option is specified '*' is assumed.
     
          All options can be specified as the current EQUIVCHAR to retain the
          existing value.
     
     COMPATIBILITY
          XEDIT: Does not implement HEX display nor multiple column pairs.
          KEDIT: Does not implement HEX display nor multiple column pairs.
     
     DEFAULT
          1 *
     
     SEE ALSO
          <SET ZONE>, <SET EQUIVCHAR>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          set width - set width of maximum line that THE can edit
     
     SYNTAX
          [SET] WIDTH n
     
     DESCRIPTION
          The SET WIDTH command specifies the maximum length that a line
          can be within the edit session. This command is effectively the
          same as the -w command line switch.
     
          The value 'n' MUST be between 10 and 32700.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: N/A
     
     DEFAULT
          512
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          set word - controls what THE considers a word to be
     
     SYNTAX
          [SET] WORD NONBlank|ALPHAnum
     
     DESCRIPTION
          The SET WORD set command determines what sequence of characters THE
          considers a word to be. This is used in command such as <SOS DELWORD>,
          <SOS TABWORDF> and <MARK> WORD to specify the boundaries of the word.
     
          The default setting for SET WORD is 'NONBlank'. THE treats all
          sequences of characters seperated by a blank (ASCII 32) as words.
     
          With 'ALPHAnum' THE treats a group of consecutive alphanumeric
          characters as a word.  THE also includes the underscore character
          and characters with an ASCII value > 128 as alphanumeric.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible.
     
     DEFAULT
          NONBlank
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          set wordwrap - set wordwrap feature on or off
     
     SYNTAX
          [SET] WORDWrap ON|OFF
     
     DESCRIPTION
          The SET WORDWRAP set command determines whether wordwrap occurs when
          the cursor moves past the right margin (as set by the <SET MARGINS>
          command).
     
          With WORDWRAP ON, the line, from the beginning of the word that
          exceeds the right margin, is wrapped onto the next line. The cursor
          position stays in the same position relative to the current word.
     
          With WORDWRAP OFF, no word wrap occurs.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible.
     
     DEFAULT
          OFF
     
     SEE ALSO
          <SET MARGINS>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          set wrap - enable/disable string locates around the end of the file
     
     SYNTAX
          [SET] WRap ON|OFF
     
     DESCRIPTION
          The SET WRAP set command determines whether THE will look for a
          string target off the ends of the file.
     
          With WRAP OFF, THE will attempt to locate a string target from the
          current line to the end of file (or top of file if the locate is
          a backwards search).
     
          With WRAP ON, THE will attempt to locate a string target from the
          current line to the end of file (or top of file if the locate is
          a backwars search) and wrap around the end of the file and continue
          searching until the current line is reached.
     
          If the string target is located after wrapping around the end of
          the file, the message 'Wrapped...' is displayed.
     
          Commands affected by SET WRAP are; <LOCATE>, <FIND>, <NFIND>,
          <FINDUP> and <NFINDUP>.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible.
     
     DEFAULT
          OFF
     
     SEE ALSO
          <LOCATE>, <FIND>, <NFIND>, <FINDUP>, <NFINDUP>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          set xterminal - set X terminal to execute under X
     
     SYNTAX
          [SET] XTERMinal program
     
     DESCRIPTION
          The SET XTERMINAL set command allows the user to specify the full
          quallified file name of the program to run when the <OS>, <DOS> or <!>
          command is entered without parameters when running the X version
          of THE.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: N/A
     
     DEFAULT
          System dependent but usually one of:
     
               /usr/bin/X11/xterm
               /usr/openwin/bin/xterm
     
          The default value is set by the configure script.
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          set zone - set column limits for editing
     
     SYNTAX
          [SET] Zone first [last]
     
     DESCRIPTION
          The SET ZONE command sets the column limits for various other editor
          commands, such as <LOCATE> and <CHANGE>. It effectively restricts
          to the specified columns those parts of the file which can be
          acted upon.
     
          If no 'last' option is specified '*' is assumed.
     
          All options can be specified as the current EQUIVCHAR to retain the
          existing value.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     DEFAULT
          1 *
     
     SEE ALSO
          <SET VERIFY>, <SET EQUIVCHAR>
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     
     
     ========================================================================
     QUERY, EXTRACT and STATUS
     ========================================================================
     
          The following lists the valid variables that can be queried and
          also shows what values are returned. For both <QUERY> and <STATUS>,
          the values are concatenated together and displayed as a single
          line. For <EXTRACT> the REXX variables that are set are defined.
          The capitalised portion of the variable is the minimum abbreviation
          recognised.
     
          The bracketed text at the end of the description indicates from
          which commands a valid response will be supplied.
          (Q-Query, E-Extract, M-Modify and S-Status).
     
     ALT
          The number of alterations to the current file since the last <SAVE>
          or automatic save via <SET AUTOSAVE>. Can be set by <SET ALT>
          (QES)
     
          alt.0           - 2
          alt.1           - Number of alterations since last SAVE or autosave
          alt.2           - Number of alterations since last SAVE
     
     ARBchar
          The status of <SET ARBCHAR> and the ARBCHAR characters.
          (QEMS)
     
          arbchar.0       - 3
          arbchar.1       - ON|OFF
          arbchar.2       - multiple match character
          arbchar.3       - single match character
     
     AUTOCOLOR [*|mask]
     AUTOCOLOUR [*|mask]
          The status of auto colouring for the supplied file mask or
          "magic number". Set by <SET AUTOCOLOR> or <SET AUTOCOLOUR>.
          The variable name is spelt the save way that the option is specified.
          (QES)
     
          autocolor.0     - 3
          autocolor.1     - filemask or "magic number"
          autocolor.2     - name of parser associated or "NULL"
          autocolor.3     - MAGIC (if "magic number") or empty
     
          If no file mask or "magic number" is supplied as a parameter
          or '*' is passed, details of all parser mappings are set as
          follows:
     
          autocolor.0     - number of parser mappings
          autocolor.1     - first mapping (mask parser [MAGIC])
          autocolor.n     - nth mapping
     
     AUtosave
          The status of <SET AUTOSAVE> and/or the frequency setting.
          (QEMS)
     
          autosave.0      - 1
          autosave.1      - OFF|n
     
     AUTOSCroll
          The status of <SET AUTOSCROLL> and/or the frequency setting.
          (QEMS)
     
          autoscroll.0    - 1
          autoscroll.1    - OFF|HALF|n
     
     BACKup
          Indicates if a .bak file is kept after editing.
          (QEMS)
     
          backup.0        - 1
          backup.1        - ON|OFF|TEMP|KEEP|INPLACE
     
     BEEP
          Indicates if the bell is sounded on display of error messages.
          Set by <SET BEEP>
          (QEMS)
     
          beep.0          - 1
          beep.1          - ON|OFF
     
     BLOCK
          Returns information about the marked <block>, if any.
          (QE)
     
          block.0         - 6 if a marked block exists, or 1 for NONE
          block.1         - type of marked block (LINE|BOX|NONE|WORD|COLUMN|CUA)
          block.2         - line number of start of block
          block.3         - column number of start of block
          block.4         - line number of end of block
          block.5         - column number of end of block
          block.6         - file name containing marked block
     
     CASE
          The settings related to the CASE of characters entered, searched
          for, changed and sorted. Set by <SET CASE>
          (QEMS)
     
          case.0          - 4
          case.1          - MIXED|UPPER|LOWER
          case.2          - RESPECT|IGNORE
          case.3          - RESPECT|IGNORE
          case.4          - RESPECT|IGNORE
     
     CLEARErrorkey
          Returns the key that clears the <message line>. If no specific
          key is defined, ie ALL keys perform a reset, then * is returned.
          Set by <SET CLEARERRORKEY>.
          (QEMS)
     
          clearerrorkey.0 - 1
          clearerrorkey.1 - keyname|*
     
     CLEARScreen
          Indicates if the screen is cleared on exit from THE. Set by
          <SET CLEARSCREEN>.
          (QEMS)
     
          clearscreen.0   - 1
          clearscreen.1   - ON|OFF
     
     CLOCK
          Indicates if the time is displayed on the status line. Set by
          <SET CLOCK>.
          (QEMS)
     
          clock.0         - 1
          clock.1         - ON|OFF
     
     CMDArrows
          Returns the settings for arrow key behaviour on <command line>.
          Set by <SET CMDARROWS>.
          (QEMS)
     
          cmdarrows.0     - 1
          cmdarrows.1     - RETRIEVE|TAB
     
     CMDline
          The settings for the <command line>. Set by <SET CMDLINE>.
          (QEMS)
     
          If CMDLINE OFF
     
          cmdline.0       - 1
          cmdline.1       - OFF
     
          If CMDLINE ON, BOTTOM or TOP
     
          cmdline.0       - 3
          cmdline.1       - ON|TOP|BOTTOM
          cmdline.2 *     - line number within window of command line
          cmdline.3 *     - contents of command line
     
          * these values are only returned with <EXTRACT>
     
     COLOR [*|area]
     COLOUR [*|area]
          Displays the current color settings for the file.
          Set by <SET COLOR> or <SET COLOUR>. The variable name is
          spelt the save way that the option is specified.
     
          With the ['*'] option, (or no option), returns color settings
          for all areas of the screen.
          (QE)
     
          color.0         - 32
          color.1         - FILEAREA    followed by its color
          color.2         - CURLINE     followed by its color
          color.3         - BLOCK       followed by its color
          color.4         - CBLOCK      followed by its color
          color.5         - CMDLINE     followed by its color
          color.6         - IDLINE      followed by its color
          color.7         - MSGLINE     followed by its color
          color.8         - ARROW       followed by its color
          color.9         - PREFIX      followed by its color
          color.10        - CPREFIX     followed by its color
          color.11        - PENDING     followed by its color
          color.12        - SCALE       followed by its color
          color.13        - TOFEOF      followed by its color
          color.14        - CTOFEOF     followed by its color
          color.15        - TABLINE     followed by its color
          color.16        - SHADOW      followed by its color
          color.17        - STATAREA    followed by its color
          color.18        - DIVIDER     followed by its color
          color.19        - RESERVED    followed by its color
          color.20        - NONDISP     followed by its color
          color.21        - HIGHLIGHT   followed by its color
          color.22        - CHIGHLIGHT  followed by its color
          color.23        - THIGHLIGHT  followed by its color
          color.24        - SLK         followed by its color
          color.25        - GAP         followed by its color
          color.26        - CGAP        followed by its color
          color.27        - ALERT       followed by its color
          color.28        - DIALOG      followed by its color
          color.29        - BOUNDMARKER followed by its color
          color.30        - FILETABS    followed by its color
          color.31        - FILETABSDIV followed by its color
          color.32        - CURSORLINE  followed by its color
     
          With the ['area'] option, returns color settings
          for the specified area of the screen.
          (QE)
     
          color.0         - 1
          color.1         - 'area' followed by its color
     
     COLORING
     COLOURING
          Displays the current color settings for the file. The variable
          name is spelt the same way that the option is specified.
          Set by <SET COLORING> or <SET COLOURING>.
          (QEMS)
     
          coloring.0      - 3
          coloring.1      - ON|OFF
          coloring.2      - AUTO|parser (if coloring.1 is ON)
          coloring.3      - parser (if coloring.1 is ON)
     
     COLUMN
          Displays the current value of the focus column.
          (QE)
     
          column.0        - 1
          column.1        - Column number of focus column
     
     COMPAT
          The settings for the compatibility mode. Set by <SET COMPAT>.
          (QEMS)
     
          compat.0        - 3
          compat.1        - THE|XEDIT|KEDIT|KEDITW|ISPF (compatibility LOOK)
          compat.2        - THE|XEDIT|KEDIT|KEDITW|ISPF (compatibility FEEL)
          compat.3        - THE|XEDIT|KEDIT|KEDITW|ISPF (compatibility KEYS)
     
     CTLchar [*|char]
          The definitions of control characters that affect the display of
          <reserved line>s. Set by <SET CTLCHAR>.
          (QES)
     
          With the ['*'] option, (or no option), returns a list of all
          control characters that have been defined.
     
          ctlchar.0       - 3
          ctlchar.1       - ON|OFF
          ctlchar.2       - The character defined as the escape character.
          ctlchar.3       - List of defined control characters, if any.
     
          With the ['char'] option, returns color settings for the specified
          control character.
     
          ctlchar.0       - 1 if ctlchar.1 is OFF, otherwise 2
          ctlchar.1       - PROTECT|NOPROTECT|OFF
          ctlchar.2       - The color defined for this control character.
     
     CURline
          The value and position of the <current line> within the current file.
          Set by <SET CURLINE>. Also provides the contents of the <focus line>
          and an indication of the status of the <focus line> for the current
          session.
          (QEMS)
     
          With <EXTRACT> command:
     
          curline.0       - 6
          curline.1       - curline setting
          curline.2       - line number within window of current line
          curline.3       - contents of <focus line>
          curline.4       - ON|OFF (ON if line has changed or been added this session)
          curline.5       - OLD|OLD CHANGED|NEW|NEW CHANGED
          curline.6       - selection level of focus line (same as select.1)
     
          Note: If <SET COMPAT> (feel) is set to XEDIT, curline.3 will always
          return the contents of the <current line>.
     
          The setting of curline.5 is as follows:
            OLD:            The line existed in its current form in the
                            file before THE began.
            OLD CHANGED:    The line was in the file before THE started,
                            but has been changed during the current editing
                            session.
            NEW:            The line has been added to the file during
                            the current edit session and not been changed.
            NEW CHANGED:    The line has been added to the file during
                            the current editing session and has been changed.
     
          With <QUERY>, <MODIFY> and <STATUS> commands:
     
          curline.0       - 1
          curline.1       - curline setting
     
     CURSor
          The position of the cursor within the displayed screen and file
          at the time the <EXTRACT> /CURSOR/ is issued and the position of
          the cursor at the time the <macro> was issued.
          If the cursor is not in the <filearea>, then line and column
          values will be set to -1.
          (QE)
     
          cursor.0        - 8
          cursor.1        - line number of cursor in screen (current)
          cursor.2        - column number of cursor in screen (current)
          cursor.3        - line number of cursor in file (current)
          cursor.4        - column number of cursor in file (current)
          cursor.5        - line number of cursor in screen (original)
          cursor.6        - column number of cursor in screen (original)
          cursor.7        - line number of cursor in file (original)
          cursor.8        - column number of cursor in file (original)
     
     CURSORSTay
          The setting for the behaviour of the cursor after a file scroll.
          Set by <SET CURSORSTAY>.
          (QEMS)
     
          cursorstay.0    - 1
          cursorstay.1    - ON|OFF
     
     DEFINE [key|mousedef IN window|*]
          Returns details about the commands associated with a keyboard key
          or mouse key.  The details returned are the same as those displayed
          by the <SHOWKEY> command.
          Set by <DEFINE>.
          (QEM)
     
          Three forms are available:
     
          With no parameter or '*', all details about all key and mouse
          definitions are returned. (Similar to <SHOWKEY> all)
     
          define.0        - number of all definitions
          define.1        - command assigned to the 1st key or mouse
          define.n        - command assigned to the nth key or mouse
     
          With a 'key' mnemonic specified, details about this one key are
          returned.
     
          define.0        - 1
          define.1        - command assigned to the key
     
          With a 'mousedef IN window' specified, details about this one mouse
          mapping for a window are returned.
     
          define.0        - 1
          define.1        - command assigned to the mouse for the window
     
     DEFSORT
          Specifies the order in which files are sorted in the DIR.DIR file.
          Set by <SET DEFSORT>.
          (QEMS)
     
          defsort.0       - 2
          defsort.1       - DIRECTORY|NAME|SIZE|TIME|DATE|OFF
          defsort.2       - ASCENDING|DESCENDING
     
     DIRFILEID
          The value of the path and filename of the focus line in a DIR.DIR
          file.
          (E)
     
          dirfileid.0     - 2
          dirfileid.1     - full path of directory
          dirfileid.2     - file name at focus line
     
     DIRInclude
          The value of the file type masks currently in place for display
          in DIR.DIR file. Set by <SET DIRINCLUDE>.
          (QEMS)
     
          dirinclude.0    - 1
          dirinclude.1    - list of file types shown in DIR.DIR file
     
     DISPlay
          Indicates the range of selection levels current. Set by
          <SET DISPLAY>.
          (QEMS)
     
          display.0       - 2
          display.1       - display low value
          display.2       - display high value
     
     ECOLOR [*|category]
     ECOLOUR [*|category]
          Displays the current color settings for syntax highlighting.
          Set by <SET ECOLOR> or <SET ECOLOUR>. The variable name is
          spelt the save way that the option is specified.
     
          With the ['*'] option, (or no option), returns color settings
          for all categories.
          (QE)
     
          ecolor.0        - 35
          ecolor.1        - A followed by its color
          ecolor.2        - B followed by its color
          ecolor.3        - C followed by its color
          ecolor.4        - D followed by its color
          ecolor.5        - E followed by its color
          ecolor.6        - F followed by its color
          ecolor.7        - G followed by its color
          ecolor.8        - H followed by its color
          ecolor.9        - I followed by its color
          ecolor.10       - J followed by its color
          ecolor.11       - K followed by its color
          ecolor.12       - L followed by its color
          ecolor.13       - M followed by its color
          ecolor.14       - N followed by its color
          ecolor.15       - O followed by its color
          ecolor.16       - P followed by its color
          ecolor.17       - Q followed by its color
          ecolor.18       - R followed by its color
          ecolor.19       - S followed by its color
          ecolor.20       - T followed by its color
          ecolor.21       - U followed by its color
          ecolor.22       - V followed by its color
          ecolor.23       - W followed by its color
          ecolor.24       - X followed by its color
          ecolor.25       - Y followed by its color
          ecolor.26       - Z followed by its color
          ecolor.27       - 1 followed by its color
          ecolor.28       - 2 followed by its color
          ecolor.29       - 3 followed by its color
          ecolor.30       - 4 followed by its color
          ecolor.31       - 5 followed by its color
          ecolor.32       - 6 followed by its color
          ecolor.33       - 7 followed by its color
          ecolor.34       - 8 followed by its color
          ecolor.35       - 9 followed by its color
     
          With the ['category'] option, returns color settings
          for the specified syntax highlighting category.
          (E)
     
          color.0         - 1
          color.1         - ['category'] followed by its color
     
     EFILEId
          The original full filename of the current file. See <SET FILENAME> for a
          full description of the components of a file name. EFILEID.2 differs from
          the value returned by KEDIT.
          (QE)
     
          efileid.0       - 2
          efileid.1       - Original full file name.
          efileid.2       - Original file name used to edit the file.
     
     EOF
          Indicates if the <current line> is on the <Bottom-of-File line>.
          (QES)
     
          eof.0           - 1
          eof.1           - ON|OFF
     
     EOLout
          Returns the value of the end-of-line character(s).
          (QEMS)
     
          eolout.0        - 1
          eolout.1        - LF|CRLF|CR|NONE
     
     EQUIVChar
          Returns the equivalence character. Set by <SET EQUIVCHAR>.
          (QEMS)
     
          equivchar.0     - 2
          equivchar.1     - equivalence character
     
     ETMODE
          Indicates if extended display mode is set. Set by <SET ETMODE>.
          (QEMS)
     
          etmode.0        - 2
          etmode.1        - ON|OFF
          etmode.2        - character ranges if not all ON or OFF
     
     FExt
          The extension of the current file. The characters following
          the trailing '.' character. Same as FType.
          (QEM)
     
          fext.0          - 1
          fext.1          - File extension.
     
     FIELD
          Details about the current cursor field.
          (QE)
     
          field.0         - 4
          field.1         - contents of the cursor field
          field.2         - character under the cursor
          field.3         - column position in the cursor field
          field.4         - COMMAND|TEXT|PREFIX
     
     FIELDWORD
          Details about the word closest to the cursor in the current cursor field.
          (E)
     
          fieldword.0     - 2
          fieldword.1     - word as defined by <SET WORD> ALPHANUM
          fieldword.2     - word as defined by <SET WORD> NONBLANK
     
     FILEName
          The full filename of the current file, including any file
          extension.
          (QEM)
     
          filename.0      - 1
          filename.1      - Full file name.
     
     FILESTATUS
          Details about the status of the file being edited.
          (QEM)
     
          filestatus.0    - 3
          filestatus.1    - sharing mode - NONE
          filestatus.2    - access type - READONLY|READWRITE
          filestatus.3    - end of line - CR/LF/CRLF/NONE
     
     FMode
          The file mode of the current file. Under Un*x, this will
          always return an empty string. Other platforms returns the
          first character of the file's path. ie the disk drive.
          (QEM)
     
          fmode.0         - 1
          fmode.1         - File mode.
     
     FName
          The fname portion of the current file. See <SET FILENAME> for a
          full description of the components of a file name.
          (QEM)
     
          fname.0         - 1
          fname.1         - File name.
     
     FPath
          The path name of the current file. This includes a trailing
          directory separator.
          (QEM)
     
          fpath.0         - 1
          fpath.1         - File path.
     
     FType
          The extension of the current file. The characters following
          the trailing '.' character.
          (QEM)
     
          ftype.0         - 1
          ftype.1         - File extension.
     
     FULLFName
          Indicates if the fully qualified filename is displayed on the
          <idline>.
          (QEMS)
     
          fullfname.0     - 1
          fullfname.1     - ON|OFF
     
     GETENV variable
          The value of the supplied environment 'variable' or ***invalid***
          if the 'variable' does not exist. On platforms other than Unix
          the supplied variable name is uppercased before obtaining the
          environment variable value.
          (E)
     
          getenv.0        - 1
          getenv.1        - value of variable
     
     HEX
          Indicates if hexadecimal values in commands are interpreted
          as hexadecimal values or not. Set by <SET HEX>.
          (QEMS)
     
          hex.0           - 1
          hex.1           - ON|OFF
     
     HEADer
          Returns details about which sections of a TLD file are to be
          applied to the current view. Do not rely on the position of a
          particular header in the returned stem. Set by <SET HEADER>.
          (QE)
     
          header.0        - 11
          header.1        - section ON|OFF
          header.2        - section ON|OFF
          header.3        - section ON|OFF
          header.4        - section ON|OFF
          header.5        - section ON|OFF
          header.6        - section ON|OFF
          header.7        - section ON|OFF
          header.8        - section ON|OFF
          header.9        - section ON|OFF
          header.10       - section ON|OFF
          header.11       - section ON|OFF
     
     HEXDISPlay
          Indicates if the current character is displayed on the <status line>.
          Set by <SET HEXDISPLAY>.
          (QEMS)
     
          hexdisplay.0    - 1
          hexdisplay.1    - ON|OFF
     
     HEXShow
          Returns details of HEXSHOW placement. Set by <SET HEXSHOW>.
          (QEMS)
     
          hexshow.0       - 2
          hexshow.1       - ON|OFF
          hexshow.2       - line displaying first hexshow line
     
     HIGHlight
          Returns details of HIGHLIGHT settings. Set by <SET HIGHLIGHT>.
          (QEMS)
     
          highlight.0     - 1 or 3 (if highlight.1 = SELECT)
          highlight.1     - OFF|ALTERED|TAGGED|SELECT
          highlight.2     - minimum (or only) selection level for SELECT
          highlight.3     - maximum selection level for SELECT
     
     IDline
          Indicates if the <idline> is displayed for a file. Set by
          <SET IDLINE>.
          (QEMS)
     
          idline.0        - 1
          idline.1        - ON|OFF
     
     IMPMACro
          Indicates if implied <macro> processing is on or off. Set by
          <SET IMPMACRO>.
          (QEMS)
     
          impmacro.0      - 1
          impmacro.1      - ON|OFF
     
     IMPOS
          Indicates if implied operating system command processing is on
          or off. Set by <SET IMPOS> or <SET IMPCMSCP>.
          (QEMS)
     
          impos.0         - 1
          impos.1         - ON|OFF
     
     INPUTMode
          Indicates the inputmode for the current view.
          Set by <SET INPUTMODE>.
          (QEMS)
     
          inputmode.0     - 1
          inputmode.1     - OFF|FULL|LINE
     
     INSERTmode
          Indicates if currently in insert mode or overstrike mode. Set by
          <SET INSERTMODE>.
          (QEMS)
     
          insertmode.1    - 1
          insertmode.1    - ON|OFF
     
     LASTmsg
          Return the text of the last error message generated.
          (E)
     
          lastmsg.0       - 1
          lastmsg.1       - text of last message.
     
     LASTKEY [n]
          Return information about the last key, or the nth last key pressed.
          (E)
     
          lastkey.0       - 4
          lastkey.1       - name of the key.
          lastkey.2       - character associated with the key (if applicable)
          lastkey.3       - curses mnemonic code
          lastkey.4       - shift status. see <READV> for details
     
     LASTOP [command|*]
          Returns the last operand from selected commands.  command can be
          one of ALter, Change, CLocate COUnt, Find, Locate SCHange or TFind.
          (QE)
          EXTract /LASTOP command/ sets:
     
          lastop.0        - 1
          lastop.1        - command and its last operand
     
          If no command is supplied as a parameter or '*' is passed,
          details of all last operands are set as follows:
     
          lastop.0        - 9
          lastop.1        - "alter" and its last operand (not implemented)
          lastop.2        - "change" and its last operand
          lastop.3        - "clocate" and its last operand (not implemented)
          lastop.4        - "count" and its last operand (not implemented)
          lastop.5        - "find" and its last operand
          lastop.6        - "locate" and its last operand
          lastop.7        - "schange" and its last operand
          lastop.8        - "tfind" and its last operand (not implemented)
          lastop.9        - "search" and its last operand
     
     LASTRC
          Returns the return code from last command issued from <command line>.
          (QES)
     
          lastrc.0        - 1
          lastrc.1        - Last return code.
     
     LENgth
          Length of the current line.
          (QES)
     
          length.0        - 1
          length.1        - Length of current line.
     
     LIne
          Line number of <focus line> in current file; or <current line>
          if <SET COMPAT> (feel) is set to XEDIT.
          (QES)
     
          line.0          - 1
          line.1          - Line number
     
     LINEFLAG
          Returns information about the flags set on the <focus line>, or
          <current line> if <SET COMPAT> (feel) is set to XEDIT.
          (QEMS)
     
          lineflag.0      - 3
          lineflag.1      - NEW|NONEW
          lineflag.2      - CHANGE|NOCHANGE
          lineflag.3      - TAG|NOTAG
     
     LINENd
          Indicates if multiple commands allowed on command line
          and the delimiter. Set by <SET LINEND>.
          (QEMS)
     
          linend.0        - 2
          linend.1        - ON|OFF
          linend.2        - delimiter
     
     LScreen
          Displays the size of the current screen and window. Also
          shows the upper left corner of the window.
          (QE)
     
          lscreen.0       - 6
          lscreen.1       - height of current screen
          lscreen.2       - width of current screen
          lscreen.3       - screen line of upper left corner of screen
          lscreen.4       - screen column of upper left corner of screen
          lscreen.5       - height of display
          lscreen.6       - width of display
     
     MACRO
          Indicates if macros are executed before commands. Set by
          <SET MACRO>.
          (QEMS)
     
          macro.0         - 1
          macro.1         - ON|OFF
     
     MACROExt
          The current setting for a macro's file extension. Set by
          <SET MACROEXT>.
          (QEMS)
     
          macroext.0      - 1
          macroext.1      - Default file extension
     
     MACROPath
          The path that THE looks for by default for macro files. Set by
          <SET MACROPATH>.
          (QEMS)
     
          macropath.0     - 1
          macropath.1     - Path for macro files.
     
     MARgins
          The settings for left and right margins and paragraph indent.
          Set by <SET MARGINS>.
          (QEMS)
     
          margins.0       - 3
          margins.1       - left column
          margins.2       - right column
          margins.3       - indent value (column or offset from left margin)
     
     MONITOR
          Indicates if the combination of monitor and the curses package
          supports colour. If the curses package supports colour, then
          monitor.1 is set to COLOR and monitor.2 can be COLOR or MONO
          depending on whether the monitor supports colour. If monitor.1
          is MONO then monitor.2 will also be set to MONO.
          (QE)
     
          monitor.0       - 2
          monitor.1       - COLOR|MONO
          monitor.2       - COLOR|MONO
     
     MOUSE
          Indicates if the mouse is suppoted as an input device. Set by
          <SET MOUSE>.
          (QEMS)
     
          mouse.0         - 1
          mouse.1         - ON|OFF
     
     MSGLine
          Returns details of where the <message line> is displayed. Set by
          <SET MSGLINE>.
          (QEMS)
     
          msgline.0       - 4
          msgline.1       - ON
          msgline.2       - line position of <message line>
          msgline.3       - number of message lines available
          msgline.4       - OVERLAY (returned for compatibility reasons)
     
     MSGMode
          Indicates if messages are suppressed. Set by <SET MSGMODE>.
          (QEMS)
     
          msgmode.0       - 1
          msgmode.1       - ON|OFF
     
     NBFile
          Returns with the number of files currently in the <ring>.
          (QES)
     
          nbfile.0        - 1
          nbfile.1        - Number of files in ring
     
     NBScope
          Returns with the number of lines currently in scope. If SCOPE ALL
          is in effect, this will be the same number as SIZE.
          (QE)
     
          nbscope.0       - 1
          nbscope.1       - Number of lines in scope
          nbscope.2       - Line number of focus line in scope
     
     NEWLines
          Indicates if NEWLINES variable is set to LEFT or ALIGNED.
          Set by <SET NEWLINES>.
          (QEMS)
     
          newlines.0      - 1
          newlines.1      - ALIGNED|LEFT
     
     NONDisp
          Returns the character that is displayed for extended characters
          that are not displayed. Set by <SET NONDISP>.
          (QEMS)
     
          nondisp.0       - 1
          nondisp.1       - char
     
     NUMber
          Indicates if line numbers are displayed in the prefix area.
          Set by <SET NUMBER>.
          (QEMS)
     
          number.0        - 1
          number.1        - ON|OFF
     
     PAGEWRAP
          Indicates if the scrolling the file view using the <FORWARD>
          and <BACKWARD> commands will wrap if the cursor is at the
          <Bottom-of-File line> or <Top-of-File line> respectively.
          Set by <SET PAGEWRAP>.
          (QEMS)
     
          pagewrap.0      - 1
          pagewrap.1      - ON|OFF
     
     PARSER [*|parser]
          Displays the filename of the THE Language Defintion file from which
          a syntax highlighting parser was loaded. Set by <SET PARSER>.
          (QES)
     
          parser.0        - 2
          parser.1        - Name of parser
          parser.2        - Filename of TLD file
     
          If no parser is supplied as a parameter or '*' is passed,
          details of all parsers are set as follows:
     
          parser.0        - number of parsers currently defined
          parser.1        - name and filename of first parser
          parser.i        - name and filename of ith parser
     
     PENDing [BLOCK] [OLDNAME] name|* [target1 [target2]
          Returns information about pending prefix commands.
          (E)
     
          pending.0       - 7
          pending.1       - line number in file
          pending.2       - newname - actual name entered in prefix area
          pending.3       - oldname - original name of macro after synonym resolution
          pending.4       - BLOCK or null
          pending.5       - value of first operand
          pending.6       - value of second operand
          pending.7       - value of third operand
     
     Point [*]
          Returns the name and line number of the <focus line>, or names and
          line numbers of all lines in a file if '*' is specified.
          If <SET COMPAT> (feel) is set to XEDIT, then the name and line number
          of the <current line> is returned, rather than the name and line
          number of the <focus line>.
     
          (QE)
     
          With no arguments:
     
          point.0         - 0 or 1       (0 if focus line not named)
          point.1         - line number and name of line (if line is named)
     
          With ['*'] argument:
          (E)
     
          point.0         - number of named lines in the file
          point.1         - line number and name for first named line
          point.n         - line number and name for nth named line
     
          Only point.0 and point.1 are available using implied extract
          functions.
     
     POSition
          Indicates if LINE/COL is displayed on <idline>. Set by
          <SET POSITION>.
          (QMS)
     
          position.0      - 1
          position.1      - ON|OFF
     
          The current/focus line/column is also returned via <EXTRACT>.
          (E)
     
          position.0      - 3
          position.1      - ON|OFF
          position.2      - current or focus line
          position.3      - current or focus column
     
     PREfix [Synonym *|name]
          Indicates if prefix is displayed for the view and if displayed
          where is is displayed. See <SET PREFIX>.
          (QEMS)
     
          prefix.0        - 1 or 2     (1 if prefix.1 is OFF, 2 otherwise)
          prefix.1        - ON|OFF|NULLS
          prefix.2        - LEFT|RIGHT        (if prefix.1 is ON or NULLS)
          prefix.3        - width of prefix area
          prefix.4        - width of prefix gap
     
          With ['Synonym name'] option, the macroname associated with the
          synonym 'name' is returned. If 'name' is not a synonym then 'name'
          is returned as the macroname.
          (QE)
     
          prefix.0        - 1
          prefix.1        - synonym macroname
     
          With ['Synonym *'] option, all prefix synonyms are returned.
          (QE)
     
          prefix.0        - number of prefix synonyms
          prefix.1        - synonym macroname
          prefix.n        - synonym macroname
     
     PRINTER
          Returns the value of the printer port or spooler. Set by
          <SET PRINTER>
          (QEMS)
     
          printer.0       - 1
          printer.1       - port or spooler name
     
     READONLY
          Indicates if the file being edited is allowed to be alterered.
          Set by <SET READONLY>.
          (QEMS)
     
          readonly.0      - 1
          readonly.1      - ON|OFF|FORCE
     
     REGEXP
          Return the type of regular expression syntax currently used
          for targets.
          Set by <SET REGEXP>.
          (QEMS)
     
          regexp.0        - 1
          regexp.1        - EMACS|AWK|POSIX_AWK|GREP|EGREP|POSIX_EGREP|SED|POSIX_BASIC
                          - |POSIX_MINIMAL_BASIC|POSIX_EXTENDED|POSIX_MINIMAL_EXTENDED
     
     REPROFile
          Indicates if the specified (or implied) profile file is re-executed each
          time a file is added to the ring.
          Set by <SET REPROFILE>.
          (QEMS)
     
          reprofle.0      - 1
          reprofle.1      - ON|OFF
     
     RESERved [*]
          Return with list of the screen rows that have been reserved.
          Set by <SET RESERVED>.
          (QES)
     
          reserved.0      - 0 if no reserved lines; 1 otherwise
          reserved.1      - list of screen row numbers reserved
     
          With ['*'] option, the line number, followed by the colour
          specification and <reserved line> contents are returned; one
          variable for each reserved line.
          (E)
     
          reserved.0      - the number of reserved lines
          reserved.1      - first reserved line
          reserved.2      - second reserved line
          reserved.n      - nth reserved line
     
     REXX
          Returns the version details of the Rexx interpreter (if any) in
          the same format as PARSE VERSION.
          (QE)
     
          rexx.0          - 1
          rexx.1          - Version strings
     
     REXXOUTput
          Indicates if <REXX> output is captured to a file or not and the
          line number limit of lines to be displayed. Set by <SET REXXOUTPUT>.
          (QEMS)
     
          rexxoutput.0    - 2
          rexxoutput.1    - FILE|DISPLAY
          rexxoutput.2    - line number limit
     
     RING
          Returns details of each file being edited.
          (QE)
     
          With <SET COMPAT> (feel) set to XEDIT, the values set are:
     
          ring.0          - number of variables returned (ring.1 + 1)
          ring.1          - number of files in the <ring>
          ring.2          - IDLINE of first file in the ring
          ring.3          - IDLINE of second file in the ring
          ring.n          - IDLINE of nth file in the ring
     
          With <SET COMPAT> (feel) set to THE or KEDIT, the values set are:
     
          ring.0          - number of files in the <ring>
          ring.1          - IDLINE of first file in the ring
          ring.2          - IDLINE of second file in the ring
          ring.n          - IDLINE of nth file in the ring
     
          Only ring.0 and ring.1 are available using implied extract
          functions.
     
     SCALe
          Returns details of <scale line>. Set by <SET SCALE>.
          (QEMS)
     
          scale.0         - 2
          scale.1         - ON|OFF
          scale.2         - line displaying scale line
     
     SCOPE
          Returns information about whether <shadow line>s will be affected by
          commands or not. Set by <SET SCOPE>.
          (QEMS)
     
          scope.0         - 1
          scope.1         - ALL|DISPLAY
     
     SCReen
          Returns the number and orientation of THE screens. Set by
          <SET SCREEN>.
          (QEMS)
     
          screen.0        - 2
          screen.1        - Number of screens displayed
          screen.2        - HORIZONTAL|VERTICAL
     
     SELect
          Returns the selection level of the <focus line> and the
          maximum selection level for the file. Set by <SET SELECT> and
          <ALL> commands. If <SET COMPAT> (feel) XEDIT is set, then the
          selection level of the <current line> is returned instead of
          the selection level of the <focus line>.
          (QES)
     
          select.0        - 2
          select.1        - selection level of focus line
          select.2        - maximum selection level for file
     
     SHADow
          Returns the status of the display of shadow lines. Set by
          <SET SHADOW>.
          (QEMS)
     
          shadow.0        - 1
          shadow.1        - ON|OFF
     
     SHOWkey key
          Returns the commands and parameters assigned to the 'key'
          passed as an argument.  This keyvalue is returned as
          READV.3 from a call to <READV> KEY.
          (E)
     
          showkey.0       - the number of commands assigned
          showkey.1       - first command/parameter assigned
          showkey.n       - last command/parameter assigned
     
          If no 'key' supplied as a parameter:
     
          showkey.0       - 1
          showkey.1       - INVALID KEY
     
          This item is not available as an implied extract function.
     
     SIze
          Returns the number of lines in the current file.
          (QES)
     
          size.0          - 1
          size.1          - Lines in current file.
     
     STATUSLine
          Indicates if the <status line> is displayed and if so, where.
          Set by <SET STATUSLINE>.
          (QEMS)
     
          statusline.0    - 1
          statusline.1    - TOP|BOTTOM|OFF
     
     STAY
          Indicates if the focus line stays where it is after a successful
          THE command or an unsuccessful <LOCATE> command.  Set by <SET STAY>.
          (QEMS)
     
          stay.0          - 1
          stay.1          - ON|OFF
     
     SYNonym [*|name]
          Indicates if synonym processing is on or off. Set by <SET SYNONYM>
          command.
          (QEMS)
     
          synonym.0       - 1
          synonym.1       - ON|OFF
     
          With ['name'] option, details about the defined synonym are
          returned.
          (QE)
     
          synonym.0       - 4
          synonym.1       - synonym name
          synonym.2       - length of minimum abbreviation
          synonym.3       - definition
          synonym.4       - linend character (if specified)
     
          With ['*'] option, details about all defined synonyms are
          returned.
          (QE)
     
          synonym.0       - number of synonyms defined
          synonym.1       - synonym definition of first synonym
          synonym.n       - synonym definition of nth synonym
     
     TABKey
          Returns settings about behaviour of TAB key.
          tabkey.1 indicates behaviour while not in insert mode
          tabkey.2 indicates behaviour while in insert mode
          Set by <SET TABKEY>.
          (QEMS)
     
          tabkey.0        - 2
          tabkey.1        - TAB|CHARACTER
          tabkey.2        - TAB|CHARACTER
     
     TABLine
          Returns details of if and where the <tab line> is displayed.
          Set by <SET TABLINE>.
          (QEMS)
     
          tabline.0       - 2
          tabline.1       - ON|OFF
          tabline.2       - line displaying tab line
     
     TABS
          Returns settings about tab columns. Set by <SET TABS>.
          (QEMS)
     
          tabs.0          - 1
          tabs.1          - actual tab columns or "INCR n"
     
     TABSIn
          Indicates if TABSIN processing is on or off and the size of the
          tabs setting. Set by <SET TABSIN>.
          (QEMS)
     
          tabsin.0        - 2
          tabsin.1        - ON|OFF
          tabsin.2        - size of tabs
     
     TABSOut
          Indicates if TABSOUT processing is on or off and the size of the
          tabs setting. Set by <SET TABSOUT>.
          (QEMS)
     
          tabsout.0       - 2
          tabsout.1       - ON|OFF
          tabsout.2       - size of tabs
     
     TARGETSAVE
          Indicates the type of targets saved for subsequent LOCATE commands.
          Set by <SET TARGETSAVE>.
          (QEMS)
     
          targetsave.0    - 1
          targetsave.1    - ALL|NONE|list of target types
     
     TERMinal
          Identifies the terminal type currently being used.
          (QES)
     
          terminal.0      - 1
          terminal.1      - DOS|OS2|X11|WIN32|$TERM value under Unix
     
     THIGHlight
          Indicates if text highlighting is on. ie a found string target is
          highlighted.
          Set by <SET THIGHLIGHT>
          (QEMS)
     
          thighlight.0    - 1
          thighlight.1    - ON|OFF
     
     TIMECHECK
          Indicates the status of TIMECHECK for the current file.
          (QEMS)
     
          timecheck.0     - 1
          timecheck.1     - ON|OFF
     
     TOF
          Indicates if the <current line> is on the <Top-of-File line>.
          (QES)
     
          tof.0           - 1
          tof.1           - ON|OFF
     
     TOFEOF
          Indicates if the <Top-of-File line> and the <Bottom-of-File line>
          are displayed.
          (QEMS)
     
          tofeof.0        - 1
          tofeof.1        - ON|OFF
     
     TRAILING
          Indicates how trailing blanks on lines are handled when the file
          is saved. Set by <SET TRAILING>
          (QEMS)
     
          trailing.0      - 1
          trailing.1      - ON|OFF|EMPTY|SINGLE
     
     TYPEAhead
          Indicates if THE will wait until all keyboard input has been
          processed before updating the screen display. Set by
          <SET TYPEAHEAD>.
          (QEMS)
     
          typeahead.0     - 1
          typeahead.1     - ON|OFF
     
     UNDOING
          Indicates if the undo facility is available or not.
          Set by <SET UNDOING>
          (QEMS)
     
          undoing.0       - 1
          undoing.1       - ON|OFF
     
     UNTAA
          Indicates if "unsigned numbers are absolute".
          Set by <SET UNTAA>
          (QEMS)
     
          untaa.0         - 1
          untaa.1         - ON|OFF
     
     Verify
          Returns verify column settings. Set by <SET VERIFY>.
          (QEMS)
     
          verify.0        - 1
          verify.1        - Column pair of verify start and end columns.
     
     VERShift
          Returns the value of the <vershift> internal variable.
          (QES)
     
          vershift.0      - 1
          vershift.1      - VERSHIFT value
     
     VERSION
          Returns information about name of application (THE) and version
          information.
          (QES)
     
          version.0       - 4
          version.1       - THE
          version.2       - version string eg. 1.5
          version.3       - platform version (DOS,OS2,UNIX,X11,WIN32)
          version.4       - version status information eg. release date, beta
     
     Width
          Returns maximum line width setting. Set by -w command line switch
          on starting THE.
          (QEMS)
     
          width.0         - 1
          width.1         - Maximum line width value.
     
     WORD
          Specifies how THE defines a word. Set by <SET WORD>.
          (QEMS)
     
          word.0          - 1
          word.1          - ALPHANUM|NONBLANK
     
     WORDWrap
          Indicates if WORDWRAP is on or off. Set by <SET WORDWRAP>.
          (QEMS)
     
          wordwrap.0      - 1
          wordwrap.1      - ON|OFF
     
     WRap
          Indicates if WRAP is on or off. Set by <SET WRAP>.
          (QEMS)
     
          wrap.0          - 1
          wrap.1          - ON|OFF
     
     XTERMinal
          Returns the current value of the X11 terminal program.
          Only applicable in X version. Set by <SET XTERMINAL>.
          (QEMS)
     
          xterminal.0     - 1
          xterminal.1     - X11 terminal program
     
     Zone
          Returns zone column settings. Set by <SET ZONE>.
          (QEMS)
     
          zone.0          - 2
          zone.1          - Zone start column
          zone.2          - Zone end column
     
     
     
     ========================================================================
     IMPLIED EXTRACT
     ========================================================================
     
          The above <REXX> variables set by the <EXTRACT> command may also
          be obtained by a REXX macro as an implied EXTRACT. Each variable
          above that may be set by an explicit EXTRACT command may also be
          eg. The REXX commands:
     
              'EXTRACT /SIZE/CURLINE/'
              Say size.1 curline.1
     
          may be substituted with:
     
              Say size.1() curline.1()
     
     
     ========================================================================
     BOOLEAN FUNCTIONS
     ========================================================================
     
          THE also provides other information to the REXX interpreter via
          boolean functions. These functions return either '1' or '0'
          depending on the information queried.
     
     after()
          Returns '1' if the cursor is currently after the last non-blank
          character on the line, or if the line is blank.
     
     altkey()
          Returns '1' if at the time the last key was pressed, the ALT
          key was also being held down.
     
     alt()
          Returns '1' if the file being edited has changed since the
          last SAVE. ie. if the value of alt.2 is non zero.
     
     blank()
          Returns '1' if the line the <cursor field> is completely blank.
     
     batch()
          Returns '1' if THE is being run in batch mode. ie THE was
          started with the -b switch.
     
     block()
          Returns '1' if the marked <block> is within the current view.
     
     before()
          Returns '1' if the cursor is currently before the first non-blank
          character on the line, or if the line is blank.
     
     bottomedge()
          Returns '1' if the cursor is on the bottom edge of the <filearea>
          or <prefix area>.
     
     command()
          Returns '1' if the <command line> is on. This is different to
          the definition in KEDIT; "Returns '1' if the cursor is on the
          command line." To get the equivalent KEDIT functionality
          use incommand();
     
     ctrl()
          Returns '1' if at the time the last key was pressed, the CTRL
          key was also being held down.
     
     current()
          Returns '1' if the cursor is on the <current line>.
     
     dir()
          Returns '1' if the current file is the special DIR.DIR file.
     
     end()
          Returns '1' if the cursor is on the last non-blank character on
          the line.
     
     eof()
          Returns '1' if the cursor is on the <Bottom-of-File line>
          and the cursor is not on the <command line>.
     
     first()
          Returns '1' if the cursor is in column 1 of the current window.
     
     focuseof()
          Returns '1' if the focus line is the <Bottom-of-File line>
          whether the cursor is on it or not.
     
     focustof()
          Returns '1' if the <focus line> is the <Top-of-File line>
          whether the cursor is on it or not.
     
     inblock()
          Returns '1' if the cursor is in the marked <block>.
     
     incommand()
          Returns '1' if the cursor is on the <command line>.
     
     initial()
          Returns '1' if the function is called from the <profile>.
     
     inprefix()
          Returns '1' if the cursor is located in the <prefix area>.
     
     leftedge()
          Returns '1' if the cursor is on the left edge of the <filearea>.
     
     modifiable()
          Returns '1' if the cursor is located in an area that can be changed.
          ie. not on <Top-of-File line> or <Bottom-of-File line> nor on a
          <shadow line>.
     
     rightedge()
          Returns '1' if the cursor is on the right edge of the <filearea>.
     
     shadow()
          Returns '1' if the cursor is on a <shadow line>.
     
     shift()
          Returns '1' if at the time the last key was pressed, the SHIFT
          key was also being held down.
     
     spacechar()
          Returns '1' if the cursor is on a space character.
     
     tof()
          Returns '1' if the cursor is on the <Top-of-File line>
          and the cursor is not on the <command line>.
     
     topedge()
          Returns '1' if the cursor is on the top edge of the <filearea>.
     
     verone()
          Returns '1' if the column 1 of the file is being displayed in
          column 1.
     
     ========================================================================
     OTHER FUNCTIONS
     ========================================================================
     
          The following functions provide features to simplify THE macros
          written in REXX.
     
     valid_target(target[,anything])
          The first argument is the <target> to be validated. If a second,
          optional argument is supplied, the target to be validated can
          consist of a target followed by any optional characters. This can
          be useful if the arguments to a macro consist of a target followed
          by another argument. If a valid target is supplied, the remainder
          of the string passed to valid_target() is returned following the
          first line affected and the number of lines to the target.
     
          Returns 'ERROR' if the supplied target is invalid.
          Returns 'NOTFOUND' if the supplied target is valid, but not found.
     
          If a valid target, returns the first line affected by the target
          followed by the number of lines to the target, and optionally the
          remainder of the argument. eg.
     
          if the focus line is 12 and valid_target() is called as
     
              result = valid_target(":7")      ===> result = "12 -5"
     
          if the focus line is 12 and valid_target is called as
     
              result = valid_target(":7 /fred/",junk), ===> result = "12 -5 /fred/"
     
     run_os(command[,stdin_stem[,stdout_stem[,stderr_stem]]])
          This function allows the macro writer to call an operating system
          command and have the standard streams; 'stdin', 'stdout' and 'stderr'
          redirected to or from REXX arrays.
     
          The first argument is the operating system command to execute.
          The command can include any command line switches appropriate
          to the command.
     
          All other arguments comprise a stem name (including a trailing '.')
          which refers to the REXX arrays where 'stdin', 'stdout' and 'stderr'
          are to be redirected.
     
          As with all REXX arrays, the value of the 0th element (stem.0)
          contains the number of elements in the array.
     
          The only restriction with the names of the stem variables is
          that the stem name for the 'stdin' stem cannot be the same as the
          stem for 'stdout' or 'stderr'.
     
          The stem name for 'stdout' and 'stderr' can be the same; the contents
          of the resulting output stems will consist of 'stdout' and 'stderr' in
          the order that the command generates this output.
     
          Return values:
     
               0    - successful
               1005 - invalid argument or syntax
               1012 - problems with system redirection of streams
               1094 - out of memory
               1099 - error interfacing to REXX interpreter
     
          all other numbers, return code from operating system command
     
          eg. to spell check the words "The Hessling Editr" with ispell
     
              in.0 = 3
              in.1 = "The"
              in.2 = "Hessling"
              in.3 = "Editr"
              rc = run_os("ispell -a","in.","out.")
     
          sets:
     
               out.0 --> 3
               out.1 --> "*"
               out.2 --> "#"
               out.3 --> "& edits edit editor"
     



     --------------------------------------------------------------------------
     
     
     ========================================================================
     APPENDIX 1 - ENVIRONMENT VARIABLES
     ========================================================================
     
     THE uses the following environment variables:
     
      THE_HOME_DIR - the directory in which THE looks for its help file(s) and macro(s)
     
      THE_HELP_FILE - the fully qualified file name containing help information.
     
      THE_PROFILE_FILE - the fully qualified file name for the default <profile> file.
     
      THE_MACRO_PATH - a list of all directories in which THE is to look for <macro> files.
     
     
     -----------------------------------
     Environment Variable Use under UNIX
     -----------------------------------
     
     If no environment variable; THE_HOME_DIR, is set prior to starting THE,
     THE uses /usr/local/THE/ as the default value for ${THE_HOME_DIR} if running
     under Unix.  This can be changed when running the configure script. See
     the file INSTALL for further details.  
     
     The default value of THE_HELP_FILE is THE_Help.txt. With no environment 
     variables set, the help file to be looked for will be /usr/local/THE/THE_Help.txt.
     If THE_HOME_DIR environment variable was set to /usr/opt/etc or changed in
     the.c, the help file will be /usr/opt/etc/THE_Help.txt.
     
     The name of the default profile file is $HOME/.therc.
     
     The default value of THE_MACRO_PATH is ${THE_HOME_DIR}:. THE will look for 
     a macro file first in ${THE_HOME_DIR} and then in the current directory. 
     So with no environment variables set, THE looks for macros in 
     $(THE_HOME_DIR} first and if no file exists in that directory, THE will 
     look in the current directory. If the file does not exist in either of 
     these places, an error message will be displayed.
     The format of THE_MACRO_PATH is dir1:dir2:dir3 Each directory is seperated 
     by colons. By default, up to 20 directories may be specified. This can be 
     changed in the.h when building or by the <SET MACROPATH> command.
     
     
     -----------------------------------------------------
     Environment Variable Use under OS/2, DOS and Win95/NT
     -----------------------------------------------------
     
                               *********
     
     Under some circumstances the following default behaviour does not occur.
     The reason is that THE.EXE sometimes cannot determine where it was run
     from.  This is a due to the different ways that different operating
     systems behave and how the C compiler used to build THE behaves.
     
     It is probably better to explicitly set the environment variables than
     hope that your particular environment will work as documented below.
     
                               *********
     
     By default THE_HOME_DIR is set to the directory from which THE was 
     invoked. Assuming THE.EXE resides in d:\tools, THE_HOME_DIR will equate 
     to d:\tools\.
     
     The default value of THE_HELP_FILE is THE_Help.txt.
     
     The name of the default profile file is ${THE_HOME_DIR}profile.the.
     
     The default value of THE_MACRO_PATH is ${THE_HOME_DIR};. THE will look for
     a macro file first in THE_HOME_DIR and then in the current directory. So 
     with no environment variables set, THE first looks for macros in the 
     directory from which THE was invoked and then in the current directory. 
     If the file does not exist in either directory, an error message is displayed.
     The format of THE_MACRO_PATH is dir1;dir2;dir3 Each directory is seperated
     by semi-colons. By default, up to 20 directories may be specified. This can
     be changed by the <SET MACROPATH> command.
     



     --------------------------------------------------------------------------
     
     
     ========================================================================
     APPENDIX 2 - KEYBOARD HANDLING IN THE
     ========================================================================
     
     This appendix contains information on how THE handles keystrokes in the
     U*ix environment.  One thing that is consistant with PCs is keyboard
     handling.  Therefore this explanation is not applicable to the PC
     arena.
     
     Keystroke handling is a very complicated business! There are so many
     layers between the physical keyboard and the application; in this case
     THE. These layers can be best described with the following diagrams:
     
               +------------------------------------------+
               | Text-mode Version of THE using terminal  |
               +------------------------------------------+
               |                                          |
               |            Physical Keyboard             |
               |                    |                     |
               |                    |                     |
               |           [terminal emulator]            |
               |                    |                     |
               |                    |                     |
               |             Termcap/Terminfo             |
               |                    |                     |
               |                    |                     |
               |                 Curses                   |
               |                    |                     |
               |                    |                     |
               |                   THE                    |
               |                                          |
               +------------------------------------------+
     
               +------------------------------------------+
               |   Text-mode Version of THE using xterm   |
               +------------------------------------------+
               |                                          |
               |            Physical Keyboard             |
               |                    |                     |
               |                    |                     |
               |               X11 server                 |
               |                [xmodmap]                 |
               |                    |                     |
               |                    |                     |
               |                  xterm                   |
               |              [translations]              |
               |                    |                     |
               |                    |                     |
               |             Termcap/Terminfo             |
               |                    |                     |
               |                    |                     |
               |                 Curses                   |
               |                    |                     |
               |                    |                     |
               |                   THE                    |
               |                                          |
               +------------------------------------------+
     
     
                        +-----------------------+
                        |  X11 Version of THE   |
                        +-----------------------+
                        |                       |
                        |  Physical Keyboard    |
                        |          |            |
                        |          |            |
                        |     X11 server        |
                        |      [xmodmap]        |
                        |          |            |
                        |          |            |
                        |       PDCurses        |
                        |    [translations]     |
                        |          |            |
                        |          |            |
                        |         THE           |
                        |                       |
                        +-----------------------+
     
     Each layer is described below
     
     -----------------
     Physical keyboard
     -----------------
     
     Each keyboard is potentially different from every other.  The similarity
     that they do posess is that when a key is pressed, a unique code is
     generated. The state of the Shift, Control, Num Lock, Alt modifiers
     either alter the unique code generated or a seperate code is generated
     to identify to the next layer that the key pressed should be modified.
     
     -----------------
     terminal emulator
     -----------------
     
     This is a required layer if the user is connected to the host via some
     emulation software. eg a PC connected to a U*ix host requires a terminal
     emulator of one sort or another.
     
     The terminal emulator translates the unique codes generated by the 
     keyboard usually into physical escape sequences that are passed to
     the U*ix shell.  These escape sequences can be seen by running the
     U*ix command 'cat -v'.  When you press a key on the keyboard while
     in 'cat -v', the escape sequences that the terminal emulator has
     generated are displayed. Some systems require the Enter key to be
     pressed before the escape sequence is displayed.  The term "escape
     sequence" is used because in most cases, the first character
     generated is an Escape character (hex 1B).  Following the escape
     is any number of other characters, which together form a unique
     sequence of characters.
     
     When using a terminal directly, firmware on the terminal does the
     generation of the escape sequences. Some terminals allow the user
     to specify what escape sequence will be generated when particular
     keys are pressed.
     
     ----------------
     Termcap/Terminfo
     ----------------
     
     Each terminal that connects to a U*ix host is identified by the value
     of the TERM environment variable.  The value of TERM is used to setup
     various settings for the terminal.  These settings are stored in a
     database; either in a flat file 'termcap' or in a compiled format
     'terminfo'. Which one a particular system uses is dependant on the
     version of the U*ix Operating System being run.
     
     One of the capabilites of the termcap/terminfo databases is to 
     translate an escape sequence into a keyboard mnemonic that is used
     by the Curses library functions.  This translation can also be
     changed by the user.
     
     An example of this is:
     
         +------------------------------
         Termcap:  ku=\E[A
         Terminfo: kcuu1=\E[A
         +------------------------------
     
     This translates the escape sequence ESC [ A into the mnemonic ku or
     kccu1.
     
     ------
     Curses
     ------
     
     The Curses library contains definitions of many keys.  These can be
     seen by looking in the Curses header file; usually /usr/include/curses.h
     Here you will see defintions like:
     
         +------------------------------
         #define KEY_UP 0403 /* up arrow key */
         +------------------------------
     
     ---
     THE
     ---
     
     As THE is a Curses-based application, it recognises the Curses key
     definitions defined in curses.h.  As not all escape sequences are
     usually defined in the Termcap/Terminfo databases, or are defined in
     curses.h, THE also has special code to decipher other escape sequences.
     
     When a key is pressed, and is interpreted by THE, the first action is
     to check if the value passed to THE is a 'known' curses key. If it is
     THE carries out any command associated with the key.  If the value
     is not a 'known' curses key, THE assumes that an escape sequence is
     forthcoming.  The module getch.c has code for deciphering many escape
     sequences that are not normally defined in the Termcap/Terminfo
     database.  Later in this document is a table of escape sequences and
     its associated curses key.
     
     ----------
     X11 Server
     ----------
     
     When THE is run in a X environemnt, the X server acts in a similar way
     to terminal emulation software.  The principal difference is that there
     are more layers within the X server.  The translation of physical
     keyboard codes to an X mnemonic is the first layer.  The code generated
     is called a keycode.  This keycode is then translated into another
     higher level mnemonic; a keysym.  The keysym is usually a name that
     resembles the label on the physical keyboard.
     
     The X environment provides a mechanism to assign keycodes to keysyms.
     This is done with the xmodmap command, and any assignment of keycode
     to keysym is done for all applications within the current X environemnt.
     
     -----
     xterm
     -----
     
     The xterm program is a terminal emulation program, and as such has many
     of the properties of the terminal emulator described above.
     The xterm program takes keysyms from the X11 server and generates
     escape sequences, which are defined in the xterm entry in the Termcap/
     Terminfo database.
     
     One of the features of xterm is the ability to alter the standard keysym to
     escape sequence translation.  Surprisingly this is via a feature called
     'translations'.  Not only do these translations enable the user to
     specify a different escape sequences to be generated, but internal
     xterm commands can also be assigned.  These are beyond the scope of
     this description. An example of an xterm translation follows:
     
         +------------------------------
         *VT100.Translations: #override\n\
          <Key>F1: string(0x1b) string("[192z")\n\
          <Key>F2: string(0x1b) string("[193z")\n
         +------------------------------
     
     This specification is typically part of your own $HOME/.Xdefaults file.
     This file is usually read dynamically by the xterm program on startup.
     On some systems, the .Xdefaults file is ignored.  To ensure the entries
     are incorporated into the X server resource database, run the command:
     
         +------------------------------
         xrdb -merge .Xdefaults
         +------------------------------
     
     The above example will generate the escape sequence ESC [ 1 9 2 z when
     the F1 key is pressed.  The trailing "\" is a continuation character.
     
     So, if you had the above translation in effect, and were running THE in 
     an xterm, and ran the SHOWKEY command, pressing the F1 key would result
     in THE responding with F11.
     
     --------
     PDCurses
     --------
     
     The actions performed by PDCurses in the X environment combine the
     xterm, Termcap/Terminfo and curses actions. This results in fewer 
     layers to be traversed.
     
     PDCurses takes a keysym from the X server and converts it into a
     Curses key code.  PDCurses also has the same translation capabilities
     as does xterm.  The xterm example above would look like:
     
         +------------------------------
         *the.Translations: #override\n\
          <Key>F1: string(0x1b) string("[192z")\n\
          <Key>F2: string(0x1b) string("[193z")\n
         +------------------------------
     
     All the details described in xterm as far as translations are concerned
     hold for translations in PDCurses.
     
     Another capability that translations offer is the ability to assign
     international characters to alphabetic characters, while still having
     the alphabetic characters available.  For example, the translations
     below assigns the action of the Shifted Meta key and A, giving a
     capital A with a grave accent, and the unshifted Meta key and A giving
     a small A with a grave accent.
     
         +------------------------------
         *the.Translations: #override\n\
          !Shift Meta <Key>a: string(0xc0) \n\
          !Meta       <Key>a: string(0xe0) \n
         +------------------------------
     
     The examples above assume you are using a font with a character set that
     is compatible with ISO 8859-1.
     
     ---------------------------------------
     THE Escape Sequence to Key Name Mapping
     ---------------------------------------
     
      +------------------+----------------+----------------+
      | Escape Sequence  |  Curses Key    |  THE Key Name  |
      +------------------+----------------+----------------+
      | (pre) 1 ~        | KEY_Find       | FIND           |
      | (pre) 2 ~        | KEY_InsertHere | INS            |
      | (pre) 3 ~        | KEY_Remove     | DEL            |
      | (pre) 4 ~        | KEY_Select     | SELECT         |
      | (pre) 5 ~        | KEY_PrevScreen | PGUP           |
      | (pre) 6 ~        | KEY_NextScreen | PGDN           |
      | (pre) 1 1 ~      | KEY_F(1)       | F1             |
      | (pre) 1 2 ~      | KEY_F(2)       | F2             |
      | (pre) 1 3 ~      | KEY_F(3)       | F3             |
      | (pre) 1 4 ~      | KEY_F(4)       | F4             |
      | (pre) 1 5 ~      | KEY_F(5)       | F5             |
      | (pre) 1 7 ~      | KEY_F(6)       | F6             |
      | (pre) 1 8 ~      | KEY_F(7)       | F7             |
      | (pre) 1 9 ~      | KEY_F(8)       | F8             |
      | (pre) 2 0 ~      | KEY_F(9)       | F9             |
      | (pre) 2 1 ~      | KEY_F(10)      | F10            |
      | (pre) 2 3 ~      | KEY_F(11)      | F11            |
      | (pre) 2 4 ~      | KEY_F(12)      | F12            |
      | (pre) 2 5 ~      | KEY_F(49)      | F13            |
      | (pre) 2 6 ~      | KEY_F(50)      | F14            |
      | (pre) 2 8 ~      | KEY_F(51)      | F15            |
      | (pre) 2 9 ~      | KEY_F(52)      | F16            |
      | (pre) 3 1 ~      | KEY_F(53)      | F17            |
      | (pre) 3 2 ~      | KEY_F(54)      | F18            |
      | (pre) 3 3 ~      | KEY_F(55)      | F19            |
      | (pre) 3 4 ~      | KEY_F(56)      | F20            |
      | (pre) 3 7 ~      | KEY_F(13)      | S-F1           |
      | (pre) 3 8 ~      | KEY_F(14)      | S-F2           |
      | (pre) 3 9 ~      | KEY_F(15)      | S-F3           |
      | (pre) 4 0 ~      | KEY_F(16)      | S-F4           |
      | (pre) 4 1 ~      | KEY_F(17)      | S-F5           |
      | (pre) 4 2 ~      | KEY_F(18)      | S-F6           |
      | (pre) 4 3 ~      | KEY_F(19)      | S-F7           |
      | (pre) 4 4 ~      | KEY_F(20)      | S-F8           |
      | (pre) 4 5 ~      | KEY_F(21)      | S-F9           |
      | (pre) 4 6 ~      | KEY_F(22)      | S-F10          |
      | (pre) 4 7 ~      | KEY_F(23)      | S-F11          |
      | (pre) 4 8 ~      | KEY_F(24)      | S-F12          |
      | (pre) 4 9 ~      | KEY_F(25)      | C-F1           |
      | (pre) 5 0 ~      | KEY_F(26)      | C-F2           |
      | (pre) 5 1 ~      | KEY_F(27)      | C-F3           |
      | (pre) 5 2 ~      | KEY_F(28)      | C-F4           |
      | (pre) 5 3 ~      | KEY_F(29)      | C-F5           |
      | (pre) 5 4 ~      | KEY_F(30)      | C-F6           |
      | (pre) 5 5 ~      | KEY_F(31)      | C-F7           |
      | (pre) 5 6 ~      | KEY_F(32)      | C-F8           |
      | (pre) 5 7 ~      | KEY_F(33)      | C-F9           |
      | (pre) 5 8 ~      | KEY_F(34)      | C-F10          |
      | (pre) 5 9 ~      | KEY_F(35)      | C-F11          |
      | (pre) 6 0 ~      | KEY_F(36)      | C-F12          |
      | (pre) A          | KEY_UP         | CURU           |
      | (pre) B          | KEY_DOWN       | CURD           |
      | (pre) C          | KEY_RIGHT      | CURR           |
      | (pre) D          | KEY_LEFT       | CURL           |
      | (pre) F          | KEY_END        | END            |
      | (pre) G          | KEY_NextScreen | PGDN           |
      | (pre) H          | KEY_HOME       | HOME           |
      | (pre) I          | KEY_PrevScreen | PGUP           |
      | (pre) L          | KEY_InsertHere | INS            |
      | (pre) M          | KEY_NUMENTER   | NUMENTER       |
      | (pre) N          | KEY_F(2)       | F2             |
      | (pre) O          | KEY_F(3)       | F3             |
      | (pre) P          | KEY_PF1        | PF1            |
      | (pre) Q          | KEY_PF2        | PF2            |
      | (pre) R          | KEY_PF3        | PF3            |
      | (pre) S          | KEY_PF4        | PF4            |
      | (pre) T          | KEY_F(8)       | F8             |
      | (pre) U          | KEY_F(9)       | F9             |
      | (pre) V          | KEY_F(10)      | F10            |
      | (pre) W          | KEY_F(11)      | F11            |
      | (pre) X          | KEY_F(12)      | F12            |
      | (pre) Z          | KEY_BACKTAB    | S-TAB          |
      | (pre) l          | KEY_PadComma   | COMMA          |
      | (pre) m          | KEY_PadMinus   | MINUS          |
      | (pre) n          | KEY_PadPeriod  | NUMSTOP        |
      | (pre) o          | KEY_Pad0       | NUM0           |
      | (pre) p          | KEY_Pad1       | NUM1           |
      | (pre) q          | KEY_Pad2       | NUM2           |
      | (pre) r          | KEY_Pad3       | NUM3           |
      | (pre) s          | KEY_Pad4       | NUM4           |
      | (pre) t          | KEY_Pad5       | CENTER         |
      | (pre) u          | KEY_Pad6       | NUM6           |
      | (pre) v          | KEY_Pad7       | NUM7           |
      | (pre) w          | KEY_Pad8       | NUM8           |
      | (pre) x          | KEY_Pad9       | NUM9           |
      | (pre) y          | KEY_NUMENTER   | NUMENTER       |
      | (pre) 1 z        | KEY_BTAB       | S-TAB          |
      | (pre) 2 z        | KEY_InsertHere | INS            |
      | (pre) 3 z        | KEY_HOME       | HOME           |
      | (pre) 4 z        | KEY_END        | END            |
      | (pre) 5 z        | KEY_PrevScreen | PGUP           |
      | (pre) 6 z        | KEY_NextScreen | PGDN           |
      | (pre) 1 9 5 z    | KEY_UNDO       | UNDO           |
      | (pre) 2 1 4 z    | KEY_HOME       | HOME           |
      | (pre) 2 1 5 z    | KEY_UP         | CURU           |
      | (pre) 2 1 6 z    | KEY_PrevScreen | PGUP           |
      | (pre) 2 1 7 z    | KEY_LEFT       | CURL           |
      | (pre) 2 1 9 z    | KEY_RIGHT      | CURR           |
      | (pre) 2 2 0 z    | KEY_END        | END            |
      | (pre) 2 2 1 z    | KEY_DOWN       | CURD           |
      | (pre) 2 2 2 z    | KEY_NextScreen | PGDN           |
      | (pre) 2 2 4 z    | KEY_F(1)       | F1             |
      | (pre) 2 2 5 z    | KEY_F(2)       | F2             |
      | (pre) 2 2 6 z    | KEY_F(3)       | F3             |
      | (pre) 2 2 7 z    | KEY_F(4)       | F4             |
      | (pre) 2 2 8 z    | KEY_F(5)       | F5             |
      | (pre) 2 2 9 z    | KEY_F(6)       | F6             |
      | (pre) 2 3 0 z    | KEY_F(7)       | F7             |
      | (pre) 2 3 1 z    | KEY_F(8)       | F8             |
      | (pre) 2 3 2 z    | KEY_F(9)       | F9             |
      | (pre) 2 3 3 z    | KEY_F(10)      | F10            |
      | (pre) 2 3 4 z    | KEY_F(11)      | F11            |
      | (pre) 2 3 5 z    | KEY_F(12)      | F12            |
      | (pre) 3 2 4 z    | KEY_F(13)      | S-F1           |
      | (pre) 3 2 5 z    | KEY_F(14)      | S-F2           |
      | (pre) 3 2 6 z    | KEY_F(15)      | S-F3           |
      | (pre) 3 2 7 z    | KEY_F(16)      | S-F4           |
      | (pre) 3 2 8 z    | KEY_F(17)      | S-F5           |
      | (pre) 3 2 9 z    | KEY_F(18)      | S-F6           |
      | (pre) 3 3 0 z    | KEY_F(19)      | S-F7           |
      | (pre) 3 3 1 z    | KEY_F(20)      | S-F8           |
      | (pre) 3 3 2 z    | KEY_F(21)      | S-F9           |
      | (pre) 3 3 3 z    | KEY_F(22)      | S-F10          |
      | (pre) 3 3 4 z    | KEY_F(23)      | S-F11          |
      | (pre) 3 3 5 z    | KEY_F(24)      | S-F12          |
      | (pre) 4 1 4 z    | KEY_C_HOME     | C-HOME         |
      | (pre) 4 1 5 z    | KEY_C_CURU     | C-CURU         |
      | (pre) 4 1 6 z    | KEY_C_PGUP     | C-PGUP         |
      | (pre) 4 1 7 z    | KEY_C_CURL     | C-CURL         |
      | (pre) 4 1 9 z    | KEY_C_CURR     | C-CURR         |
      | (pre) 4 2 0 z    | KEY_C_END      | C-END          |
      | (pre) 4 2 1 z    | KEY_C_CURD     | C-CURD         |
      | (pre) 4 2 2 z    | KEY_C_PGDN     | C-PGDN         |
      | (pre) 4 2 3 z    | KEY_PadComma   | COMMA          |
      | (pre) 4 2 4 z    | KEY_F(25)      | C-F1           |
      | (pre) 4 2 5 z    | KEY_F(26)      | C-F2           |
      | (pre) 4 2 6 z    | KEY_F(27)      | C-F3           |
      | (pre) 4 2 7 z    | KEY_F(28)      | C-F4           |
      | (pre) 4 2 8 z    | KEY_F(29)      | C-F5           |
      | (pre) 4 2 9 z    | KEY_F(30)      | C-F6           |
      | (pre) 4 3 0 z    | KEY_F(31)      | C-F7           |
      | (pre) 4 3 1 z    | KEY_F(32)      | C-F8           |
      | (pre) 4 3 2 z    | KEY_F(33)      | C-F9           |
      | (pre) 4 3 3 z    | KEY_F(34)      | C-F10          |
      | (pre) 4 3 4 z    | KEY_F(35)      | C-F11          |
      | (pre) 4 3 5 z    | KEY_F(36)      | C-F12          |
      | (pre) 1 9 2 z    | KEY_F(49)      | F13            |
      | (pre) 1 9 3 z    | KEY_F(50)      | F14            |
      | (pre) 2 9 2 z    | KEY_F(57)      | S-F13          |
      | (pre) 2 9 3 z    | KEY_F(58)      | S-F14          |
      | (pre) [ A        | KEY_F(1)       | F1             |
      | (pre) [ B        | KEY_F(2)       | F2             |
      | (pre) [ C        | KEY_F(3)       | F3             |
      | (pre) [ D        | KEY_F(4)       | F4             |
      | (pre) [ E        | KEY_F(5)       | F5             |
      | (pre) 0 q        | KEY_PadComma   | COMMA          |
      | (pre) 1 q        | KEY_F(1)       | F1             |
      | (pre) 2 q        | KEY_F(2)       | F2             |
      | (pre) 3 q        | KEY_F(3)       | F3             |
      | (pre) 4 q        | KEY_F(4)       | F4             |
      | (pre) 5 q        | KEY_F(5)       | F5             |
      | (pre) 6 q        | KEY_F(6)       | F6             |
      | (pre) 7 q        | KEY_F(7)       | F7             |
      | (pre) 8 q        | KEY_F(8)       | F8             |
      | (pre) 9 q        | KEY_F(9)       | F9             |
      | (pre) 1 0 q      | KEY_F(10)      | F10            |
      | (pre) 1 1 q      | KEY_F(11)      | F11            |
      | (pre) 1 2 q      | KEY_F(12)      | F12            |
      | (pre) 1 3 q      | KEY_F(13)      | S-F1           |
      | (pre) 1 4 q      | KEY_F(14)      | S-F2           |
      | (pre) 1 5 q      | KEY_F(15)      | S-F3           |
      | (pre) 1 6 q      | KEY_F(16)      | S-F4           |
      | (pre) 1 7 q      | KEY_F(17)      | S-F5           |
      | (pre) 1 8 q      | KEY_F(18)      | S-F6           |
      | (pre) 1 9 q      | KEY_F(19)      | S-F7           |
      | (pre) 2 0 q      | KEY_F(20)      | S-F8           |
      | (pre) 2 1 q      | KEY_F(21)      | S-F9           |
      | (pre) 2 2 q      | KEY_F(22)      | S-F10          |
      | (pre) 2 3 q      | KEY_F(23)      | S-F11          |
      | (pre) 2 4 q      | KEY_F(24)      | S-F12          |
      | (pre) 2 5 q      | KEY_F(25)      | C-F1           |
      | (pre) 2 6 q      | KEY_F(26)      | C-F2           |
      | (pre) 2 7 q      | KEY_F(27)      | C-F3           |
      | (pre) 2 8 q      | KEY_F(28)      | C-F4           |
      | (pre) 2 9 q      | KEY_F(29)      | C-F5           |
      | (pre) 3 0 q      | KEY_F(30)      | C-F6           |
      | (pre) 3 1 q      | KEY_F(31)      | C-F7           |
      | (pre) 3 2 q      | KEY_F(32)      | C-F8           |
      | (pre) 3 3 q      | KEY_F(33)      | C-F9           |
      | (pre) 3 4 q      | KEY_F(34)      | C-F10          |
      | (pre) 3 5 q      | KEY_F(35)      | C-F11          |
      | (pre) 3 6 q      | KEY_F(36)      | C-F12          |
      | (pre) 1 3 9 q    | KEY_InsertHere | INS            |
      | (pre) 1 5 0 q    | KEY_PrevScreen | PGUP           |
      | (pre) 1 4 6 q    | KEY_END        | END            |
      | (pre) 1 5 4 q    | KEY_NextScreen | PGUP           |
      | ESC P            | KEY_PF1        | PF1            |
      | ESC Q            | KEY_PF2        | PF2            |
      | ESC R            | KEY_PF3        | PF3            |
      | ESC S            | KEY_PF4        | PF4            |
      +------------------+----------------+----------------+
     
      Where (pre) is either:
     
         +------------------------------
         ESC [ - (0x1B 0x5B) or
         ESC O - (0x1B 0x4F) or
         ESC ? - (0x1B 0x3F) or
         CSI   - (0x9B)
         +------------------------------
     



     --------------------------------------------------------------------------
     
     
     ========================================================================
     APPENDIX 3 - POINTER DEVICE SUPPORT IN THE
     ========================================================================
     
     This appendix describes the default behaviour of supported pointer devices
     when running THE; usually a mouse.
     
     ------
     SYNTAX:
     ------
     
     Mouse "keys" have the following syntax:
     
      +--------------------+----------------------------------------------+
      | [a-]bcB IN window  |  Description                                 |
      +--------------------+----------------------------------------------+
      | [a-]               |is a keyboard modifier, the same as keyboard  |
      |                    |keys.  The 'a' can be one of S,C or A for     |
      |                    |SHIFT, CONTROL and ALT respectively. The '-'  |
      |                    |is mandatory.                                 |
      | b                  |is the mouse action.  This can be one of P, R,|
      |                    |C, 2, D or S for PRESS, RELEASE, CLICK,       |
      |                    |DOUBLE_CLICK, DRAG and SCROLL respectively.   |
      | c                  |is the mouse button. This can be one of L, R  |
      |                    |M, U or D for LEFT, RIGHT, MIDDLE, UP or DOWN |
      |                    | respectively.                                |
      | d                  |B for BUTTON, W for WHEEL                     |
      | IN                 |mandatory keyword                             |
      | window             |the area of the screen in which the mouse     |
      |                    |event is to take place.  The valid values     |
      |                    |for this are:                                 |
      |                    |Filearea, Cmdline, Idline, Arrow, PRefix,     |
      |                    |STatarea, Divider and * (for all)             |
      +--------------------+----------------------------------------------+
     
     
     --------
     EXAMPLES:
     --------
     
      +--------------------+------------------------------------+
      |   Mouse Event      |  Description                       |
      +--------------------+------------------------------------+
      | S-PLB IN PR        | Left mouse button is pressed,      |
      |                    | while holding down the SHIFT key,  |
      |                    | and the mouse positioned in the    |
      |                    | prefix area.                       |
      |   2RB IN I         | Right mouse button double-clicked  |
      |                    | in idline.                         |
      |   SUW IN *         | Scroll Up Wheel in all windows.    |
      +--------------------+------------------------------------+
     
     
     --------
     DEFAULTS:
     --------
     
      +------------------------+------------------------------------+
      | Mouse Event (Win32)    |  Command(s)                        |
      +------------------------+------------------------------------+
      |   2LB in FILEAREA      | cursor MOUSE#sos EDIT              |
      |   2LB in PREFIX        | cursor MOUSE#sos EDIT              |
      |   PRB in FILEAREA      | cursor MOUSE#sos MAKECURR          |
      |   PRB in PREFIX        | cursor MOUSE#sos MAKECURR          |
      |   RLB in CMDLINE       | cursor MOUSE                       |
      |   RLB in DIVIDER       | screen 1                           |
      |   RLB in FILEAREA      | cursor MOUSE                       |
      |   RLB in FILETABS      | tabfile                            |
      |   RLB in IDLINE        | xedit                              |
      |   RLB in PREFIX        | cursor MOUSE                       |
      |   RLB in STATAREA      | status                             |
      |   RRB in IDLINE        | xedit -                            |
      | A-PLB in FILEAREA      | backward                           |
      | A-PRB in FILEAREA      | forward                            |
      | C-DLB in FILEAREA      | cursor MOUSE#mark BOX              |
      | C-PLB in FILEAREA      | cursor MOUSE#reset BLOCK#mark BOX  |
      | C-PRB in FILEAREA      | cursor MOUSE#mark BOX              |
      | S-DLB in FILEAREA      | cursor MOUSE#mark LINE             |
      | S-PLB in FILEAREA      | cursor MOUSE#reset BLOCK#mark LINE |
      | S-PRB in FILEAREA      | cursor MOUSE#mark LINE             |
      |   SUW in *             | up 5                               |
      |   SDW in *             | down 5                             |
      +------------------------+------------------------------------+
     
      +------------------------+------------------------------------+
      | Mouse Event (X11)      |  Command(s)                        |
      +------------------------+------------------------------------+
      |   2LB in FILEAREA      | cursor MOUSE#sos EDIT              |
      |   2LB in PREFIX        | cursor MOUSE#sos EDIT              |
      |   PLB in CMDLINE       | cursor MOUSE                       |
      |   PLB in DIVIDER       | screen 1                           |
      |   PLB in FILEAREA      | cursor MOUSE                       |
      |   PLB in IDLINE        | xedit                              |
      |   PLB in PREFIX        | cursor MOUSE                       |
      |   PLB in STATAREA      | status                             |
      |   PRB in FILEAREA      | cursor MOUSE#sos MAKECURR          |
      |   PRB in IDLINE        | xedit -                            |
      |   PRB in PREFIX        | cursor MOUSE#sos MAKECURR          |
      | C-DLB in FILEAREA      | cursor MOUSE#mark BOX              |
      | C-PLB in FILEAREA      | cursor MOUSE#reset BLOCK#mark BOX  |
      | C-PRB in FILEAREA      | cursor MOUSE#mark BOX              |
      | S-DLB in FILEAREA      | cursor MOUSE#mark LINE             |
      | S-PLB in FILEAREA      | cursor MOUSE#reset BLOCK#mark LINE |
      | S-PRB in FILEAREA      | cursor MOUSE#mark LINE             |
      +------------------------+------------------------------------+
     
      +------------------------+------------------------------------+
      | Mouse Event (ncurses)  |  Command(s)                        |
      +------------------------+------------------------------------+
      |   2LB in FILEAREA      | cursor MOUSE#sos EDIT              |
      |   2LB in PREFIX        | cursor MOUSE#sos EDIT              |
      |   CLB in CMDLINE       | cursor MOUSE                       |
      |   CLB in DIVIDER       | screen 1                           |
      |   CLB in FILEAREA      | cursor MOUSE                       |
      |   CLB in IDLINE        | xedit                              |
      |   CLB in PREFIX        | cursor MOUSE                       |
      |   CLB in STATAREA      | status                             |
      |   CRB in FILEAREA      | cursor MOUSE#sos MAKECURR          |
      |   CRB in IDLINE        | xedit -                            |
      |   CRB in PREFIX        | cursor MOUSE#sos MAKECURR          |
      +------------------------+------------------------------------+
     
     
     -----
     NOTES:
     -----
     
     1.  In the X11 port, pressing the middle mouse button anywhere within the
         THE window, will result in the contents of the X selection being pasted
         where the text cursor is currently displayed.  If you hold down
         any modifier key, such as SHIFT or CONTROL, that sequence is
         passed to THE and can be mapped. Therefore; PMB or RMD is NOT
         able to be used in THE, but C-PMB, C-RMB, S-PMB etc. can.
     
     2.  The button action DOUBLE_CLICKED will always be preceded by a CLICK
         action. This is the case for THE with ncurses or PDCurses. Therefore
         itis usually a good idea to have the CLICK action assigned to a
         cursor positioning command if the DOUBLE_CLICK for the same button is
         used.
     



     --------------------------------------------------------------------------
     
     
     ========================================================================
     APPENDIX 4 - SYNTAX HIGHLIGHTING IN THE
     ========================================================================
     
     This appendix contains details on syntax highlighting in THE.  Syntax
     highlighting is the mechanism by which different tokens within a file;
     usually containing source code, are displayed in different colours.
     
     The model THE uses for its syntax highlighting is based on the model
     used by KEDIT for Windows from Mansfield Software.  This model is extremely
     configurable and flexible. While most of the KEDIT features are implemented,
     THE also adds a couple of other features that make the syntax highlighting
     even better.
     
     This appendix concentrates on the format of THE language definition
     files. For a description of the commands that manipulate other aspects
     of syntax highlighting in THE, see the descriptions of the following
     commands:
     <SET AUTOCOLOR>, <SET COLORING>, <SET ECOLOR>, <SET PARSER>.
     
     ------------------
     Performance Impact
     ------------------
     
     Syntax highlighting in an editor comes at a cost; reduced performance.
     
     Because of the extra processing required to determine which characters are
     displayed in which colours, displaying the screen is slower.  As THE 
     recalculates the display colours after every displayable key is pressed,
     then you may notice a reduction in responsiveness.
     
     The more features that are specified in a TLD, the slower the syntax
     highlighting will be. To dynamically turn on or off the application of
     some headers within a TLD file, see the <SET HEADER> command.
     
     For those languages that allow paired comments (ie they can span multiple
     lines) performance is impacted even more.  This is because THE has to
     determine if the lines being displayed are within one of these multi-line
     comment pairs which may start before the first displayed line.
     
     THE will incorrectly display syntax highlighting in certain circumstances.
     This is because THE does not fully parse the complete file to determine
     the correct colours; that would be too slow.  Instead, THE checks the
     currently displayed lines and determines the syntax highlighting based
     on these lines.
     
     Where THE will get syntax highlighting wrong:
     
     If all displayed lines are within a multi-line comment block and neither
     the starting comment token nor the ending comment token are displayed. THE
     will treat the displayed lines as code.
     
     When the starting or ending comment tokens for multi-line comments are 
     part of a language string. 
     
     Also bear in mind that excluding large portions of the file with ALL, will
     dramatically slow down checking of multi-line comments.
     
     --------------------------------
     File Extensions Vs Magic Numbers
     --------------------------------
     A THE extension to the KEDIT syntax highlighting model is support for 
     <magic numbers>. (See <SET AUTOCOLOR> for more details).  For the default 
     <parser>s, where there might be a conflict between setting syntax highlighting
     based on a file extension or a <magic number>, the file extension mapping takes
     precedence.
     
     -----------------------------
     THE Language Definition Files
     -----------------------------
     
     THE Language Definition Files usually have a file extension of .tld.
     THE comes with a small number of sample TLD files. Look at these files in
     conjunction with the following descriptions to fully understand how to
     write your own TLD files.
     
     TLD files consist of several sections identified by header lines. Header
     lines start with a colon in column one.  Items within the particular header
     are listed on separate lines after the header to which they apply.
     Blank lines are ignored, and so are comments (* as first non-blank). Each
     item that can be repeated occurs on a separate line. The above definition 
     of what a TLD file looks like is expressed in the TLD file; tld.tld.
     
     Many items in a TLD are specified as a regular expression (RE).  THE supports a
     number of RE syntaxes for targets. All REs specified in a TLD are parsed using
     the EMACS syntax.  For details of RE usage in THE see Appendix 7.
     
     The purpose of each header and the valid contents are explained below.
     
     ...........
     :identifier
     ...........
     This section specifies, using a regular expression how a keyword in the
     language is defined.  The only item line contains three regular expressions
     separated by space characters.
     Syntax:
        first_char_re other_char_re [last_char_re]
     Meaning of options:
        first_char_re
           This regular expression specifies the valid characters that an
           identifier can begin with.
        other_char_re
           This regular expression specifies the valid characters that the
           remainder of characters in an identifier can consist of.
        last_char_re
           This regular expression is optional. If specified, it states the
           valid characters that an identifier can end with.
     
     .....
     :case
     .....
     This section defines whether the case of letters that make up identifiers in
     the language are case-sensitive or not. Only one of the items below can be 
     included.
     Syntax:
        RESPECT | IGNORE
     Meaning of options:
        respect 
           case is relevant. The keywords 'if', 'IF' and 'If' are different.
        ignore
           case is irrelevant. The keywords 'if' and 'IF' are treated as the
           same identifier.
     
     .......
     :option
     .......
     This section specifies different options that can affect other sections.
     The options below can all be included in the one TLD.
     Syntax:
        REXX
        PREPROCESSOR char
        FUNCTION char BLANK | NOBLANK [DEFAULT ALTernate x]
     Meaning of options:
        rexx 
           specifies special processing for Rexx. eg. Functions defined in
           the :functions section, are also highlighted if preceeded by CALL.
        preprocessor char 
           languages like C that have preprocessor identifiers usually begin 
           with a special character (specified by 'char') to differentiate 
           these types of keywords from others.
        function char blank | noblank [default alternate x]
           this option is used to identify how keywords specified in the
           :function section are identified. 'char' specifies the character that
           is used to start a function, usually '('. The 'blank' or 'noblank' 
           argument determines if blank characters can appear between the function
           identifier and the function start character. eg a Rexx function
           call must be written without blanks between the function name and
           the function start character: 'word('. In C 'word  (' or 'word(' 
           are both valid syntax for a function call.
           The optional "default alternate x" specifies the color in which 
           functions that are NOT specified in the :function section are to
           be displayed. See the explanation of alternate colors in the :function
           section.
           Without "default alternate x", the color of unknown functions is
           not changed.
     
     .......
     :number
     .......
     This section specifies the format of numbers in the language. Most languages
     use a small number of generic types of numbers.
     Syntax:
        REXX | C | COBOL
     Meaning of options:
     ECOLOR Value:
           Numbers are displayed in the colour specified with ECOLOUR 'C'.
     
     .......
     :string
     .......
     This section specifies how strings within the language are defined.
     Multiple values may be specified, as many languages use both single and
     double quotes.
     Syntax:
        SINGLE [BACKSLASH] | DOUBLE [BACKSLASH]
     Meaning of options:
        single
           Specifies that the language uses single quotes to identify a string.
        double
           Specifies that the language uses double quotes to identify a string.
        backslash
           Some languages require a backslash character immediately preceding
           either a single or double quote to allow the quote to be included
           in the string.
     ECOLOR Character:
           For complete strings, the ECOLOUR character used is 'B'. For incomplete
           strings, the ECOLOUR character used is 'S'.
     
     ........
     :comment
     ........
     This section specifies the format of comments. Both paired and line
     comments can be specified, as can multiple occurrences of each.
     Syntax:
        PAIRED open_string close_string [NEST | NONEST]
        LINE comment_string ANY | FIRSTNONBLANK | COLUMN n
     Meaning of options:
        paired
           These types of comments can span multiple lines. They have an opening
           string and a closing string.
        open_string
           This defines the string that opens a paired comment.
        close_string
           This defines the string that closes a paired comment.
        nest
           Some languages allow paired comments to be nested. (not implemented)
        nonest
           Defining this indicates that the language does not allow nesting
           of paired comments. The effect of this option will result in the 
           first close_string to end the paired comment no matter how many 
           open_string occurrences there are. (not implemented)
        line
           These type of comments cannot span multiple lines.  Everything on the
           line after the comment_string is considered part of the comment.
        comment_string
           The string that defines a line comment.
        any
           For line comments, this indicates that the comment_string can occur
           anywhere on the line, and all characters following it are part of
           the comment.
        firstnonblank
           For line comments, this indicates that the comment_string can only
           occur as the first non-blank of the line.
        column n
           For line comments, this indicates that the comment_string must
           start in the specified column.
     ECOLOR Character:
           Comments are displayed in the colour specified with ECOLOUR 'A'.
     
     ........
     :keyword
     ........
     This section specifies all of the identifiers that are to be considered
     language keywords. You must specific the :identifier section in the TLD 
     file before the :keyword section.
     Syntax:
        keyword [ALTernate x] [TYPE x]
     Meaning of options:
        keyword
           This specifies the string that is considered to be a language
           keyword.
        alternate x
           All keywords are displayed in the same colour, unless you use
           this option to specify a different colour.  In KEDIT there are 
           9 alternate colours that can be used; ECOLOUR 1 through 9. In THE
           any ECOLOUR character can be used as an alternate colour.
           'alternate' can be abbreviated to 'alt'.
        type x
           (not implemented)
     ECOLOR Character:
           Unless overridden by the 'alternate' option, the keyword is displayed 
           in the colour specified with ECOLOUR 'D'.
     
     .........
     :function
     .........
     This section specifies all of the identifiers that are to be considered
     functions.  Normally this is used for those functions that are builtin
     into the language, but can be any identifier. You specify the function
     identifier without the function char specified in the :option section.
     You must specify the :option and the :identifier sections in the TLD 
     file before the :function section.
     Syntax:
        function [ALTernate x]
     Meaning of options:
        function
           This specifies the string that is considered to be a language
           function.
        alternate x
           All functions are displayed in the same colour, unless you use
           this option to specify a different colour.  In KEDIT there are 
           9 alternate colours that can be used; ECOLOUR 1 through 9. In THE
           any ECOLOUR character can be used as an alternate colour.
           'alternate' can be abbreviated to 'alt'.
     ECOLOR Character:
           Unless overridden by the 'alternate' option, the function is displayed
           in the colour specified with ECOLOUR 'V'.
     
     .......
     :header
     .......
     This section specifies the format of headers. Headers are lines within a file
     that begin with a particular string and usually identify different parts of
     the file. They are similar to labels.
     Syntax:
        LINE header_string ANY | FIRSTNONBLANK | COLUMN n
     Meaning of options:
        header_string
           The string that defines a header.
        any
           This indicates that the header_string can occur anywhere on the line, 
           and all characters following it are part of the header.
        firstnonblank
           This indicates that the header_string can only occur as the first 
           non-blank of the line.
        column n
           This indicates that the header_string must start in the specified column.
     ECOLOR Character:
           Headers are displayed in the colour specified with ECOLOUR 'G'.
     
     ......
     :label
     ......
     This section specifies the format of labels. Labels are lines within a file
     that end with a particular string. They are similar to headers.
     Syntax:
        DELIMITER label_string ANY | FIRSTNONBLANK | COLUMN n
        COLUMN n
     Meaning of options:
        label_string
           The string that defines a label.
        any
           This indicates that the label_string can occur anywhere on the line, 
           and all characters up to it are part of the label.
        firstnonblank
           This indicates that the label_string can only occur as the first 
           non-blank of the line.
        column n
           As part of a DELIMITER label, this indicates that the label_string 
           must start in the specified column. If specified by itself, then the
           label does not require any special delimiter; the non-keyword that 
           starts in the specified column is regarded as a label.
     ECOLOR Character:
           Labels are displayed in the colour specified with ECOLOUR 'E'.
     
     .......
     :markup
     .......
     This section specifies the delimiters for a markup tag, and optionally
     the delimiters for references within a markup language.
     Syntax:
        TAG tag_start tag_end [REFERENCE ref_start ref_end]
     Meaning of options:
        tag_start
           The character that specifies the start of a markup tag.
        tag_end
           The character that specifies the end of a markup tag.
        ref_start
           The character that specifies the start of a markup reference.
        ref_end
           The character that specifies the end of a markup reference.
     ECOLOR Character:
           Tags are displayed in the colour specified with ECOLOUR 'T'.
           References are displayed in the colour spceified with ECOLOUR 'U'.
     
     ......
     :match
     ......
     (Not implemented yet)
     
     .......
     :column
     .......
     This section specifies the range of columns in your file which is to have
     syntax highlighting applied.  For example, columns 1-6 and beyond column
     72 in a COBOL source file should be excluded from being parsed.
     Any number of EXCLUDE clauses are allowed.
     Note. Not all syntax checking respects excluded columns at this stage.
     Syntax:
        EXCLUDE first_column last_column [ALTernate x]
     Meaning of options:
        first_column
           The first column to be excluded
        last_column
           The last column to be excluded. '*' can be used to specify to the end of
           the line.
        alternate x
           All excluded characters are displayed in the same colour, unless you use
           this option to specify a different colour.  In KEDIT there are 
           9 alternate colours that can be used; ECOLOUR 1 through 9. In THE
           any ECOLOUR character can be used as an alternate colour.
           'alternate' can be abbreviated to 'alt'.
     ECOLOR Character:
           Unless overridden by the 'alternate' option, the excluded characters
           are displayed in the colour specified with COLOUR FILEAREA.
     
     ............
     :postcompare
     ............
     This section specifies items that are checked for after all other syntax
     checking has been completed.  This can be useful if you want to allow 
     user-defined datatypes or other code to be displayed in different colours.
     Syntax:
        CLASS re [ALTernate x]
        TEXT string [ALTernate x]
     Meaning of options:
        re
           This regular expression specifies the text to be highlighted.
        string
           This indicates the literal string to be highlighted.
        alternate x
           All matched postcompare characters are displayed in the same colour, 
           unless you use this option to specify a different colour.  In KEDIT 
           there are 9 alternate colours that can be used; ECOLOUR 1 through 9. 
           In THE any ECOLOUR character can be used as an alternate colour.
           'alternate' can be abbreviated to 'alt'.
     ECOLOR Character:
           Unless overridden by the 'alternate' option, the matched characters
           are displayed in the colour specified with ECOLOUR 'D'.
     
     ---------------
     Builtin Parsers
     ---------------
     THE includes a number of builtin syntax highlighting <parser>s.
     The following table lists the default <parser>s and the files they apply to:
     
      +--------+-----------+----------------+
      | Parser | Filemasks | "Magic Number" |
      +--------+-----------+----------------+
      | REXX   | *.rex     | rexx           |
      |        | *.rexx    | regina         |
      |        | *.cmd     | rxx            |
      |        | *.the     |                |
      |        | .therc    |                |
      +--------+-----------+----------------+
      | C      | *.c       |                |
      |        | *.h       |                |
      |        | *.cc      |                |
      |        | *.hpp     |                |
      |        | *.cpp     |                |
      +--------+-----------+----------------+
      | SH     |           | sh             |
      |        |           | ksh            |
      |        |           | bash           |
      |        |           | zsh            |
      +--------+-----------+----------------+
      | TLD    | *.tld     |                |
      +--------+-----------+----------------+
      | HTML   | *.html    |                |
      |        | *.htm     |                |
      +--------+-----------+----------------+
     
     A Rexx macro is provided; tld2c.rex, to convert a .tld file into the C code
     that can be embedded in default.c. This enables you to configure THE with the
     default <parser>s that are more applicable for you.
     



     --------------------------------------------------------------------------
     
     
     ========================================================================
     APPENDIX 7 - REGULAR EXPRESSIONS IN THE
     ========================================================================
     
     This appendix contains details on regular expression usage in THE.  There are
     two places where THE uses regular expressions; in targets in commands like 
     <LOCATE> and <ALL>, and in the specification of patterns in THE Language
     Definition files used for syntax highlighting.
     
     THE uses the GNU Regular Expression Library to implement regular expressions. 
     This library has several different regular expression syntaxes that can be used
     when specifying targets.  
     
     Note that all pattern specifications used for syntax highlighting always uses 
     the EMACS regular expression syntax.
     
     The following table lists the features of each of the regular expression
     syntaxes that can be set via the <SET REGEXP> command.  Each feature in the
     table is explained later.
     
     This appendix is not intended to explain everything about regular expressions.
     If you want to find out more about GNU Regular Expressions, then view the on-line
     documentation at <http://hessling-editor.sf.net/doc/regex/>.
     
      +------------------------+----------------------------+
      | Syntax                 | Features                   |
      +------------------------+----------------------------+
      | EMACS                  | None set                   |
      +------------------------+----------------------------+
      | AWK                    | BACKSLASH_ESCAPE_IN_LISTS  |
      |                        | DOT_NOT_NULL               |
      |                        | NO_BACKSLASH_PARENS        |
      |                        | NO_BACKSLASH_REFS          |
      |                        | NO_BACKSLASH_VBAR          |
      |                        | NO_EMPTY_RANGES            |
      |                        | UNMATCHED_RIGHT_PAREND_ORD |
      +------------------------+----------------------------+
      | POSIX_AWK              | CHAR_CLASSES               |
      |                        | DOT_NEWLINE                |
      |                        | DOT_NOT_NULL               |
      |                        | INTERVALS                  |
      |                        | NO_EMPTY_RANGES            |
      |                        | CONTEXT_INDEP_ANCHORS      |
      |                        | CONTEXT_INDEP_OPS          |
      |                        | NO_BACKSLASH_BRACES        |
      |                        | NO_BACKSLASH_PARENS        |
      |                        | NO_BACKSLASH_VBAR          |
      |                        | UNMATCHED_RIGHT_PAREN_ORD  |
      |                        | BACKSLASH_ESCAPE_IN_LISTS  |
      +------------------------+----------------------------+
      | GREP                   | BACKSLASH_PLUS_QM          |
      |                        | CHAR_CLASSES               |
      |                        | HAT_LISTS_NOT_NEWLINE      |
      |                        | INTERVALS                  |
      |                        | NEWLINE_ALT                |
      +------------------------+----------------------------+
      | EGREP                  | CHAR_CLASSES               |
      |                        | HAT_LISTS_NOT_NEWLINE      |
      |                        | NEWLINE_ALT                |
      |                        | CONTEXT_INDEP_ANCHORS      |
      |                        | CONTEXT_INDEP_OPS          |
      |                        | NO_BACKSLASH_PARENS        |
      |                        | NO_BACKSLASH_VBAR          |
      +------------------------+----------------------------+
      | POSIX_EGREP            | CHAR_CLASSES               |
      |                        | HAT_LISTS_NOT_NEWLINE      |
      |                        | NEWLINE_ALT                |
      |                        | CONTEXT_INDEP_ANCHORS      |
      |                        | CONTEXT_INDEP_OPS          |
      |                        | NO_BACKSLASH_PARENS        |
      |                        | NO_BACKSLASH_VBAR          |
      |                        | NO_BACKSLASH_BRACES        |
      |                        | INTERVALS                  |
      +------------------------+----------------------------+
      | SED                    | CHAR_CLASSES               |
      |                        | DOT_NEWLINE                |
      |                        | DOT_NOT_NULL               |
      |                        | INTERVALS                  |
      |                        | NO_EMPTY_RANGES            |
      |                        | BACKSLASH_PLUS_QM          |
      +------------------------+----------------------------+
      | POSIX_BASIC            | CHAR_CLASSES               |
      |                        | DOT_NEWLINE                |
      |                        | DOT_NOT_NULL               |
      |                        | INTERVALS                  |
      |                        | NO_EMPTY_RANGES            |
      |                        | BACKSLASH_PLUS_QM          |
      +------------------------+----------------------------+
      | POSIX_MINIMAL_BASIC    | CHAR_CLASSES               |
      |                        | DOT_NEWLINE                |
      |                        | DOT_NOT_NULL               |
      |                        | INTERVALS                  |
      |                        | NO_EMPTY_RANGES            |
      |                        | LIMITED_OPS                |
      +------------------------+----------------------------+
      | POSIX_EXTENDED         | CHAR_CLASSES               |
      |                        | DOT_NEWLINE                |
      |                        | DOT_NOT_NULL               |
      |                        | INTERVALS                  |
      |                        | NO_EMPTY_RANGES            |
      |                        | CONTEXT_INDEP_ANCHORS      |
      |                        | CONTEXT_INDEP_OPS          |
      |                        | NO_BACKSLASH_BRACES        |
      |                        | NO_BACKSLASH_PARENS        |
      |                        | NO_BACKSLASH_VBAR          |
      |                        | UNMATCHED_RIGHT_PAREN_ORD  |
      +------------------------+----------------------------+
      | POSIX_MINIMAL_EXTENDED | CHAR_CLASSES               |
      |                        | DOT_NEWLINE                |
      |                        | DOT_NOT_NULL               |
      |                        | INTERVALS                  |
      |                        | NO_EMPTY_RANGES            |
      |                        | CONTEXT_INDEP_ANCHORS      |
      |                        | CONTEXT_INVALID_OPS        |
      |                        | NO_BACKSLASH_BRACES        |
      |                        | NO_BACKSLASH_PARENS        |
      |                        | NO_BACKSLASH_REFS          |
      |                        | NO_BACKSLASH_VBAR          |
      |                        | UNMATCHED_RIGHT_PAREN_ORD  |
      +------------------------+----------------------------+
     
     ------------
     BACKSLASH_ESCAPE_IN_LISTS
     ------------
     If this feature is not set, then \ inside a bracket expression is
     literal.
     If set, then such a \ quotes the following character.
     
     ------------
     BACKSLASH_PLUS_QM
     ------------
     If this feature is not set, then + and ? are operators, and \+ and \? are
     literals. 
     If set, then \+ and \? are operators and + and ? are literals.
     
     ------------
     CHAR_CLASSES
     ------------
     If this feature is set, then character classes are supported.  
     They are:
       [:alpha:], [:upper:], [:lower:],  [:digit:], [:alnum:], [:xdigit:],
       [:space:], [:print:], [:punct:], [:graph:], and [:cntrl:].
     If not set, then character classes are not supported.
     
     ------------
     CONTEXT_INDEP_ANCHORS
     ------------
     If this feature is set, then ^ and $ are always anchors (outside bracket
     expressions, of course). 
     If this feature is not set, then it depends:
          ^  is an anchor if it is at the beginning of a regular
             expression or after an open-group or an alternation operator;
          $  is an anchor if it is at the end of a regular expression, or
             before a close-group or an alternation operator.  
     
     This feature could be (re)combined with CONTEXT_INDEP_OPS, because
     POSIX draft 11.2 says that * etc. in leading positions is undefined.
     
     ------------
     CONTEXT_INDEP_OPS
     ------------
     If this feature is set, then special characters are always special regardless 
     of where they are in the pattern.
     If this feature is not set, then special characters are special only in some 
     contexts; otherwise they are ordinary.  Specifically, * + ? and intervals 
     are only special when not after the beginning, open-group, or alternation operator.
     
     ------------
     CONTEXT_INVALID_OPS
     ------------
     If this feature is set, then *, +, ?, and { cannot be first in an RE or immediately
     after an alternation or begin-group operator.
     
     ------------
     DOT_NEWLINE
     ------------
     If this feature is set, then . matches newline. If not set, then it does not.
     
     ------------
     DOT_NOT_NULL
     ------------
     If this feature is set, then . does not match NUL. If not set, then it does.
     
     ------------
     HAT_LISTS_NOT_NEWLINE
     ------------
     If this feature is set, nonmatching lists [^...] do not match newline. 
     If not set, they do.
     
     ------------
     INTERVALS
     ------------
     If this feature is set, either \{...\} or {...} defines an interval, depending 
     on NO_BACKSLASH_BRACES. 
     If not set, \{, \}, {, and } are literals.
     
     ------------
     LIMITED_OPS
     ------------
     If this feature is set, +, ? and | are not recognized as operators.
     If not set, they are.
     
     ------------
     NEWLINE_ALT
     ------------
     If this feature is set, newline is an alternation operator.
     If not set, newline is literal.
     
     ------------
     NO_BACKSLASH_BRACES
     ------------
     If this feature is set, then `{...}' defines an interval, and \{ and \} are literals.
     If not set, then `\{...\}' defines an interval. 
     
     ------------
     NO_BACKSLASH_PARENS
     ------------
     If this feature is set, (...) defines a group, and \( and \) are literals.
     If not set, \(...\) defines a group, and ( and ) are literals.
     
     ------------
     NO_BACKSLASH_REFS
     ------------
     If this feature is set, then \<digit> matches <digit>. If not set, then \<digit> 
     is a back-reference.
     
     ------------
     NO_BACKSLASH_VBAR
     ------------
     If this feature is set, then | is an alternation operator, and \| is literal. 
     If not set, then \| is an alternation operator, and | is literal.
     
     ------------
     NO_EMPTY_RANGES
     ------------
     If this feature is set, then an ending range point collating higher than the starting 
     range point, as in [z-a], is invalid.
     If not set, then when ending range point collates higher than the starting range 
     point, the range is ignored.
     
     ------------
     UNMATCHED_RIGHT_PAREN_ORD
     ------------
     If this feature is set, then an unmatched ) is ordinary.
     If not set, then an unmatched ) is invalid.
     



     --------------------------------------------------------------------------
     
     
     ========================================================================
     GLOSSARY
     ========================================================================
     
          block
               A portion of the file being edited; usually highlighted.
               A block can be one of <line block>, <box block>, <word block>,
               <column block>, or <stream block>.
     
          Bottom-of-File line
               A line marker, identifying the end of the file.
     
          box block
               A type of <block>.  It is a rectangular portion of the 
               <filearea>.
     
          column block
               A type of <block>.  It is similar to a <box block> except that
               a columnar portion of every line in the file is included.
     
          column target
               A method of referring to some part of a line being edited.
     
          command line
               The area of the display, usually identified by an arrow
               prompt, "====>", where THE commands are entered.
     
          current column
               The column in the <filearea>, marked by the "|" character on
               the <scale line>.
     
          current line
               The line in the <filearea>, normally highlighted, from which
               commands entered on the <command line> take effect.
     
          cursor field
               The "field" in which the cursor is currently located. This
               can be the <prefix area>, <command line> or <filearea>.
     
          filearea
               That part of the screen display where the contents of the
               file being edited are displayed.
     
          focus column
               The column in the <filearea> which currently has the focus. If
               the cursor is in the <filearea>, it is the column on which the 
               cursor is displayed. If the cursor is in the <command line> or
               <prefix area>, the focus column is the <current column>.
     
          focus line
               The line in the <filearea> which currently has the focus. If
               the cursor is in the <filearea> or <prefix area>, it is the line
               on which the cursor is displayed. If the cursor is on the
               <command line>, the focus line is the <current line>. All THE
               commands operate relative to the focus line.
     
          idline
               That part of the screen display which shows details about
               the file being edited.
     
          line block
               A type of <block>.  It consists of consecutive lines within
               the <filearea>.
     
          macro
               A file containing a sequence of THE commands. Macros can
               be written in <REXX> if a supported REXX interpreter is
               available.
     
               *** NOTE ***
     
               If REXX support is NOT enabled in THE, the first line of the THE
               macro file MUST contain the comment:
     
               /*NOREXX*/
     
          magic number
               A magic number is used on Un*x systems to identify the type of
               a file. It was originally used in binary files to identify the
               file, but the concept was also extended to text files; 
               particularly shell scripts; to enable to shell to determine
               which interpreter should be used to execute the contents of a
               file. These magic numbers in text files are really magic "strings"
               and it is these strings that are used by the THE syntax
               highlighting feature to automatically determine the <parser> to be
               used to highlight a file.
     
          message line
               That portion of the screen used to display messages.
     
          prefix area
               That part of the screen display where prefix commands can
               be entered. It also displays the line number of each line
               in the file if <SET NUMBER> is ON.
     
          parser
               A mechanism that translates text strings into identifiable
               tokens.
     
          profile
               A <macro> file that is executed at the start of an editing
               session.
     
          relative target
               A subset of <target>, but only supports targets that are
               relative to the <focus line>, like 3, -5, *.
     
          reserved line
               A line within the <filearea> that contains user text that
               the user can define with the <SET RESERVED> command.
     
          REXX
               A powerful, easy-to-learn macro language available on most
               platforms. THE uses REXX as its macro language.
     
          ring
               The set of files currently being edited are arranged in a
               ring formation.
     
          scale line
               A line in the <filearea> showing column positions.
     
          shadow line
               A line which signifies how many lines have been excluded
               from display. See <SET SHADOW>, <SET SELECT>.
     
          status line
               That part of the screen display showing details about the
               entire THE session.
     
          stream block
               A type of <block>.  It is a stream of characters that span 
               one or more consecutive lines in the <filearea>.
     
          string target
               A subset of <target> that refers to a string of characters
               enclosed between <string target delimiter>s.
     
          string target delimiter
               The character that determines the start and optional ending
               of a <string target>.  A delimiter can consist of one of the
               following characters:
                 /\@`#$%(){}[]"\<>
     
          tab line
               A line in the <filearea> which displays the currently set
               TAB stops.
     
          target
               A method of referring to some part of the file being edited.
     
          Top-of-File line
               A line marker, identifying the beginning of the file.
     
          vershift
               An internal number which defines the number of columns the
               displayed text is offset from the verify setting as a result
               of automatically scrolling horizontally, or by the use of
               the <LEFT>, <RIGHT>, or <RGTLEFT> commands.
     
          word block
               A type of <block>.  It consists of a contiguous series of
               characters that comprise a word.  A word is defined by the
               current setting of <SET WORD>.
     



     --------------------------------------------------------------------------





